unit formSxStatus;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.StdCtrls;

type
  TForm4 = class(TForm)
    Timer1: TTimer;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    StaticText8: TStaticText;
    StaticText9: TStaticText;
    Button1: TButton;
    Button2: TButton;
    Edit10: TEdit;
    Edit11: TEdit;
    Edit12: TEdit;
    Edit13: TEdit;
    Edit14: TEdit;
    Edit15: TEdit;
    Edit16: TEdit;
    Button3: TButton;
    Button4: TButton;
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

uses ComiEcatSdk;

Const
netId : Integer = 0;

var
axisId : Integer;

{$R *.dfm}

procedure TForm4.Button1Click(Sender: TObject);
var
  errorCode : LongInt;
  isServoOn : Boolean;
begin
  // Servo-On θ ȮѴ.
  isServoOn := ecmSxCtl_GetSvon(netId, axisId, @errorCode);

  if(errorCode <> 0) then
  begin
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
    exit();
  end;


  // 簪 ݴ밪 ԷѴ.
  // ex) isServoOn == false  1 Է, isServoOn == true  0Է
  if(isServoOn) then
    ecmSxCtl_SetSvon(netId, axisId, 0, @errorCode)
  else
    ecmSxCtl_SetSvon(netId, axisId, 1, @errorCode);

  if(errorCode <> 0) then
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
end;

procedure TForm4.Button2Click(Sender: TObject);
var
  errorCode : LongInt;
  slaveIndex : Integer;
begin
  //̺   īƮ ʱȭ Ѵ.
  slaveIndex := ecmGn_AxisToSlaveIndex(netId, axisId, @errorCode);

   if(errorCode <> 0) then
  begin
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
    exit();
  end;

  ecSlv_ClearComErrSum_A(netId, slaveIndex, @errorCode);

  if(errorCode <> 0) then
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
end;

procedure TForm4.Button3Click(Sender: TObject);
var
  errorCode : LongInt;
begin
  ecmSxCtl_ResetAlm(netId, axisId, @errorCode);

  if(errorCode <> 0) then
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
end;

procedure TForm4.Button4Click(Sender: TObject);
var
  errorCode : LongInt;
begin
  ecmSxSt_SetPosition(netId, axisId, 0, @errorCode);

  if(errorCode <> 0) then
    ShowMessage('ErrorCode : ' + IntToStr(errorCode));
end;

procedure TForm4.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Form4.Timer1.Enabled := false;
end;

procedure TForm4.FormShow(Sender: TObject);
begin
  form4.Edit1.Text := 'OFF';
  form4.Edit2.Text := '0';
  form4.Edit3.Text := '0';
  form4.Edit4.Text := '0';
  form4.Edit5.Text := '0';
  form4.Edit6.Text := '0';
  form4.Edit7.Text := '0';
  form4.Edit8.Text := '0';
  form4.Edit9.Text := '0';
  form4.Edit10.Text := 'OFF';
  form4.Edit11.Text := 'OFF';
  form4.Edit12.Text := 'OFF';
  form4.Edit13.Text := 'OFF';
  form4.Edit14.Text := 'OFF';
  form4.Edit15.Text := 'OFF';
  form4.Edit16.Text := 'OFF';

  axisId := 1;
  Form4.Timer1.Enabled := true;

end;

procedure TForm4.Timer1Timer(Sender: TObject);
var
  errorCode : LongInt;
  isServoOn : Boolean;
  slaveIndex : Integer;
  alState : Integer;
  slaveErrSum : LongInt;
  motorState : Integer;
  cmdPos : Double;
  curPos : Double;
  cmdSpeed : Double;
  curSpeed : Double;
  torque : Double;
  mioState : Word;
  motFlag : Word;
  i: Integer;
begin
   //   Servo On  Ȯ
  isServoOn := ecmSxCtl_GetSvon(netId, axisId, @errorCode);
  if(isServoOn = true) then
    Form4.Edit1.Text := 'ON'
  else
    Form4.Edit1.Text := 'OFF';

  //  AlState ȮѴ.
  //AlState OP ƴϸ 󱸵 ʴ´.

  //axisID ؼ slaveIndex    ִ.
  //_A   Լ slaveIndex Ű . (slaveIndex )
  //_A    Լ Physical Address Ű .
  slaveIndex := ecmGn_AxisToSlaveIndex(netId, axisId, @errorCode);
  alState := ecSlv_GetAlState_A(netId, slaveIndex, @errorCode);
  // Physical Address ϴ  Ʒ ڵ带 ϴ  .
  // alState := ecSlv_GetAlState(netId, address, @errorCode);
  Form4.Edit9.Text := IntToStr(alState);

  //   īƮ  ȮѴ.
  slaveErrSum := ecSlv_GetComErrSum_A(netId, slaveIndex, @errorCode);
  Form4.Edit8.Text := IntToStr(slaveErrSum);

  //   ¸ ȮѴ.
  //ȯ ǹ̴ EEcmMotStateId  Ѵ.
  //ȯ 0  ڵ带 ǹѴ.
  motorState := ecmSxSt_GetMotState(netId, axisId, @errorCode);
  form4.Edit7.Text := IntToStr(motorState);

  //  Command Position ȮѴ.
  cmdPos := ecmSxSt_GetPosition(netId, axisId, 0, @errorCode);
  Form4.Edit2.Text := FloatToStr(cmdPos);

  //  Current Position (Actual Position Ǵ Feedback Position)  ȮѴ.
  //ش簪 ö ʴ´ٸ PDOʿ 0x6064 (Position Actual Value) Ե  ̴.
  curPos := ecmSxSt_GetPosition(netId, axisId, 1, @errorCode);
  Form4.Edit3.Text := FloatToStr(curPos);

  //  Command Speed ȮѴ.
  cmdSpeed := ecmSxSt_GetCurSpeed(netId, axisId, 0, @errorCode);
  Form4.Edit4.Text := FloatToStr(cmdSpeed);

  //  Current Position (Actual Position Ǵ Feedback Position)  ȮѴ.
  //ش簪 ö ʴ´ٸ PDOʿ 0x606C (Velocity Actual Value) Ե  ̴.
  curSpeed := ecmSxSt_GetCurSpeed(netId, axisId, 1, @errorCode);
  Form4.Edit5.Text := FloatToStr(curSpeed);

  //  Torque ȮѴ.
  //ش簪 ö ʴ´ٸ PDOʿ 0x6077 (Torque Actual Value) Ե  ̴.
  torque := ecmSxSt_GetCurTorque(netId, axisId, @errorCode);
  Form4.Edit6.Text := FloatToStr(torque);

  //PDO https://winoar.com/dokuwiki/platform:ethercat:2_config:guide:processdata 

  //public struct TEcmSxSt_DI
  //      {
  //          public ushort word;
  //          public ushort NOT { get { return SafeNativeMethods.GetBit(word, 0); } }
  //          public ushort POT { get { return SafeNativeMethods.GetBit(word, 1); } }
  //          public ushort HOME { get { return SafeNativeMethods.GetBit(word, 2); } }
  //          public ushort INP { get { return SafeNativeMethods.GetBit(word, 3); } }
  //          public ushort b4 { get { return SafeNativeMethods.GetBit(word, 4); } }
  //          public ushort b5 { get { return SafeNativeMethods.GetBit(word, 5); } }
  //      }
  //Servo Էµ Digital Input  ȮѴ.
  miostate := ecmSxSt_GetDI(netId, axisId, @errorCode);

  for i := 0 to 5 do
  begin
    if(((mioState shr i) and 1) = 1) then
    begin
      case i of
        0: Form4.Edit10.Text := 'ON';
        1: Form4.Edit11.Text := 'ON';
        2: Form4.Edit12.Text := 'ON';
        3: Form4.Edit13.Text := 'ON';
      end;
    end
    else
    begin
      case i of
        0: Form4.Edit10.Text := 'OFF';
        1: Form4.Edit11.Text := 'OFF';
        2: Form4.Edit12.Text := 'OFF';
        3: Form4.Edit13.Text := 'OFF';
      end;
    end;
  end;

  //public struct TEcmSxSt_Flags
  //      {
  //          public ushort word;
  //          public ushort RdyToSwOn { get { return SafeNativeMethods.GetBit(word, 0); } }
  //          public ushort SwOn { get { return SafeNativeMethods.GetBit(word, 1); } }
  //          public ushort OperEnabled { get { return SafeNativeMethods.GetBit(word, 2); } }
  //          public ushort ServoFault { get { return SafeNativeMethods.GetBit(word, 3); } }
  //          public ushort VoltEnabled { get { return SafeNativeMethods.GetBit(word, 4); } }
  //          public ushort QuickStop { get { return SafeNativeMethods.GetBit(word, 5); } }
  //          public ushort SwOnDisabled { get { return SafeNativeMethods.GetBit(word, 6); } }
  //          public ushort ServoWarn { get { return SafeNativeMethods.GetBit(word, 7); } }
  //          public ushort CtlrFault { get { return SafeNativeMethods.GetBit(word, 8); } }
  //          public ushort HomeError { get { return SafeNativeMethods.GetBit(word, 9); } }
  //          public ushort OMS1 { get { return SafeNativeMethods.GetBit(word, 10); } }
  //          public ushort IntLimit { get { return SafeNativeMethods.GetBit(word, 11); } }
  //          public ushort OMS2 { get { return SafeNativeMethods.GetBit(word, 12); } }
  //          public ushort HomeBusy { get { return SafeNativeMethods.GetBit(word, 14); } }
  //          public ushort HomeAttained { get { return SafeNativeMethods.GetBit(word, 15); } }
  //      }
  //Servo ¿   Flag Ȯմϴ.
  motFlag := ecmSxSt_GetFlags(netId, axisId, @errorCode);

  for i := 0 to 15 do
  begin
    if(((motFlag shr i) and 1) = 1) then
    begin
      case i of
        0: Form4.Edit14.Text := 'ON';
        7: Form4.Edit15.Text := 'ON';
        3: Form4.Edit16.Text := 'ON';
      end;
    end
    else
    begin
      case i of
        0: Form4.Edit14.Text := 'OFF';
        7: Form4.Edit15.Text := 'OFF';
        3: Form4.Edit16.Text := 'OFF';
      end;
    end;
  end;

end;

end.
