﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

using ec = SoftECAT.SafeNativeMethods;


// 디바이스 초기화에 대한 예제

namespace EtherCAT_Examples_CSharp
{
    public partial class formInitialize : Form
    {
        public formInitialize()
        {
            InitializeComponent();
        }

        int netID = 0;
        int errorCode = 0;
        List<int> initAddrList = new List<int>();

        private void btnInitialize_Click(object sender, EventArgs e)
        {
            devInit();
        }

    #region AddLog
    
        private void AddLog(int errorCode)
        {
            if (errorCode == 0)
                return;

            if (lbxLog.InvokeRequired)
            {
                lbxLog.BeginInvoke(new Action(() =>
                {
                    lbxLog.Items.Add(errorCode.ToString());
                    lbxLog.SelectedIndex = lbxLog.Items.Count - 1;
                }));
            }
            else
            {
                lbxLog.Items.Add(errorCode.ToString());
                lbxLog.SelectedIndex = lbxLog.Items.Count - 1;
            }
        }


        private void AddLog(string errorString)
        {
            if (lbxLog.InvokeRequired)
            {
                lbxLog.BeginInvoke(new Action(() =>
                {
                    lbxLog.Items.Add(errorString);
                    lbxLog.SelectedIndex = lbxLog.Items.Count - 1;
                }));
            }
            else
            {
                lbxLog.Items.Add(errorString);
                lbxLog.SelectedIndex = lbxLog.Items.Count - 1;
            }
        }

    #endregion

        private void devInit()
        {
            // Device를 load한다.
            try
            {
                if (!ec.ecGn_LoadDevices(ref errorCode))
                {
                    AddLog(errorCode);
                    return;
                }
            }
            catch (BadImageFormatException)
            {
                MessageBox.Show(string.Format("ecGn_LoadDevice Failed : DLL 버전(x86/x64)이 OS와 맞지 않습니다."));
                return;
            }
            catch (DllNotFoundException)
            {
                MessageBox.Show(string.Format("ecGn_LoadDevice Failed : DLL을 찾을 수 없습니다."));
                return;
            }
            catch (Exception ex)
            {
                MessageBox.Show(string.Format("ecGn_LoadDevices Failed : Exception - {0}", ex.ToString()));
                return;
            }
            
            
            // 현재 네트워크에 연결되어 있는 slave 수를 확인한다.
            uint slaveCount = ec.ecNet_ScanSlaves(netID, ref errorCode);
            if (errorCode != 0)
            {
                AddLog(errorCode);
                return;
            }

            // 스캔된 슬레이브의 수가 define된 슬레이브의 수와 일치하는지 확인한다.
#if false
            
            int definedSlaveCount = 5;
            // 설정된 모듈 수만큼 스캔되었는지 확인한다.
            if (definedSlaveCount != slaveCount)
            {
                AddLog("현재 스캔된 슬레이브의 모듈 수와 정의된 슬레이브의 모듈 수가  다릅니다.");
                AddLog(string.Format("ScanSlave : {0}. definedSlaveCount : {1}", slaveCount, definedSlaveCount));
                AddLog("전원이 들어가지 않았거나 네트워크와 연결되지 않은 슬레이브 모듈이 있는지 확인하시기 바랍니다.");                
                return;
            }


#endif

            // 모든 모듈이 alState가 OP가 되었는지 확인한다.
            // alState가 OP가 아닌 슬레이브는 pdo를 통한 제어가 되지 않는다.

            Stopwatch sw = new Stopwatch();
            sw.Start();

            ec.TEcSlvState slaveState = new ec.TEcSlvState();
            bool isSuccess = false;            
            while (sw.ElapsedMilliseconds < 10000 && !isSuccess)
            {
                isSuccess = true;
                // 첫번째 슬레이브의 Index는 1이다.
                // 0은 사용하지 않는다. (마스터를 의미함)
                for (int i = 1; i < slaveCount + 1; i++)
                {
                    ec.ecSlv_GetState_A(netID, i, ref slaveState, ref errorCode);
                    if (slaveState.state != 8)
                    {
                        isSuccess = false;
                        break;
                    }
                }
                Thread.Sleep(200);
            }

            if (!isSuccess)
            {
                for (int i = 1; i < slaveCount + 1; i++)
                {
                    ec.ecSlv_GetState_A(netID, i, ref slaveState, ref errorCode);
                    if (slaveState.state != 8)
                        AddLog(string.Format("슬레이브 : {0} 의 AlState가 OP가 아닙니다.", i));
                }

                return;
            }

            AddLog("Initialize 성공");
        }
    }
}
