﻿#define usingMulti
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Threading;

using ec = SoftECAT.SafeNativeMethods;

namespace EtherCAT_Examples_CSharp
{
    // IO 관련 함수군은 Global Channel(전역 번호) 함수군과 Local Channel(지역 채널) 함수군으로 구분된다.
    // Global 함수군은 네트워크에 연결된 모든 채널을 종합하여 채널 번호를 할당한다. (DI 와 Do 는 구분)
    // Local 함수군은 각각의 슬레이브에 독립적으로 채널 번호를 할당한다. (모든 슬레이브의 첫번 째 채널값이 0)
    // Global 함수군은 슬레이브의 연결 순서 변경, 통신 문제 등에 의해 의도치 않은 값으로 확인될 가능성이 있으므로
    // 가능한 Local 함수군을 사용하는 것이 좋다.

    public partial class formDio : Form
    {
        public formDio()
        {
            InitializeComponent();
            if (UpdateForm())
            {
                t_Di.Start();
                t_Do.Start();
            }
        }

    #region base

        int netID = 0;
        int errorCode = 0;
        


        void AddLog(int errorCode)
        {
            MessageBox.Show(string.Format("ErrorCode : {0}", errorCode));
        }

        #endregion

        int diChCount = 0;
        int doChCount = 0;

        private bool UpdateForm()
        {
            if (!ec.ecGn_LoadDevices(ref errorCode))
                return false;

            // 네트워크에 연결된 총 DI 채널 갯수를 확인한다.
            diChCount = ec.ecdiGetNumChannels(netID, ref errorCode);
            tbxDiCount.Text = diChCount.ToString();

            // 네트워크에 연결된 총 DO 채널 갯수를 확인한다.
            doChCount = ec.ecdoGetNumChannels(netID, ref errorCode);
            tbxDoCount.Text = doChCount.ToString();

            // UI 처리용 (CheckBox의 TabIndex 활용)
            int index = 0;
            int tt = 0;
            var t = gbxDo.Controls.OfType<CheckBox>().ToList();
            t.ForEach(x => x.TabIndex = tt++);
            gbxDo.Controls.OfType<CheckBox>().ToList().ForEach(x => x.TabIndex = index++);
            return true;
        }

    #region DI
        
        private void t_Di_Tick(object sender, EventArgs e)
        {
            uint InitChannel = 0;
            byte numChannel = 0;
            uint diVal = 0;

            uint.TryParse(tbxDiInitCh.Text, out InitChannel);
            byte.TryParse(tbxDiNumCh.Text, out numChannel);
                        
            if (numChannel > 16)
                numChannel = 16;
            if (InitChannel + numChannel > diChCount)
                numChannel = (byte)(diChCount - InitChannel);

            // 본 예제에서는 InitChannel 부터 numChannel 만큼의 Di Channel값을 확인한다.
            // 32채널까지 한번에 확인할 수 있으며, 예제에서는 numChannel이 16보다 큰 경우 16개만 확인한다.

            // InitChannel : 입력 상태를 확인할 시작 채널 번호
            // NumChannel : 입력 상태를 확인할 채널의 수
            // Return 값의 각 비트값이 채널값이다 ex) 첫번째 비트값이 InitChannel에 해당하는 채널의 신호상태 값

#if usingMulti
            diVal = ec.ecdiGetMulti(netID, InitChannel, numChannel, ref errorCode);                               
            
            if (errorCode != 0) //에러처리
            {
                AddLog(errorCode);
                t_Di.Enabled = false;
                return;
            }

             // UI 처리. 본 기능과 관련 없음
            var chks = gbxDi.Controls.OfType<CheckBox>().ToList();
            for (int i = 0; i < numChannel; i++)
            {
                chks[i].Text = string.Format("Ch {0:00}", InitChannel + i);
                chks[i].Checked = ((diVal >> i) & 1) == 1;
            }

#else // 채널별 확인

            // UI 처리. 본 기능과 관련 없음
            var chks = gbxDi.Controls.OfType<CheckBox>().ToList();
            
            bool isOn = false;
            for(uint i = InitChannel; i < InitChannel + numChannel; i++)
            {
                isOn = ec.ecdiGetOne(netID, i, ref errorCode);

                // UI 처리. 본 기능과 관련 없음
                chks[(int)(i - InitChannel)].Text = string.Format("Ch {0:00}", i);
                chks[(int)(i - InitChannel)].Checked = isOn;
            }

            
#endif
            
        }

        private void tbxDiNumCh_TextChanged(object sender, EventArgs e)
        {
            // UI 처리

            byte numChannel = 0;
            byte.TryParse(tbxDiNumCh.Text, out numChannel);

            var chks = gbxDi.Controls.OfType<CheckBox>().ToList();

            for (int i = 0; i < numChannel; i++)
                chks[i].Enabled = true;

            for (int i = numChannel; i < 16; i++)
                chks[i].Enabled = false;
        }

#endregion


        private void tbxDoNumCh_TextChanged(object sender, EventArgs e)
        {
            // UI 처리

            byte numChannel = 0;
            byte.TryParse(tbxDiNumCh.Text, out numChannel);

            var chks = gbxDo.Controls.OfType<CheckBox>().ToList();

            for (int i = 0; i < numChannel; i++)
                chks[i].Enabled = true;

            for (int i = numChannel; i < 16; i++)
                chks[i].Enabled = false;
        }

        private void DoCh_Click(object sender, EventArgs e)
        {
           
        }

        private void DoCh_CheckedChanged(object sender, EventArgs e)
        {
            // CheckBox 의 Check 상태를 확인한다.
            bool outState = (sender as CheckBox).Checked;

            // UI 처리용
            int InitCh = 0;
            int.TryParse(tbxDiInitCh.Text, out InitCh);
            uint doCh = (uint)((sender as CheckBox).TabIndex + InitCh);

            // 선택된 채널의 출력값을 변경한다.
            ec.ecdoPutOne(netID, doCh, outState, ref errorCode);
            if (errorCode != 0) // 에러처리
                AddLog(errorCode);
        }
        

        private void t_Do_Tick(object sender, EventArgs e)
        {
            uint InitChannel = 0;
            byte numChannel = 0;

            uint.TryParse(tbxDoInitCh.Text, out InitChannel);
            byte.TryParse(tbxDoNumCh.Text, out numChannel);

            if (numChannel > 16)
                numChannel = 16;
            if (InitChannel + numChannel > doChCount)
                numChannel = (byte)(doChCount - InitChannel);

            // 본 예제에서는 InitChannel 부터 numChannel 만큼의 Do Channel값을 확인한다.
            // 32채널까지 한번에 확인할 수 있으며, 예제에서는 numChannel이 16보다 큰 경우 16개만 확인한다.

            // InitChannel : 입력 상태를 확인할 시작 채널 번호
            // NumChannel : 입력 상태를 확인할 채널의 수
            // Return 값의 각 비트값이 채널값이다 ex) 첫번째 비트값이 InitChannel에 해당하는 채널의 신호상태 값

#if usingMulti
            uint doVal = ec.ecdoGetMulti(netID, InitChannel, numChannel, ref errorCode);
            if (errorCode != 0) //에러처리
            {
                AddLog(errorCode);
                t_Do.Enabled = false;
                return;
            }

            // UI 처리. 본 기능과 관련 없음
            var chks = gbxDo.Controls.OfType<CheckBox>().ToList();
            for (int i = 0; i < numChannel; i++)
            {
                chks[i].Text = string.Format("Ch {0:00}", InitChannel + i);
                chks[i].Checked = ((doVal >> i) & 1) == 1;
            }

#else // 채널별 확인

            // UI 처리. 본 기능과 관련 없음
            var chks = gbxDo.Controls.OfType<CheckBox>().ToList();
            
            bool isOn = false;
            for(uint i = InitChannel; i < InitChannel + numChannel; i++)
            {
                isOn = ec.ecdoGetOne(netID, i, ref errorCode);

                // UI 처리. 본 기능과 관련 없음
                chks[(int)(i - InitChannel)].Text = string.Format("Ch {0:00}", i);
                chks[(int)(i - InitChannel)].Checked = isOn;
            }

            
#endif
        }

        
    }
}
