#ifndef _MICOMMON_DEFINES_H_ // #@1
#define _MICOMMON_DEFINES_H_

// Ethernet 
#define UDP_PORT0	35040 // ߿ Ʈ  Ʈ.
#define UDP_PORT1	3000
#define TCP_PORT	3000


// Serial 
#define SERIAL_CH_TEMP		1;
#define SERIAL_CH_USF		2;



#include ".\\mk_lib\\mk_common.h"

typedef struct{
	t_ui16 reserved;
}TConfData;

//  ȣ 
enum {DI00=0, DI01, DI02, DI03, DI04, DI05, DI06, DI07, DI08, DI09, DI10, DI11, DI12, DI13, DI14, DI15,
	  DI16, DI17, DI18, DI19, DI20, DI21, DI22, DI23, DI24, DI25, DI26, DI27, DI28, DI29, DI30, DI31=31};
enum {DO00=0, DO01, DO02, DO03, DO04, DO05, DO06, DO07, DO08, DO09, DO10, DO11, DO12, DO13, DO14, DO15
};

//  alias
#define DI_FRONT_LOCK_CHECK_SENSOR		DI00	// front lock check Sensor (stk side, B)
#define DI_REAR_LOCK_CHECK_SENSOR		DI01	// rear lock check sensor (sky cvy side, B)
#define DI_MGZ_EMPTY_CHECK_SENSOR		DI02	// Destination Sensor or magazine empty check sensor
#define DI_FRONT_CLAMP_FWD_SENSOR		DI03	// front clamp forward sensor
#define DI_FRONT_CLAMP_BWD_SENSOR		DI04	// front clamp backward sensor
#define DI_REAR_CLAMP_CLOSE_SENSOR		DI05	// rear clamp forward sensor
#define DI_REAR_CLAMP_OPEN_SENSOR		DI06	// rear clamp backward sensor
#define DI_SPARE01						DI07	// spare
#define DI_WAITTING_FWD_SENSOR			DI08	// waitting forward sensor or destination sensor
#define DI_WAITTING_BWD_SENSOR			DI09	// waitting backward sensor
#define DI_FRONT_LOCK_FWD_SENSOR		DI10	// front lock forward sensor
#define DI_FRONT_LOCK_BWD_SENSOR		DI11	// front lock backward sensor
#define DI_REAR_LOCK_FWD_SENSOR			DI12	// rear lock forward sensor
#define DI_REAR_LOCK_BWD_SENSOR			DI13	// rear lock backward sensor
#define DI_SPARE02						DI14	// spare
#define DI_SPARE03						DI15	// spare
#define DI_ALIGN_BWD_SENSOR				DI16	// align backward sensor
#define DI_ALIGN_FWD_SENSOR				DI17	// align forward sensor
#define DI_SPARE04						DI18	// spare
#define DI_SPARE05						DI19	// spare
#define DI_SPARE06						DI20	// spare
#define DI_SPARE07						DI21	// spare
#define DI_SPARE08						DI22	// spare
#define DI_SPARE09						DI23	// spare
#define DI_SPARE10						DI24	// spare
#define DI_SPARE11						DI25	// spare
#define DI_PIO_INPUT_TRREQ				DI26	// sky cvy  û.
#define DI_PIO_INPUT_BUSY				DI27	// sky cvy .
#define DI_PIO_OUTPUT_TACK				DI28	// stk  㰡 
#define DI_PIO_OUTPUT_COMPT				DI29	// stk  Ϸ
#define DI_PIO_RESERVED1				DI30	// reserved
#define DI_PIO_RESERVED2				DI31	// reserved

#define DO_FRONT_LOCK_SOL_RUN			DO00	// locker sol 
#define DO_REAR_LOCK_SOL_RUN			DO01	// locker sol 
#define DO_WAIT_SOL_RUN					DO02	// waiting sol 
#define DO_FRONT_CLAMP_SOL_RUN			DO03	// front clamp sol 
#define DO_REAR_CLAMP_SOL_RUN			DO04	// rear clamp sol 
#define DO_ALIGN_SOL_RUN				DO05	// align sol 

#define DO_PIO_INPUT_TACK				DO08	// sky cvy -> locker  㰡
#define DO_PIO_INPUT_COMPT				DO09	// sky cvy -> locker  Ϸ
#define DO_PIO_OUTPUT_TRREQ				DO10	// locker -> stk  û
#define DO_PIO_OUTPUT_BUSY				DO11	// locker -> stk 
#define DO_FORWARD_MGZ_ARR				DO15	// DI_MGZ_EMPTY_CHECK_SENSOR ȣ ¸ ״  (ܺ   뵵) ش.

enum {CV_CW, CV_CCW}; // Conveyor 
enum {S_OFF, S_ON}; //  On/Off .

enum {SEQ_TYPE_WAIT, SEQ_TYPE_TEST}; // Seqnence type

// Seq Index //
enum {
	RDYTRANS_STEP_IDLE = 0,
	RDYTRANS_STEP_LOCKCYL_BWD,
	RDYTRANS_STEP_ALIGN_BWD,
	RDYTRANS_STEP_DELAY1,
	RDYTRANS_STEP_CLAMP_BWD,
	RDYTRANS_STEP_WAITCYL_OPEN,
	RDYTRANS_STEP_CHECK_WAITCYL_OPEN
};


// Alarm codes //
enum _TEnumAlarmCodes{
	ACODE_ERR_NONE = 0,
	//-------- CONTROLLER ALARM ---------------------------------------------------//
	ACODE_SYSINT_TIMER0_DEAD=500,
	ACODE_SYSINT_TIMER1_DEAD,		// Timer1 interrupt loop is dead
	ACODE_SYSINT_MAIN_LOOP_DEAD,	// Main() process loop is dead
	ACODE_SYSINT_MOT_DEV_FAIL,		// Motion device ν ҷ 
	ACODE_SYSINT_SER_DEV_FAIL,		// Serial device ν ҷ 
	ACODE_SYSINT_ETHERNET_DEV_FAIL,	// Ethernet device ν ?
	ACODE_SYSINT_RFID_COM_FAULT,	// RFID ſ ߻
	ACODE_SYSINT_GOT_COM_FAULT,		// GOT š?߻
	ACODE_SYSINT_SERVO_COM_FAULT,	// SERVO ſ ߻
	//-------- OPERATION ALARM ---------------------------------------------------//
	ACODE_EMG_SWITCH=520,
	ACODE_OPERATOR_STOP,			// Operator  
	ACODE_ALIGN_SENSOR_DOUBLE,
	ACODE_WAIT_SENSOR_DOUBLE,		// wait sensor  FWD, BWD Ѵ  .
	ACODE_LOCK_SENSOR_DOUBLE,		// lock sensor fwd/bwd ߺ .
	ACODE_CLAMP_SENSOR_DOUBLE,		// clamp lock  unlock  ΰ  on ̴.
	ACODE_WAIT_SOL_POS_FAULT,		// Wait Ǹ ġ ùٸ  .
	ACODE_FRONT_CLAMP_SOL_POS_FAULT,// Front-clamp Ǹ ġ ùٸ  .
	ACODE_REAR_CLAMP_SOL_POS_FAULT,	// Rear-clamp Ǹ ġ ùٸ  . 
	ACODE_FRONT_LOCK_CHECK_SOL_POS_FAULT, // Front-lock üũ Ǹ ġ ùٸ  .

	ACODE_REAR_LOCK_CHECK_SOL_POS_FAULT, // Rear-lock üũ Ǹ ġ ùٸ  .
	ACODE_ALIGN_SOL_POS_FAULT,		// Aligner Ǹ ġ ùٸ  .
	ACODE_MGZ_ARRIVE_TIMEOUT,		// magazine  ŸӾƿ.
	ACODE_WAIT_CYL_TIMEOUT,			// Wait Ǹ  ŸӾƿ
	ACODE_CLAMP_TIMEOUT,			// Clamp ŸӾƿ
	ACODE_LOCK_SOL_TIMEOUT,			// Lock Ǹ  ŸӾƿ 
	ACODE_PIO_BUSY_TIMEOUT, 		// PIO Busy ȣ üũ Ÿ ƿ.
	ACODE_PIO_TREQ_ABNORMAL_OFF,	// PIO-TREQ ȣ  OFF.
	ACODE_PIO_LP1_SENSOR_TIMEOUT, 	// LP side ù°    ŸӾƿ.
	ACODE_PIO_COMP_ACK_TIMEOUT,		// PIO-COMPT ȣ ON   ð ȿ PIO-TREQ OFF .

	ACODE_PIO_TACK_TIMEOUT,			// pio tr req   ack ŸӾƿ.
	ACODE_PIO_COMPT_TIMEOUT,		// pio tr complete   ŸӾƿ.
	ACODE_LOCK_FAULT_ACK_TIMEOUT,	// LOCK_FAULT_ACK ŵͰ  ðȿ ŵ .
	ACODE_ABNORMAL_MGZ_DETECTED,	// MGZ  ϴ Ȳ Ǵ .

	ACODE_HOST_DISCONNECTED=599
};


//****************************** Serial  ************************************************************//
// Ethernet
#define TCP_BUF_MAX		512


// USF Protocal //
#define GC_USF_HEAD		0x40   		// '@'
#define GC_USF_SEP1		0x3D		// '='
#define GC_USF_SEP2		0x3B		// ';'
#define GC_USF_TERM		0x0D		// Termination

// Serial Comm. Unit з 
enum { SDC_TEMP = 1, USF_FLOW, HORIBA_DENSITY };


#endif // #@1
