/*-----------------------------------------------------------------------------------------
------	
------	ecat_def.h
------   
-----------------------------------------------------------------------------------------*/

#ifndef _ECATDEF_H_
#define _ECATDEF_H_

/*-----------------------------------------------------------------------------------------
------	
------	Includes
------ 
-----------------------------------------------------------------------------------------*/
#include <stdlib.h>
#include <string.h>

/* ESC_EEPROM_SIZE: Specify the EEPROM size in Bytes of the connected EEPROM or the emulated EEPROM. */
#define ESC_EEPROM_SIZE                           0x800

/* EEPROM_READ_SIZE: Only required if EEPROM emulation is active. This value defines the number of bytes which will be read per opertion. */
#define EEPROM_READ_SIZE                          0x8

/* EEPROM_WRITE_SIZE: Only required if EEPROM emulation is active. This value defines the number of bytes which will be written per opertion. */
#define EEPROM_WRITE_SIZE                         0x2

#define PREOPTIMEOUT                              0x7D0
#define SAFEOP2OPTIMEOUT                          0x2328
/*-----------------------------------------------------------------------------------------
------	
------	Compiler Defines
------	
-----------------------------------------------------------------------------------------*/

/* FALSE: Will be used for variables from type BOOL */
#define FALSE                                     0

/* TRUE: Will be used for variables from type BOOL  */
#define TRUE                                      1

/* BOOL: Should be adapted to the boolean type of the microcontroller */
#define BOOL                                      unsigned char

/* UINT8: Should be adapted to the unsigned8 type of the microcontroller  */
#define UINT8                                     unsigned char

/* UINT16: Should be adapted to the unsigned16 type of the microcontroller  */
#define UINT16                                    unsigned short

/* UINT32: Should be adapted to the unsigned32 type of the microcontroller  */
#define UINT32                                    unsigned int

/* USHORT: Should be adapted to the unsigned16 type of the microcontroller */
#define USHORT                                    unsigned short

/* INT8: Should be adapted to the integer8 type of the microcontroller */
#define INT8                                      char

/* INT16: Should be adapted to the integer16 type of the microcontroller  */
#define INT16                                     short

/* INT32: Should be adapted to the integer32 type of the microcontroller */
#define INT32                                     int

/* CHAR: Should be adapted to the character type of the microcontroller */
#define CHAR                                      char

/* UCHAR: Should be adapted to the unsigned character type of the microcontroller */
#define UCHAR                                     unsigned char

#define REAL32                                   float
#define REAL64                                   double

/* SIZEOF(x): Used to calculate the size in Bytes */
#define SIZEOF(x)                                 sizeof(x)

/* HUGE: Should be adapted to the huge type of the microcontroller, if the microcontroller
does not support a huge type, HUGE shall be defined to nothing */
#define HUGE 

/* HMEMSET: Should be defined to the memset function for huge memory, if the microcontroller
does not support a huge type, HMEMSET shall be defined to a 'normal' memset function */
#define HMEMSET                                   memset

/* HMEMCPY: Should be defined to the memcpy function for huge memory, if the microcontroller
does not support a huge type, HMEMCPY shall be defined to a 'normal' memcpy function */
#define HMEMCPY                                   memcpy

/* HMEMCMP: Should be defined to the memcmp function for huge memory, if the microcontroller
does not support a huge type, HMEMCMP shall be defined to a 'normal' memcmp function */
#define HMEMCMP                                   memcmp

/* ESCMEM: Should be defined to select the memory type of the ESC memory (e.g. near, far or huge), if the microcontroller
does not support different memory types, ESCMEM shall be defined to nothing */
#define ESCMEM 

/* ESCMEMCPY: Should be defined to the memcpy function for ESCMEM memory, if the microcontroller
does not support different memory types, ESCMEMCPY shall be defined to a 'normal' memcpy function */
#define ESCMEMCPY                                 memcpy

/* ESCMEMSET: Should be defined to the memset function for ESCMEM memory, if the microcontroller
does not support different memory types, ESCMEMSET shall be defined to a 'normal' memset function */
#define ESCMEMSET                                 memset

/* ESCMBXMEMCPY: Should be defined to the memcpy function for copying ESCMEM memory to or from MBXMEM memory, if the microcontroller
does not support different memory types, ESCMBXMEMCPY shall be defined to a 'normal' memcpy function */
#define ESCMBXMEMCPY                              memcpy

/* MBXMEM: Should be defined to select the memory type of the memory used for mailbox communication (e.g. near, far or huge), 
if the microcontroller does not support different memory types, MBXMEM shall be defined to nothing */
#define MBXMEM 

/* MBXMEMCPY: Should be defined to the memcpy function for MBXMEM memory, if the microcontroller
does not support different memory types, MBXMEMCPY shall be defined to a 'normal' memcpy function */
#define MBXMEMCPY                                 memcpy

/* MBXMEMCMP: Should be defined to the memcmp function for MBXMEM memory, if the microcontroller
does not support different memory types, MBXMEMCMP shall be defined to a 'normal' memcmp function */
#define MBXMEMCMP                                 memcmp

/* MBXMEMSET: Should be defined to the memcpy function for MBXMEM memory, if the microcontroller
does not support different memory types, MBXMEMSET shall be defined to a 'normal' memset function */
#define MBXMEMSET                                 memset

/* MBXSTRLEN: Should be defined to the strlen function for MBXMEM memory, if the microcontroller
does not support different memory types, MBXSTRLEN shall be defined to a 'normal' strlen function */
#define MBXSTRLEN                                 strlen

/* MBXSTRCPY: Should be defined to the strcpy function for MBXMEM memory, if the microcontroller
does not support different memory types, MBXSTRCPY shall be defined to a 'normal' strcpy function */
#define MBXSTRCPY                                 memcpy

/* OBJCONST: Should be used to define the object dictionary in ROM (f.e. define OBJCONST const) or
in RAM (e.g. define OBJCONST) */
#define OBJCONST                                  const

/* VARCONST: Should be used to define the constant variables in ROM (f.e. define VARCONST const) or
in RAM (e.g. define VARCONST) */
#define VARCONST 

/* VARVOLATILE: Should be used to prevent dummy variables to be deleted due to compiler optimization.  */
#define VARVOLATILE                               volatile

/* OBJMEM: Should be defined to select the memory type of the memory used for the object dictionary (e.g. near, far or huge), 
if the microcontroller does not support different memory types, OBJMEM shall be defined to nothing */
#define OBJMEM 

/* OBJTOMBXMEMCPY: Should be defined to the memcpy function for copying OBJMEM memory to MBXMEM memory, if the microcontroller
does not support different memory types, OBJTOMBXMEMCPY shall be defined to a 'normal' memcpy function */
#define OBJTOMBXMEMCPY                            memcpy

/* OBJTOMBXSTRCPY: Should be defined to the strcpy function for copying OBJMEM memory to MBXMEM memory, if the microcontroller
does not support different memory types, OBJTOMBXSTRCPY shall be defined to a 'normal' memcpy function */
#define OBJTOMBXSTRCPY                            memcpy

/* OBJMEMCPY: Should be defined to the memcpy function for OBJMEM memory, if the microcontroller
does not support different memory types, OBJMEMCPY shall be defined to a 'normal' memcpy function */
#define OBJMEMCPY                                 memcpy

/* OBJSTRLEN: Should be defined to the strlen function for OBJMEM memory, if the microcontroller
does not support different memory types, OBJSTRLEN shall be defined to a 'normal' strlen function */
#define OBJSTRLEN                                 strlen

/* OBJSTRCPY: Should be defined to the strcpy function for OBJMEM memory, if the microcontroller
does not support different memory types, OBJSTRCPY shall be defined to a 'normal' strcpy function */
#define OBJSTRCPY                                 memcpy

/* MAKE_HUGE_PTR: Should be defined to the initialize a pointer variable with an absolute address */
#define MAKE_HUGE_PTR                             _mkhp

/* MAKE_PTR_TO_ESC: Should be defined to the initialize the pointer to the ESC */
#define MAKE_PTR_TO_ESC 

/* EMCYMEMCPY: Should be defined to the memcpy function for EMCYMEM memory, if the microcontroller
does not support different memory types, EMCYMEMCPY shall be defined to a 'normal' memcpy function */
#define EMCYMEMCPY                                memcpy

/* EMCYMEMSET: Should be defined to the memset function for EMCYMEM memory, if the microcontroller
does not support different memory types, EMCYMEMSET shall be defined to a 'normal' memcset function */
#define EMCYMEMSET                                memset

/* EMCYMEM: Should be defined to select the memory type of the memory used for the emergencies (e.g. near, far or huge), 
if the microcontroller does not support different memory types, EMCYMEM shall be defined to nothing */
#define EMCYMEM 

/* MEMCPY: Should be defined to copy data within local memory. */
#define MEMCPY                                    memcpy

/* ALLOCMEM(size): Should be defined to the alloc function to get dynamic memory */
#define ALLOCMEM(size)                            malloc((size))

/* FREEMEM(pointer): Should be defined to the free function to put back dynamic memory */
#define FREEMEM(pointer)                          free((pointer))

/* VARMEMSET: Should be defined to the memset function for VARMEM memory, if the microcontroller
does not support different memory types, EMCYMEMSET shall be defined to a 'normal' memcset function */
#define VARMEMSET                                 memset

/* VARMEM: Should be defined to select the memory type of the memory used for dynamic memory (e.g. near, far or huge), 
if the microcontroller does not support different memory types, VARMEM shall be defined to nothing */
#define VARMEM 

/* MEM_ADDR: Type to access local memory addresses */
#define MEM_ADDR                                  UINT16

/* GET_MEM_SIZE(ByteSize): Round up the byte size to next matching memory boundary depending on "MEM_ADDR" */
#define GET_MEM_SIZE(ByteSize)                    (((ByteSize)+1) >> 1)

/* APPL_AllocMailboxBuffer(size): Should be defined to a function to get a buffer for a mailbox service,
this is only used if the switch MAILBOX_QUEUE is set */
#define APPL_AllocMailboxBuffer(size)             malloc((size))

/* APPL_FreeMailboxBuffer(pointer): Should be defined to a function to put back a buffer for a mailbox service,
this is only used if the switch MAILBOX_QUEUE is set */
#define APPL_FreeMailboxBuffer(pointer)           free((pointer))

/* STRUCT_PACKED_START: Is defined before the typedef struct construct to pack the generic structures if necessary */
#define STRUCT_PACKED_START 

/* STRUCT_PACKED_END: Is defined after the typedef struct {} construct to pack the generic structures if necessary */
#define STRUCT_PACKED_END 

/* MBX_STRUCT_PACKED_START: Is defined before the typedef struct construct to pack the MAILBOX structures if necessary */
#define MBX_STRUCT_PACKED_START 

/* MBX_STRUCT_PACKED_END: Is defined after the typedef struct {} construct to pack the MAILBOX structures if necessary */
#define MBX_STRUCT_PACKED_END 

/* OBJ_STRUCT_PACKED_START: Is defined before the typedef struct construct to pack the OBJECT structures if necessary */
#define OBJ_STRUCT_PACKED_START 

/* OBJ_STRUCT_PACKED_END: Is defined after the typedef struct {} construct to pack the OBJECT structures if necessary */
#define OBJ_STRUCT_PACKED_END 

/* OBJ_DWORD_ALIGN: Shall be set if the object structures are not Byte aligned and the Code is executed on an 32bit platform */
#define OBJ_DWORD_ALIGN                           1

/* OBJ_WORD_ALIGN: Shall be set if the object structures are not Byte aligned and the Code is executed on an 16bit platform */
#define OBJ_WORD_ALIGN                            0


/*-----------------------------------------------------------------------------------------
------	
------	Application Specific Defines
------	
-----------------------------------------------------------------------------------------*/

/* MAX_DIAG_MSG: Number of diagnosis message ringbuffer */
#define MAX_DIAG_MSG                              0x14

/* MAX_EMERGENCIES: Number of emergencies supported in parallel */
#define MAX_EMERGENCIES                           0x1

/* MAX_FILE_SIZE: Maximum file size */
#define MAX_FILE_SIZE                             0x500

/* VENDOR_ID: Object 0x1018 SI1 (Vendor ID)	 
An unique EtherCAT Vendor ID is required. Please find all valid Vendor IDs listed at http://www.ethercat.org/en/vendor_id_list.html.
If your company is not listed, please assign an ID for free at http://www.ethercat.org/memberarea/vendor_id.asp */
#define VENDOR_ID                                 0xaaaaaaaa

/* PRODUCT_CODE: Object 0x1018 SI2 (EtherCAT product code) */
#define PRODUCT_CODE                              0x5032FFFF
/* REVISION_NUMBER: Object 0x1018 SI3 (EtherCAT product revision number) */
#define REVISION_NUMBER                           0x19051500

/* SERIAL_NUMBER: Object 0x1018 SI4 (EtherCAT product serial number) */
#define SERIAL_NUMBER                             0x00000000


/* DEVICE_PROFILE_TYPE: Slave device type (Object 0x1000)  */
/* 0-15 = 401 -> Hex 191 : Generic I/O module, Hex 1389 : 5001 Profile
   16   = Digital Inputs
   17   = Digital Outputs
   18   = Analog Inputs
   19   = Analog Outputs
   20-22 = Reserved
   23   = Mapping ( 0 : PDO mapping according to device profile, 1 : device-specific PDO mapping ) */
#define DEVICE_PROFILE      	                  0x00001389

/* DEVICE_NAME: Name of the slave device (Object 0x1008) */
#define DEVICE_NAME                               "COMIZOA_PUMP"

/* DEVICE_NAME_LEN: Length of 'DEVICE_NAME' without '\0' */
#define DEVICE_NAME_LEN_12                        0x60

/* DEVICE_HW_VERSION: Hardware version of the slave device (Object 0x1009) */
#define DEVICE_HW_VERSION                         "v1.0"

/* DEVICE_HW_VERSION_LEN: Length of 'DEVICE_HW_VERSION' without '\0' */
#define DEVICE_HW_VERSION_LEN                     0x20

/* DEVICE_SW_VERSION: Software version of the slave device (Object 0x100A) */
#define DEVICE_SW_VERSION                         "v1.0.0.0"

/* DEVICE_SW_VERSION_LEN: Length of 'DEVICE_SW_VERSION' without '\0' */
#define DEVICE_SW_VERSION_LEN                     0x40

/* MIN_PD_WRITE_ADDRESS: Minimum address for the process output data (Sync Manager 2)
inside the application memory of the EtherCAT Slave Controller which could be set by the master. The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MIN_PD_WRITE_ADDRESS                      0x1000

/* MAX_PD_WRITE_ADDRESS: Maximum address for the process output data (Sync Manager 2)
inside the application memory of the EtherCAT Slave Controller which could be set by the master. The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MAX_PD_WRITE_ADDRESS                      0x3000

/* MIN_PD_READ_ADDRESS: Minimum address for the process input data (Sync Manager 3)
inside the application memory of the EtherCAT Slave Controller which could be set by the master. The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MIN_PD_READ_ADDRESS                       0x1000

/* MAX_PD_READ_ADDRESS: Maximum address for the process input data (Sync Manager 3)
inside the application memory of the EtherCAT Slave Controller which could be set by the master. The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MAX_PD_READ_ADDRESS                       0x3000

/* MIN_MBX_SIZE: Minimum mailbox size (Sync Manager 0 and 1) which could be set by the master. The SSC don't support fragmented SDO info object/entry service => at least entry info including 12byte name shall fit in the mailbox buffer */
#define MIN_MBX_SIZE                              0x0022

/* MAX_MBX_SIZE: Maximum mailbox size (Sync Manager 0 and 1) which could be set by the master. */
#define MAX_MBX_SIZE                              0x0570

/* MIN_MBX_WRITE_ADDRESS: Minimum address for the write (receive) mailbox (Sync Manager 0). The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MIN_MBX_WRITE_ADDRESS                     0x1000

/* MAX_MBX_WRITE_ADDRESS: Maximum address for the write (receive) mailbox (Sync Manager 0). The setting have to be within the ranges of the user memory of the ESC (this is not checked by the tool). */
#define MAX_MBX_WRITE_ADDRESS                     0x3000

/* MAX_PD_INPUT_SIZE: Maximum size of the process input data (Sync Manager 3) for cyclic exchange. */
//#define MAX_PD_INPUT_SIZE                         0x0044
#define MAX_PD_INPUT_SIZE                         0x0200

/* MIN_MBX_READ_ADDRESS: Minimum address for the read (send) mailbox (Sync Manager 1). */
#define MIN_MBX_READ_ADDRESS                      0x1000

/* MAX_MBX_READ_ADDRESS: Maximum address for the read (send) mailbox (Sync Manager 1). */
#define MAX_MBX_READ_ADDRESS                      0x3000

/* MAX_PD_OUTPUT_SIZE: Maximum size of the process output data (Sync Manager 2) for cyclic exchange. */
//#define MAX_PD_OUTPUT_SIZE                        0x0044
#define MAX_PD_OUTPUT_SIZE                        0x0200

/* MIN_PD_CYCLE_TIME: Minimum cycle time in ns the slave is supporting 
(entry 0x1C32:05 or entry 0x1C33:05) */
#define MIN_PD_CYCLE_TIME                         0x7A120

/* MAX_PD_CYCLE_TIME: Maximum cycle time in ns the slave is supporting */
#define MAX_PD_CYCLE_TIME                         0xC3500000

/* PD_OUTPUT_DELAY_TIME: Minimum output delay time in ns the slave is supporting (entry 0x1C32:09) */
#define PD_OUTPUT_DELAY_TIME                      0x0

/* PD_OUTPUT_CALC_AND_COPY_TIME: Output calc+copy time in ns the slave is supporting (entry 0x1C32:06) */
#define PD_OUTPUT_CALC_AND_COPY_TIME              0x0

/* PD_INPUT_CALC_AND_COPY_TIME: Input calc+copy time in ns the slave is supporting (entry 0x1C33:06) */
#define PD_INPUT_CALC_AND_COPY_TIME               0x0

/* PD_INPUT_DELAY_TIME: Input delay time in ns the slave is supporting (entry 0x1C33:09) */
#define PD_INPUT_DELAY_TIME                       0x0



/*-----------------------------------------------------------------------------------------
------	
------	Test Configuration Defines
------	
-----------------------------------------------------------------------------------------*/


#endif // _ECATDEF_H_

