/*
 * ComiAppl.c
 *
 *  Created on: 2019. 5. 15.
 *      Author: IJS
 */

#include "ecat_def.h"
#include "ecatslv.h"
#include "objdef.h"

#include "ComiAppl.h"

#include "mk_lib/mk_common.h"
#include "mk_lib/mk_dio.h"
#include "mk_lib/mk_aio.h"
#include "mk_lib/mk_motion.h"


/******************************************************************************
** Object 0x1600 : DO RxPDO-Map
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescDOPdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}};
const UCHAR aName0x1600[] = "DO RxPDO-Map\000\377";
TOBJDOPDOMAP sDORxPDOMap = {4, 0x70000108, 0x70000208, 0x70000308, 0x70000408};


/******************************************************************************
** Object 0x1620 : AO RxPDO-Map
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescAOPdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}};
const UCHAR aName0x1620[] = "AO RxPDO-Map\000\377";
TOBJAOPDOMAP sAORxPDOMap = {16, 0x74000110, 0x74000210, 0x74000310, 0x74000410, 0x74000510, 0x74000610, 0x74000710, 0x74000810, 0x74000910, 0x74000A10, 0x74000B10, 0x74000C10, 0x74000D10, 0x74000E10, 0x74000F10, 0x74001010};


/******************************************************************************
** Object 0x1A00 : DI TxPDO-Map
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescDIPdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}, 
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}};
const UCHAR aName0x1A00[] = "DI TxPDO-Map\000\377";
TOBJDOPDOMAP sDITxPDOMap = {2, 0x60000108, 0x60000208};


/******************************************************************************
** Object 0x1A20 : AI TxPDO-Map
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescAIPdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},  
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}};     /*9 Value*/
const UCHAR aName0x1A20[] = "AI TxPDO-Map00\000\377";
const UCHAR aName0x1A21[] = "AI TxPDO-Map01\000\377";
const UCHAR aName0x1A22[] = "AI TxPDO-Map02\000\377";
const UCHAR aName0x1A23[] = "AI TxPDO-Map03\000\377";
const UCHAR aName0x1A24[] = "AI TxPDO-Map04\000\377";
const UCHAR aName0x1A25[] = "AI TxPDO-Map05\000\377";
const UCHAR aName0x1A26[] = "AI TxPDO-Map06\000\377";
const UCHAR aName0x1A27[] = "AI TxPDO-Map07\000\377";
const UCHAR aName0x1A28[] = "AI TxPDO-Map08\000\377";
const UCHAR aName0x1A29[] = "AI TxPDO-Map09\000\377";
const UCHAR aName0x1A2A[] = "AI TxPDO-Map10\000\377";
const UCHAR aName0x1A2B[] = "AI TxPDO-Map11\000\377";
const UCHAR aName0x1A2C[] = "AI TxPDO-Map12\000\377";
const UCHAR aName0x1A2D[] = "AI TxPDO-Map13\000\377";
const UCHAR aName0x1A2E[] = "AI TxPDO-Map14\000\377";
const UCHAR aName0x1A2F[] = "AI TxPDO-Map15\000\377";
const UCHAR aName0x1A30[] = "AI TxPDO-Map16\000\377";
const UCHAR aName0x1A31[] = "AI TxPDO-Map17\000\377";
const UCHAR aName0x1A32[] = "AI TxPDO-Map18\000\377";
const UCHAR aName0x1A33[] = "AI TxPDO-Map19\000\377";
const UCHAR aName0x1A34[] = "AI TxPDO-Map20\000\377";
const UCHAR aName0x1A35[] = "AI TxPDO-Map21\000\377";
const UCHAR aName0x1A36[] = "AI TxPDO-Map22\000\377";
const UCHAR aName0x1A37[] = "AI TxPDO-Map23\000\377";
const UCHAR aName0x1A38[] = "AI TxPDO-Map24\000\377";
const UCHAR aName0x1A39[] = "AI TxPDO-Map25\000\377";
const UCHAR aName0x1A3A[] = "AI TxPDO-Map26\000\377";
const UCHAR aName0x1A3B[] = "AI TxPDO-Map27\000\377";
const UCHAR aName0x1A3C[] = "AI TxPDO-Map28\000\377";
const UCHAR aName0x1A3D[] = "AI TxPDO-Map29\000\377";
const UCHAR aName0x1A3E[] = "AI TxPDO-Map30\000\377";
const UCHAR aName0x1A3F[] = "AI TxPDO-Map31\000\377";
TOBJAIPDOMAP sAITxPDOMap[32]
= { {1, 0x64000110},
    {1, 0x64010110},
    {1, 0x64020110},
    {1, 0x64030110},
    {1, 0x64040110},
    {1, 0x64050110},
    {1, 0x64060110},
    {1, 0x64070110},
    {1, 0x64080110},
    {1, 0x64090110},
    {1, 0x640A0110},
    {1, 0x640B0110},
    {1, 0x640C0110},
    {1, 0x640D0110},
    {1, 0x640E0110},
    {1, 0x640F0110},
    {1, 0x64100110},
    {1, 0x64110110},
    {1, 0x64120110},
    {1, 0x64130110},
    {1, 0x64140110},
    {1, 0x64150110},
    {1, 0x64160110},
    {1, 0x64170110},
    {1, 0x64180110},
    {1, 0x64190110},
    {1, 0x641A0110},
    {1, 0x641B0110},
    {1, 0x641C0110},
    {1, 0x641D0110},
    {1, 0x641E0110},
    {1, 0x641F0110}    
};

/******************************************************************************
** Object 0x1A80 : RTD TxPDO-Map
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescRTDPdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},  
  {DEFTYPE_UNSIGNED32, 0x20, ACCESS_READ}};     /*Value*/
const UCHAR aName0x1A80[] = "RTD TxPDO-Map00\000\377";
const UCHAR aName0x1A81[] = "RTD TxPDO-Map01\000\377";
const UCHAR aName0x1A82[] = "RTD TxPDO-Map02\000\377";
const UCHAR aName0x1A83[] = "RTD TxPDO-Map03\000\377";
TOBJRTDPDOMAP sRTDTxPDOMap[4]
= { {1, 0x66000120},
    {1, 0x66010120},
    {1, 0x66020120},
    {1, 0x66030120}    
};

/******************************************************************************
** Object 0x1c12 : Rx PDO Assign
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asPDORxAssignEntryDesc[] = {
   {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ},
   {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
   {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ}};
const UCHAR aName0x1C12[] = "RxPDO assign\000\377";
TOBJ1C12 sRxPDOassign = {2, 0x1600, 0x1620};


/******************************************************************************
** Object 0x1c13 : Tx PDO Assign
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asPDOTxAssignEntryDesc[] = {
  {DEFTYPE_UNSIGNED8, 0x08, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ},
  {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READ}  
};
const UCHAR aName0x1C13[] = "TxPDO assign\000\377";
TOBJ1C13 sTxPDOassign
=   {37, 0x1A00, 0x1A20, 0x1A21, 0x1A22, 0x1A23, 0x1A24, 0x1A25, 0x1A26, 0x1A27, 0x1A28, 0x1A29, 0x1A2A, 0x1A2B, 0x1A2C, 0x1A2D, 0x1A2E, 0x1A2F,
                 0x1A30, 0x1A31, 0x1A32, 0x1A33, 0x1A34, 0x1A35, 0x1A36, 0x1A37, 0x1A38, 0x1A39, 0x1A3A, 0x1A3B, 0x1A3C, 0x1A3D, 0x1A3E, 0x1A3F,
		 0x1A80, 0x1A81, 0x1A82, 0x1A83
};


/******************************************************************************
** Object 0x6000 : DI Sdo ( 0~11 Channel )
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescDiSdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_TXPDOMAPPING},   /* 0~7 Value */
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_TXPDOMAPPING}    /* 8~11 Value */  
};
const UCHAR aName0x6000[] = "Digtal Input Channel\000Value CH.0~7\000Value CH.8~11\000\377";
TOBJDIINPUT sDiInputs = {2,0x0,0x0};


/******************************************************************************
** Object 0x6400 ~ 0x641F : AI Sdo ( 0~31 Channel )
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescAiSdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ}, /*Subindex 0*/
  {DEFTYPE_INTEGER16, 0x10,ACCESS_READ|OBJACCESS_TXPDOMAPPING} /*Value*/   
};
const UCHAR aName0x6400[] = "Analog Input Channel 0\000\377";
const UCHAR aName0x6401[] = "Analog Input Channel 1\000\377";
const UCHAR aName0x6402[] = "Analog Input Channel 2\000\377";
const UCHAR aName0x6403[] = "Analog Input Channel 3\000\377";
const UCHAR aName0x6404[] = "Analog Input Channel 4\000\377";
const UCHAR aName0x6405[] = "Analog Input Channel 5\000\377";
const UCHAR aName0x6406[] = "Analog Input Channel 6\000\377";
const UCHAR aName0x6407[] = "Analog Input Channel 7\000\377";
const UCHAR aName0x6408[] = "Analog Input Channel 8\000\377";
const UCHAR aName0x6409[] = "Analog Input Channel 9\000\377";
const UCHAR aName0x640A[] = "Analog Input Channel 10\000\377";
const UCHAR aName0x640B[] = "Analog Input Channel 11\000\377";
const UCHAR aName0x640C[] = "Analog Input Channel 12\000\377";
const UCHAR aName0x640D[] = "Analog Input Channel 13\000\377";
const UCHAR aName0x640E[] = "Analog Input Channel 14\000\377";
const UCHAR aName0x640F[] = "Analog Input Channel 15\000\377";
const UCHAR aName0x6410[] = "Analog Input Channel 16\000\377";
const UCHAR aName0x6411[] = "Analog Input Channel 17\000\377";
const UCHAR aName0x6412[] = "Analog Input Channel 18\000\377";
const UCHAR aName0x6413[] = "Analog Input Channel 19\000\377";
const UCHAR aName0x6414[] = "Analog Input Channel 20\000\377";
const UCHAR aName0x6415[] = "Analog Input Channel 21\000\377";
const UCHAR aName0x6416[] = "Analog Input Channel 22\000\377";
const UCHAR aName0x6417[] = "Analog Input Channel 23\000\377";
const UCHAR aName0x6418[] = "Analog Input Channel 24\000\377";
const UCHAR aName0x6419[] = "Analog Input Channel 25\000\377";
const UCHAR aName0x641A[] = "Analog Input Channel 26\000\377";
const UCHAR aName0x641B[] = "Analog Input Channel 27\000\377";
const UCHAR aName0x641C[] = "Analog Input Channel 28\000\377";
const UCHAR aName0x641D[] = "Analog Input Channel 29\000\377";
const UCHAR aName0x641E[] = "Analog Input Channel 30\000\377";
const UCHAR aName0x641F[] = "Analog Input Channel 31\000\377";
TOBJAIINPUT sAiInputs[32]
= { {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000}	
};

/******************************************************************************
** Object 0x6600 ~ 0x6603 : RTD Sdo ( 0~3 Channel )
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescRTDSdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ}, /*Subindex 0*/  
  {DEFTYPE_INTEGER32, 0x20,ACCESS_READ|OBJACCESS_TXPDOMAPPING} /*Value*/
};
const UCHAR aName0x6600[] = "RTD Channel 0\000\377";
const UCHAR aName0x6601[] = "RTD Channel 1\000\377";
const UCHAR aName0x6602[] = "RTD Channel 2\000\377";
const UCHAR aName0x6603[] = "RTD Channel 3\000\377";
TOBJRTDINPUT sRtdInputs[4]
= { {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000},
    {1, 0x0000}
};

/******************************************************************************
** Object 0x7000 : DO Sdo ( 0~31 Channel )
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescDoSdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_RXPDOMAPPING}, /* 1 Value*/
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_RXPDOMAPPING}, /* 2 Value*/
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_RXPDOMAPPING}, /* 3 Value*/
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ|OBJACCESS_RXPDOMAPPING}  /* 4 Value*/
};
const UCHAR aName0x7000[] = "Digtal Output Channel\000Value CH.0~7\000Value CH.8~15\000Value CH.16~23\000Value CH.24~31\000\377";
TOBJDOOUTPUT sDoOutputs = {4, 0x0, 0x0, 0x0, 0x0};

/******************************************************************************
** Object 0x7400 : AO Sdo ( 0~15 Channel )
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC asEntryDescAoSdoMap[] = {
  {DEFTYPE_UNSIGNED8, 0x8, ACCESS_READ},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING},
  {DEFTYPE_INTEGER16, 0x10, ACCESS_READ|OBJACCESS_RXPDOMAPPING}
};
const UCHAR aName0x7400[] = "Analog Output Channel\000Value CH.0\000Value CH.1\000Value CH.2\000Value CH.3\000Value CH.4\000Value CH.5\000Value CH.6\000Value CH.7\000Value CH.8\000Value CH.9\000Value CH.10\000Value CH.11\000Value CH.12\000Value CH.13\000Value CH.14\000Value CH.15\000\377";
TOBJAOOUTPUT sAoOutputs = {16, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};

/******************************************************************************
** Object 0x20FF Device ID
******************************************************************************/
OBJCONST TSDOINFOENTRYDESC    OBJMEM sEntryDesc0x20FF = {DEFTYPE_UNSIGNED16, 0x10, ACCESS_READWRITE|OBJACCESS_SETTINGS};
const UCHAR OBJMEM aName0x20FF[] = "Device ID\000\377";
UINT16 u16DeviceID = 0;


//#ifdef _OBJD_
/*if _PIC18 is enabled the object dictionary is fixed defined in coeappl.c*/
TOBJECT    OBJMEM ApplicationObjDic[] = {
    // COMIZOA Module PDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x1600 */
    {NULL, NULL, 0x1600, {DEFTYPE_PDOMAPPING, 4 | (OBJCODE_REC << 8)}, asEntryDescDOPdoMap, aName0x1600, &sDORxPDOMap, NULL, NULL, 0x0000 },
    /* Object 0x1620 */
    {NULL, NULL, 0x1620, {DEFTYPE_PDOMAPPING, 16 | (OBJCODE_REC << 8)}, asEntryDescAOPdoMap, aName0x1620, &sAORxPDOMap, NULL, NULL, 0x0000 },
    /* Object 0x1A00 */
    {NULL, NULL, 0x1A00, {DEFTYPE_PDOMAPPING, 2 | (OBJCODE_REC << 8)}, asEntryDescDIPdoMap, aName0x1A00, &sDITxPDOMap, NULL, NULL, 0x0000 },
    /* Object 0x1A20 ~ 0x1A3F*/
    {NULL, NULL, 0x1A20, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A20, &sAITxPDOMap[0], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A21, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A21, &sAITxPDOMap[1], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A22, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A22, &sAITxPDOMap[2], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A23, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A23, &sAITxPDOMap[3], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A24, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A24, &sAITxPDOMap[4], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A25, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A25, &sAITxPDOMap[5], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A26, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A26, &sAITxPDOMap[6], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A27, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A27, &sAITxPDOMap[7], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A28, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A28, &sAITxPDOMap[8], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A29, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A29, &sAITxPDOMap[9], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2A, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2A, &sAITxPDOMap[10], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2B, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2B, &sAITxPDOMap[11], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2C, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2C, &sAITxPDOMap[12], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2D, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2D, &sAITxPDOMap[13], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2E, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2E, &sAITxPDOMap[14], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A2F, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A2F, &sAITxPDOMap[15], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A30, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A30, &sAITxPDOMap[16], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A31, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A31, &sAITxPDOMap[17], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A32, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A32, &sAITxPDOMap[18], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A33, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A33, &sAITxPDOMap[19], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A34, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A34, &sAITxPDOMap[20], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A35, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A35, &sAITxPDOMap[21], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A36, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A36, &sAITxPDOMap[22], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A37, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A37, &sAITxPDOMap[23], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A38, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A38, &sAITxPDOMap[24], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A39, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A39, &sAITxPDOMap[25], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3A, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3A, &sAITxPDOMap[26], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3B, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3B, &sAITxPDOMap[27], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3C, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3C, &sAITxPDOMap[28], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3D, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3D, &sAITxPDOMap[29], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3E, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3E, &sAITxPDOMap[30], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A3F, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescAIPdoMap, aName0x1A3F, &sAITxPDOMap[31], NULL, NULL, 0x0000 },
    /* Object 0x1A80 ~ 0x1A83*/
	{NULL, NULL, 0x1A80, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDPdoMap, aName0x1A80, &sRTDTxPDOMap[0], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x1A81, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDPdoMap, aName0x1A81, &sRTDTxPDOMap[1], NULL, NULL, 0x0000 },
	{NULL, NULL, 0x1A82, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDPdoMap, aName0x1A82, &sRTDTxPDOMap[2], NULL, NULL, 0x0000 },
	{NULL, NULL, 0x1A83, {DEFTYPE_PDOMAPPING, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDPdoMap, aName0x1A83, &sRTDTxPDOMap[3], NULL, NULL, 0x0000 },
	
    // ----------------------------------------------------------------------------------------------------------------------------------- //
    /* Object 0x1C12 */
    {NULL, NULL, 0x1C12, {DEFTYPE_UNSIGNED16, 2 | (OBJCODE_ARR << 8)}, asPDORxAssignEntryDesc, aName0x1C12, &sRxPDOassign, NULL, NULL, 0x0000 },
    /* Object 0x1C13 */
    {NULL, NULL, 0x1C13, {DEFTYPE_UNSIGNED16, 37 | (OBJCODE_ARR << 8)}, asPDOTxAssignEntryDesc, aName0x1C13, &sTxPDOassign, NULL, NULL, 0x0000 },

	// COMIZOA ALIAS Object --------------------------------------------------------------------------------------------------------- //
	/* Object 0x20FF */
    {NULL, NULL, 0x20FF, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_VAR << 8)}, &sEntryDesc0x20FF, aName0x20FF, &u16DeviceID, DeviceIDRead, NULL, 0x0000 },
	
    // COMIZOA DI SDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x6000 */
    {NULL, NULL, 0x6000, {DEFTYPE_RECORD, 2 | (OBJCODE_REC << 8)}, asEntryDescDiSdoMap, aName0x6000, &sDiInputs, NULL, NULL, 0x0000 },
    // COMIZOA AI Module SDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x6400 */
    {NULL, NULL, 0x6400, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6400, &sAiInputs[0], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6401, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6401, &sAiInputs[1], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6402, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6402, &sAiInputs[2], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6403, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6403, &sAiInputs[3], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6404, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6404, &sAiInputs[4], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6405, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6405, &sAiInputs[5], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6406, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6406, &sAiInputs[6], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6407, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6407, &sAiInputs[7], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6408, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6408, &sAiInputs[8], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6409, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6409, &sAiInputs[9], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640A, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640A, &sAiInputs[10], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640B, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640B, &sAiInputs[11], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640C, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640C, &sAiInputs[12], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640D, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640D, &sAiInputs[13], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640E, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640E, &sAiInputs[14], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x640F, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x640F, &sAiInputs[15], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6410, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6410, &sAiInputs[16], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6411, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6411, &sAiInputs[17], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6412, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6412, &sAiInputs[18], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6413, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6413, &sAiInputs[19], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6414, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6414, &sAiInputs[20], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6415, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6415, &sAiInputs[21], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6416, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6416, &sAiInputs[22], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6417, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6417, &sAiInputs[23], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6418, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6418, &sAiInputs[24], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x6419, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x6419, &sAiInputs[25], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641A, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641A, &sAiInputs[26], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641B, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641B, &sAiInputs[27], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641C, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641C, &sAiInputs[28], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641D, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641D, &sAiInputs[29], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641E, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641E, &sAiInputs[30], NULL, NULL, 0x0000 },
    {NULL, NULL, 0x641F, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescAiSdoMap, aName0x641F, &sAiInputs[31], NULL, NULL, 0x0000 },
	// COMIZOA RTD Module SDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x6600 */
	{NULL, NULL, 0x6600, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDSdoMap, aName0x6600, &sRtdInputs[0], NULL, NULL, 0x0000 },
	{NULL, NULL, 0x6601, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDSdoMap, aName0x6601, &sRtdInputs[1], NULL, NULL, 0x0000 },
	{NULL, NULL, 0x6602, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDSdoMap, aName0x6602, &sRtdInputs[2], NULL, NULL, 0x0000 },
	{NULL, NULL, 0x6603, {DEFTYPE_UNSIGNED16, 1 | (OBJCODE_REC << 8)}, asEntryDescRTDSdoMap, aName0x6603, &sRtdInputs[3], NULL, NULL, 0x0000 },
    // COMIZOA DO Module SDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x7000 */
    {NULL, NULL, 0x7000, {DEFTYPE_RECORD, 4 | (OBJCODE_REC << 8)}, asEntryDescDoSdoMap, aName0x7000, &sDoOutputs, NULL, NULL, 0x0000 },
    // COMIZOA AO Module SDO Map --------------------------------------------------------------------------------------------------------- //
    /* Object 0x7400 */
    {NULL, NULL, 0x7400, {DEFTYPE_UNSIGNED16, 16 | (OBJCODE_ARR << 8)}, asEntryDescAoSdoMap, aName0x7400, &sAoOutputs, NULL, NULL, 0x0000 },


    /*end of entries*/
    {NULL, NULL, 0xFFFF, {0, 0}, NULL, NULL, NULL, NULL}};
//#endif


void APPL_AckErrorInd(UINT16 stateTrans)
{
}

UINT16 APPL_StartMailboxHandler(void)
{
    return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_StopMailboxHandler(void)
{
    return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_StartInputHandler(UINT16 *pIntMask)
{
  PDO_InputMapping();
  return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_StopInputHandler(void)
{
    return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_StartOutputHandler(void)
{
    return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_StopOutputHandler(void)
{
    return ALSTATUSCODE_NOERROR;
}

UINT16 APPL_GenerateMapping(UINT16* pInputSize,UINT16* pOutputSize)
{
    UINT16 result = ALSTATUSCODE_NOERROR;
    UINT16 PDOAssignEntryCnt = 0;
    OBJCONST TOBJECT OBJMEM * pPDO = NULL;
    UINT16 PDOSubindex0 = 0;
    UINT32 *pPDOEntry = NULL;
    UINT16 PDOEntryCnt = 0;
    UINT16 InputSize = 0;
    UINT16 OutputSize = 0;

    /*Scan object 0x1C12 RXPDO assign*/
   for(PDOAssignEntryCnt = 0; PDOAssignEntryCnt < sRxPDOassign.u16SubIndex0; PDOAssignEntryCnt++)
    {
        pPDO = OBJ_GetObjectHandle(sRxPDOassign.aEntries[PDOAssignEntryCnt]);
        if(pPDO != NULL)
        {
            PDOSubindex0 = *((UINT16 *)pPDO->pVarPtr);
            for(PDOEntryCnt = 0; PDOEntryCnt < PDOSubindex0; PDOEntryCnt++)
            {
                pPDOEntry = (UINT32 *)((UINT8 *)pPDO->pVarPtr + (OBJ_GetEntryOffset((PDOEntryCnt+1),pPDO)>>3));    //goto PDO entry
                // we increment the expected output size depending on the mapped Entry
                OutputSize += (UINT16) ((*pPDOEntry) & 0xFF);
            }
        }
        else
        {
            /*assigned PDO was not found in object dictionary. return invalid mapping*/
            OutputSize = 0;
            result = ALSTATUSCODE_INVALIDOUTPUTMAPPING;
            break;
        }
    }

    OutputSize = (OutputSize + 7) >> 3;

    if(result == 0)
    {
        /*Scan Object 0x1C13 TXPDO assign*/
        for(PDOAssignEntryCnt = 0; PDOAssignEntryCnt < sTxPDOassign.u16SubIndex0; PDOAssignEntryCnt++)
        {
            pPDO = OBJ_GetObjectHandle(sTxPDOassign.aEntries[PDOAssignEntryCnt]);
            if(pPDO != NULL)
            {
                PDOSubindex0 = *((UINT16 *)pPDO->pVarPtr);
                for(PDOEntryCnt = 0; PDOEntryCnt < PDOSubindex0; PDOEntryCnt++)
                {
                    pPDOEntry = (UINT32 *)((UINT8 *)pPDO->pVarPtr + (OBJ_GetEntryOffset((PDOEntryCnt+1),pPDO)>>3));    //goto PDO entry
                   // we increment the expected output size depending on the mapped Entry
                    InputSize += (UINT16) (((*pPDOEntry) & 0xFF));
                }
            }
            else
            {
                /*assigned PDO was not found in object dictionary. return invalid mapping*/
                InputSize = 0;
                result = ALSTATUSCODE_INVALIDINPUTMAPPING;
                break;
           }
        }
    }
    InputSize = (InputSize + 7) >> 3;

    *pInputSize = InputSize;
    *pOutputSize = OutputSize;
    return result;

}

void APPL_InputMapping(UINT16* pData)
{
    UINT16 i=0, j=0;
    UINT8 *pTmpByte = (UINT8 *)pData;

    for (i = 0; i < sTxPDOassign.u16SubIndex0; i++)
    {
        if( sTxPDOassign.aEntries[i] == 0x1A00 ) {
            //*pTmpByte++ = (sDiInputs.u8DigtalInput[0]&0xFF)|((sDiInputs.u8DigtalInput[1]&0xFF)<<8);
            for( j=0; j< sDITxPDOMap.u16SubIndex0; j++ ) {
                *pTmpByte++ = sDiInputs.u8DigtalInput[j];
            }
        }
		else if( (sTxPDOassign.aEntries[i] >= 0x1A20) && (sTxPDOassign.aEntries[i] <= 0x1A3F) ) {
			//*pTmpByte++ = *(((UINT16*)&sAiInputs[i-1])+1);
		    *pTmpByte++ = *(((UINT8*)&sAiInputs[i-1])+2);
		    *pTmpByte++ = *(((UINT8*)&sAiInputs[i-1])+3);

		}
        else {
            *pTmpByte++ = *(((UINT8*)&sRtdInputs[i-33])+2);
            *pTmpByte++ = *(((UINT8*)&sRtdInputs[i-33])+3);
            *pTmpByte++ = *(((UINT8*)&sRtdInputs[i-33])+4);
            *pTmpByte++ = *(((UINT8*)&sRtdInputs[i-33])+5);
            //*pTmpByte++ = *(((UINT16*)&sRtdInputs[i-33])+1);
			//*pTmpByte++ = *(((UINT16*)&sRtdInputs[i-33])+2);
        }
    }
}

void APPL_OutputMapping(UINT16* pData)
{
  UINT16 i=0, j=0, k=0;
  UINT16 Channel = 0;
  UINT8 *pTmpData = (UINT8 *)pData;
  UINT8 TmpData = 0;

  for( i=0; i<sRxPDOassign.u16SubIndex0; i++)
  {
    switch (sRxPDOassign.aEntries[i])
    {
      case 0x1600:
          for( j=0; j<sDORxPDOMap.u16SubIndex0; j++)
          {
              TmpData = (*pTmpData++);
              sDoOutputs.u8Digtaloutput[j] = TmpData;
              doPutMulti(j*8, 8, TmpData);
          }
          break;
      case 0x1620:
          for( j=0; j<sAORxPDOMap.u16SubIndex0; j++ ) {
              *(((UINT8*)&sAoOutputs.u16AnalogOutput[j])) = *pTmpData++;
              *(((UINT8*)&sAoOutputs.u16AnalogOutput[j])+1) = *pTmpData++;
              aoOutCurrent(j, sAoOutputs.u16AnalogOutput[j]);
          }
          break;
    }
  }
}

void APPL_Application(void)
{
    t_i16 i = 0;
    t_i16 nDigit = 0;
	t_f32 fTemp = 0;

	sDiInputs.u8DigtalInput[0] = (diGetMulti(0, 8) & 0xFF);
	sDiInputs.u8DigtalInput[1] = (diGetMulti(8, 4) & 0xF);	   

    for( i=0; i<36; i++ ) {
        if(i%9==8){
            aiGetDegree(i, &fTemp);
            sRtdInputs[i/9].i32RtdInput = (INT32)(fTemp*10);
        }
        else{
            aiGetDigit(i, &nDigit);
            sAiInputs[i-(i/9)].i16AnalogInput = nDigit;
        }
    }
}

UINT16 APPL_GetDeviceID()
{
    UINT16 Value = GetLastIpAddrFromGPIOF();//DeviceIDGet();
    return Value;
}

UINT8 DeviceIDRead(UINT16 Index, UINT8 Subindex, UINT32 Size, UINT16 * pData, UINT8 bCompleteAccess)
{
  if( bCompleteAccess )
    return ABORTIDX_UNSUPPORTED_ACCESS;
  
  if( Subindex == 0x0 ) {
    u16DeviceID = GetLastIpAddrFromGPIOF();
    *pData = u16DeviceID;
  } else
    return ABORTIDX_SUBINDEX_NOT_EXISTING;
 
  return 0;
}
