#ifndef _EIP_ETHERNET_H
#define _EIP_ETHERNET_H

#include "socket.h"

#ifdef __cplusplus
extern "C" {
#endif

// Function prototypes and external definitions
void InitEthernet(t_i32 *wEtherBaseAddr, t_char addr[]);
void InitNetConfig(t_ui16 ChipAddr, t_char addr[]);
void setsubmask(t_char * addr);						// Set subnet mask value
void setgateway(t_char * addr);                                         // Set Gateway IP address
void setMACAddr(t_char * addr);                                         // Set Mac address
void setIP(t_char * addr);                                              // Set source IP address
void settimeout(t_char * val);						// Set re-transmition timeout value
void gettimeout(t_char * val);
t_ui16 select(SOCKET s, t_char func);
t_byte CheckNodeIP();

/* Select parameter to use */
#define SEL_CONTROL		0	// Confirm socket status
#define SEL_SEND		1	       	// Confirm Tx free buffer size
#define SEL_RECV		2	       	// Confirm Rx data size

#ifdef __cplusplus
}
#endif // __cplusplus

#endif //_EIP_ETHERNET_H
