#ifndef _COMI_NET_HEADER_
#define _COMI_NET_HEADER_
#include "mk_common.h"


#define _CN_SUPPORT_TCP_  // TCP  Ѵ. (  ׽ð ƴϸ ׻ Ǿ Ѵ)
#define _CN_SUPPORT_UDP_  // UDP  Ѵ. (  ׽ð ƴϸ ׻ Ǿ Ѵ)

// TCP CLINET/SERVER MODE //
#define TCP_SERVER_MODE		0
#define TCP_CLIENT_MODE		1
#define _CN_TCP_MODE		TCP_SERVER_MODE

//////////////////////////////////////////////////////////////////////////////////
// NODE_REG_DATA_VER: Node    . 
//  0 => 1  (DIO BLK -> MOTION BLK -> AIO BLK)
//  1 => 2  (DIO BLK -> MOTION BLK -> AI BLK -> AO BLK -> CNTR BLK)
#define NODE_REG_DATA_VER	1
/////////////////////////////////////////////////////////////////////////////////
// IO_MESSAGE_DATA_VER: I/O Message(UDP)   . 
//  0 => 1  (DIO BLK -> MOTION BLK -> AIO BLK)
//  1 => 2  (DIO BLK -> MOTION BLK -> AI BLK -> CNTR BLK)
#define IO_MESSAGE_DATA_VER	1

// ECHO MODE (debug) //
//#define _CN_SUPPORT_UDP_ECHO_	// UDP ſ ڸ带  : Echo mode Ǹ "ECHO"  Ŷ ״ ٽ ǵ .
//#define _CN_SUPPORT_TCP_ECHO_	// TCP ſ ڸ带  : Echo mode Ǹ "ECHO"  Ŷ ״ ٽ ǵ .

#define cnUDP_SOCKET	0 // UDP ſ  ȣ
#define cnTCP_SOCKET	1 // TCP ſ  ȣ 
#define cnUDP_PORT	35032 // UDP ſ Ʈ ȣ 
#define cnTCP_PORT	35033 // TCP ſ Ʈ ȣ 

#define cnIOMT_DI	0x00	// IO_Message data type: D/I_NPN (obsolete)
#define cnIOMT_DO	0x01	// IO_Message data type: D/O_NPN (obsolete)
#define cnIOMT_DI_P	0x20	// IO_Message data type: D/I_PNP (obsolete) 
#define cnIOMT_DO_P	0x21	// IO_Message data type: D/O_PNP (obsolete) 
#define cnIOMT_MOT	0x02	// IO_Message data type: MOTION
#define cnIOMT_AI	0x03	// IO_Message data type: AI
#define cnIOMT_AO	0x04	// IO_Message data type: AO
#define cnIOMT_DIO	0x05	// IO_Message data type: DIO_NPN
#define cnIOMT_DIO_P	0x25	// IO_Message data type: DIO_PNP
#define cnIOMT_CNT	0x06	// IO_Message data type: Counter
#define cnIOMT_SER	0x07	// IO_Message data type: Ȯ Serial 
#define cnIOMT_MDIO 0x08
#define cnIOMT_CMDIO 0x09 // IO_Message data type: CNet Master DIO
#define cnIOMT_CNET 0x09
#define cnIOMT_CNET_8DIO = 0x10
#define cnIOMT_CNET_16DI = 0x11
#define cnIOMT_CNET_16DO = 0x12
#define cnIOMT_CNET_32DI = 0x13
#define cnIOMT_CNET_32DO = 0x14

typedef struct{
	struct{
		t_ui32 nState: 3; // 0:Not registered,  1:Registered, 2:On trying register
		t_ui32 dwResv:	29;
	}F1;
	t_ui32 dwTryStrarT; // register õ  tick count
}TNodeRegInfo;

// Node register state id //
enum TCnNodeRegSt{cnNRS_NO, cnNRS_OK, cnNRS_ONTRY};

t_i32	cnBootup (void);
t_bool 	cnUdpOpenSocket(void);
t_bool	cnTcpOpenServerSocket(void);
t_bool	cnTcpOpenClientSocket(t_uchar abyPeerIp[]);
t_bool	cnTcpCloseSocket();
t_i32	cnUdpMainLoop (t_i32 st, t_i32 nSockChan);
t_i32	cnTcpMainLoop (t_i32 st, t_i32 nSockChan);
t_uchar cnGetNodeId (void);
t_ui32	cnGetLocalTimestamp (void);
void	cnSetLocalTimestamp (t_ui32 dwTimetick);
t_i32	cnGetSeqNo (void);
t_i32	cnSetSeqNo (t_i32 nSeqNo);
t_i32	cndGetModuleId (t_ui32 nDevIdx);
t_i32	cnmGetModuleId (t_ui32 nDevIdx);
t_i32	cnaiGetModuleId (t_ui32 nDevIdx); // Ƴα Է  ID
t_i32	cnaoGetModuleId (t_ui32 nDevIdx); // Ƴα   ID
t_i32	cncGetModuleId (t_ui32 nDevIdx); // ī  ID
//#if (_PLATFORM==PLF_EtherIP_3)
#if 1
t_i32	cncmdGetModuleId (t_ui32 nDevIdx); // CNet Master  ID
#endif
t_i32	cnSerGetModuleId (t_ui32 nDevIdx); // Ȯ ø   ID
t_i32	cnmGetGlobalAxis (t_i32 nModule, t_i32 nChannel);
t_i32	cnmStGetMst(t_i32 nAxis);


//-------------------------------------------------------------------------------------------------------
#define cnMAX_NUM_CMD_PARAM	64	// COMMAND Packet   Ķ ִ  
#define cnPARAM_START		':'	// COMMAND Packet ߿ Parameter  ˸ delimeter  
#define cnPARAM_END			':'	// COMMAND Packet ߿ Parameter  ˸ delimeter  
#define cnPARAM_DELIM		',' // COMMAND Packet ߿ Parameter Parameter  

#define cnERR_NONE					0
#define cnERR_TIMEOUT				-1 // communication timeout error
#define cnERR_INVALID_PACKET		-2 // Packet data error
#define cnERR_CHECKSUM				-3 // checksum mismatch
#define cnERR_CNE_SIGN_MISMATCH		-5 // CNE data signature ġ ʴ´.
#define cnERR_CEN_DATA_ERR			-7 // CNE data ùٸ ʾƼ   ʴ´.
#define cnERR_UNDEFINE_COMMAND		-6 // Undefined control command has been received


#endif
