/*
 * ComiAppl.h
 *
 *  Created on: 2019. 5. 15.
 *      Author: IJS
 */

#ifndef ESCSTACK_COMIAPPL_H_
#define ESCSTACK_COMIAPPL_H_

#include "ecatappl.h"

#ifdef _COMIZOA_
  #define PROTO
#else
  #define PROTO extern
#endif

#pragma pack(1)

/******************************************************************************
** Object 0x1600 : DO RxPDO-Map
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT32   aEntries[4];
} TOBJDOPDOMAP;

/******************************************************************************
** Object 0x1620 : AO RxPDO-Map
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT32   aEntries[16];
} TOBJAOPDOMAP;

/******************************************************************************
** Object 0x1A00 : DI TxPDO-Map
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT32   aEntries[2];
} TOBJDIPDOMAP;

/******************************************************************************
** Object 0x1A20 : AI TxPDO-Map
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT32   aEntries[1];
} TOBJAIPDOMAP;

/******************************************************************************
** Object 0x1A80 : RTD TxPDO-Map
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT32   aEntries[1];
} TOBJRTDPDOMAP;

/******************************************************************************
** Object 0x1c12 : Rx PDO Assign
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT16   aEntries[2];
}TOBJ1C12;

/******************************************************************************
** Object 0x1c13 : Tx PDO Assign
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT16   aEntries[37];
}TOBJ1C13;

/******************************************************************************
** Object 0x6000 : DI Sdo ( 0~11 Channel )
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT8    u8DigtalInput[2];
}TOBJDIINPUT;

/******************************************************************************
** Object 0x6400 ~ 0x643F : AI Sdo ( 0~31 Channel )
******************************************************************************/
typedef struct {
   UINT16  u16SubIndex0;   
   INT16 i16AnalogInput;
}TOBJAIINPUT;

/******************************************************************************
** Object 0x6600 ~ 0x6603 : RTD Sdo ( 0~3 Channel )
******************************************************************************/
typedef struct {
   UINT16  u16SubIndex0;   
   INT32 i32RtdInput;
}TOBJRTDINPUT;

/******************************************************************************
** Object 0x7000 : DO Sdo ( 0~31 Channel )
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   UINT8    u8Digtaloutput[4];
}TOBJDOOUTPUT;

/******************************************************************************
** Object 0x7400 : AO Sdo ( 0~15 Channel )
******************************************************************************/
typedef struct {
   UINT16   u16SubIndex0;
   INT16    u16AnalogOutput[16];
} TOBJAOOUTPUT;



////////////////////////////////////////////////////////////////////////////////

 void   APPL_AckErrorInd(UINT16 stateTrans);
 UINT16 APPL_StartMailboxHandler(void);
 UINT16 APPL_StopMailboxHandler(void);
 UINT16 APPL_StartInputHandler(UINT16 *pIntMask);
 UINT16 APPL_StopInputHandler(void);
 UINT16 APPL_StartOutputHandler(void);
 UINT16 APPL_StopOutputHandler(void);

 UINT16 APPL_GenerateMapping(UINT16 *pInputSize,UINT16 *pOutputSize);
 void APPL_InputMapping(UINT16* pData);
 void APPL_OutputMapping(UINT16* pData);

 void APPL_Application(void);
 UINT16 APPL_GetDeviceID();
 
 UINT8 DeviceIDRead(UINT16 Index, UINT8 Subindex, UINT32 Size, UINT16 * pData, UINT8 bCompleteAccess);


#endif /* ESCSTACK_COMIAPPL_H_ */
