/*-----------------------------------------------------------------------------------------
------
------    ecatfoe.h
------
-----------------------------------------------------------------------------------------*/

#ifndef _ECATFOE_H_
#define _ECATFOE_H_

/*-----------------------------------------------------------------------------------------
------
------    Includes
------
-----------------------------------------------------------------------------------------*/

#include "mailbox.h"

/*-----------------------------------------------------------------------------------------
------
------    Defines and Types
------
-----------------------------------------------------------------------------------------*/

/*/////////////////////////////////////////////////////////////////////////////////////////
//
// Error Codes
*/

#define    ECAT_FOE_ERRCODE_NOTDEFINED          0x8000
#define    ECAT_FOE_ERRCODE_NOTFOUND            0x8001
#define    ECAT_FOE_ERRCODE_ACCESS              0x8002
#define    ECAT_FOE_ERRCODE_DISKFULL            0x8003
#define    ECAT_FOE_ERRCODE_ILLEGAL             0x8004
#define    ECAT_FOE_ERRCODE_PACKENO             0x8005
#define    ECAT_FOE_ERRCODE_EXISTS              0x8006
#define    ECAT_FOE_ERRCODE_NOUSER              0x8007
#define    ECAT_FOE_ERRCODE_BOOTSTRAPONLY       0x8008
#define    ECAT_FOE_ERRCODE_NOTINBOOTSTRAP      0x8009
#define    ECAT_FOE_ERRCODE_NORIGHTS            0x800A
#define    ECAT_FOE_ERRCODE_PROGERROR           0x800B

/*/////////////////////////////////////////////////////////////////////////////////////////
//
// Services
*/

#define    ECAT_FOE_OPMODE_RRQ                  1
#define    ECAT_FOE_OPMODE_WRQ                  2
#define    ECAT_FOE_OPMODE_DATA                 3
#define    ECAT_FOE_OPMODE_ACK                  4
#define    ECAT_FOE_OPMODE_ERR                  5
#define    ECAT_FOE_OPMODE_BUSY                 6

/*///////////////////////////////////////////////////////////////////////////////////////
//
// States
*/

#define    FOE_READY                            0
#define    FOE_WAIT_FOR_ACK                     1
#define    FOE_WAIT_FOR_DATA                    2
#define    FOE_WAIT_FOR_RESET                   3
#define    FOE_WAIT_FOR_LAST_ACK                4
#define    FOE_PROGRAMMING                      5
#define    FOE_WAIT_FOR_LAST_DATA               6

/*/////////////////////////////////////////////////////////////////////////////////////////
//
// Structures
*/

#pragma pack(1) // 20150901_YDS : ̰ ָ ü    ȵ...

typedef struct MBX_STRUCT_PACKED_START
{
    UINT16    Cmd;
        #define    EFW_CMD_IGNORE               0
        #define    EFW_CMD_MEMORY_TRANSFER      1
        #define    EFW_CMD_WRCODE               2
        #define    EFW_CMD_CHK_DEVID            3
        #define    EFW_CMD_CHK_DEVICEID         3
        #define    EFW_CMD_CHKSUM               4
        #define    EFW_CMD_WRCODECHKSUM         5
        #define    EFW_CMD_SET_DEVID            6
        #define    EFW_CMD_CHKSUMCHKSUM         6
        #define    EFW_CMD_BOOTCHKSUM           7
        #define    EFW_CMD_SET_EEPROM           10
    UINT16    Size;
    UINT32    Address;
    UINT16      Data[BL_PAGE_SIZE>>1];
}MBX_STRUCT_PACKED_END
TEFWUPDATE;

#define FW_UPDATE_SIZE  SIZEOF(TEFWUPDATE)

typedef struct  MBX_STRUCT_PACKED_START
{
    UINT16        OpMode;               // = 1 (RRQ), = 2 (WRQ), = 3 (DATA), = 4 (ACK), = 5 (ERR), = 6 (BUSY)
    union MBX_STRUCT_PACKED_START
    {
        UINT32        Password;         // (RRQ, WRQ)       = 0 if unknown
        UINT32        PacketNo;         // (DATA, ACK)
        UINT32        ErrorCode;        // (ERR)
        struct MBX_STRUCT_PACKED_START
        {
            UINT16    Done;             // (BUSY)
            UINT16    Entire;           // (BUSY)
        }MBX_STRUCT_PACKED_END
        Busy;
    }MBX_STRUCT_PACKED_END
    Cmd;
//    union
//    {
//        CHAR        Name[]            // (RRQ, WRQ)    rest of mailbox data
//        UINT8        Data[]            // (DATA)        rest of mailbox data (if OpMode = 3)
//        CHAR        ErrorText[]        // (ERR)            rest of mailbox data
//    };
}MBX_STRUCT_PACKED_END
TFOEHEADER;

#define     FOE_HEADER_SIZE     SIZEOF(TFOEHEADER)

typedef struct MBX_STRUCT_PACKED_START
{
      TMBXHEADER        MbxHeader;
      TFOEHEADER        FoeHeader;
    UINT16              Data[((MAX_MBX_DATA_SIZE)-(FOE_HEADER_SIZE)) >> 1];
}MBX_STRUCT_PACKED_END
TFOEMBX;


/*///////////////////////////////////////////////////////////////////////////////////////
//
// Results
*/

#define    FOE_ERROR                            0x8000
#define    FOE_FINISHED                         ((FOE_ERROR)-1)
#define    FOE_FINISHED_NOACK                   ((FOE_FINISHED)-1)
#define    FOE_ACK                              ((FOE_FINISHED_NOACK)-1)
#define    FOE_ACKFINISHED                      ((FOE_ACK)-1)
#define    FOE_MAXBUSY                          ((FOE_ACKFINISHED)-1)
#define    FOE_MAXDATA                          (FW_UPDATE_SIZE)


#endif //_ECATFOE_H_

/*-----------------------------------------------------------------------------------------
------
------    global variables
------
-----------------------------------------------------------------------------------------*/

#if _ECATFOE_
    #define PROTO
#else
    #define PROTO extern
#endif
PROTO    UINT32                                 u32PacketNo;                /* stores the actual packet number to be expected */
PROTO    UINT32                                 u32FileOffset;              /* stores the next file offset to be sent */
PROTO    UINT32                                 u32LastFileOffset;          /* stores the actual sent file offset */
PROTO    UINT16                                 u16FileAccessState;         /* stores the actual state of the file transmission sequence */
PROTO    TMBX MBXMEM *                          pFoeSendStored;             /* if the mailbox service could not be sent (or stored),
                                                                                the FoE service will be stored in this variable
                                                                                and will be sent automatically from the mailbox handler
                                                                                (FOE_ContinueInd) when the send mailbox will be read
                                                                                the next time from the master */
/*-----------------------------------------------------------------------------------------
------
------    global functions
------
-----------------------------------------------------------------------------------------*/

PROTO    void     FOE_Init(void);
PROTO    UINT8 FOE_ServiceInd(TFOEMBX MBXMEM * pFoeInd);
PROTO    void     FOE_ContinueInd(TMBX MBXMEM * pMbx);

#undef PROTO
#pragma pack()


