/*
 * function.h
 *
 *  Created on: 2019. 5. 15.
 *      Author: IJS
 */

#ifndef ESCSTACK_FUNCTION_H_
#define ESCSTACK_FUNCTION_H_

#include "ecat_def.h"
#include "esc.h"

#if _COMIZOA_COMMON_
    #define PROTO
#else
    #define PROTO extern
#endif

#define ECAT_CS                         0xA0000000

#define EscWriteWord(ofs, outval) *((volatile int*)ECAT_CS + ((ofs)/2)) = (outval) & 0xffff
#define EscReadWord(ofs)  (*((volatile int*)(ECAT_CS) + ((ofs)/2)) & 0xffff)
///////////////////////////////////////////////////////////////////////////////////
// ESC Functions
///////////////////////////////////////////////////////////////////////////////////
PROTO UINT8   Et1100_Init(void);
PROTO UINT16  EepromReload(void);
void SetALEventMask(UINT16 intMask);
void ResetALEventMask(UINT16 intMask);
PROTO UINT16  GetALEventRegister(void);
PROTO TSYNCMAN ESCMEM *GetSyncMan(UINT8 channel);
PROTO void    DisableSyncManChannel(UINT8 channel);
PROTO void    EnableSyncManChannel(UINT8 channel);

PROTO void    EscReadMbxMem(MEM_ADDR *pData, UINT16 Address, UINT16 Len);
PROTO void    EscWriteMbxMem(MEM_ADDR *pData, UINT16 Address, UINT16 Len);


///////////////////////////////////////////////////////////////////////////////////
// Download Firmware
///////////////////////////////////////////////////////////////////////////////////
PROTO void DownloadFW_Start();
PROTO void DownloadFW_data(UINT16 *pData, UINT16 size);
PROTO void Boot_2_Init_handler();
PROTO void gotoBootLoader();


UINT16 DeviceIDGet();
void CH_ON(UINT16 Channel);
void CH_OFF(UINT16 Channel);

#endif /* ESCSTACK_FUNCTION_H_ */
