; ======== boot_c671x.s62 ========
;
		.title "Flash bootup utility"
		.option D,T
		.length 102
		.width 140

; global EMIF symbols defined for the c671x family
;	.include boot_c671x.h62

PAGE_SIZE     	.equ    0x80	  ;flash page size in byte
BOOT_SIZE     	.equ    0x800       ;bootup code size in byte
FLASH_START   	.equ    0x90000000  ;flash start address
BOOT_START    	.equ    0x00000000  ;L2 sram start address

CODE_SIZE     	.equ    0xF800      ;application code size in byte
CODE_START    	.equ    0x800       ;application code start address

FLASH_REG1    	.equ    0x90005555  ;address of the flash control reg 1
FLASH_REG2    	.equ    0x90002AAA  ;address of the flash control reg 2
FLASH_KEY1    	.equ    0xAA
FLASH_KEY2    	.equ    0x55
FLASH_KEY3    	.equ    0xA0
IO_PORT       	.equ    0x90080000  ;address of I/O port, only top byte has valid data 

EMIF_GCR     	.equ    0x01800000  ;EMIF global control     
EMIF_CE1      	.equ    0x01800004  ;address of EMIF CE1 control reg. 
EMIF_CE0      	.equ    0x01800008  ;EMIF CE0control          
EMIF_CE2		.equ	0x01800010	;EMIF CE2 control
EMIF_CE3		.equ	0x01800014	;EMIF CE3 control

EMIF_SDCTRL 	.equ    0x01800018  ;EMIF SDRAM control     
EMIF_SDRP 		.equ    0x0180001c  ;EMIF SDRM refresh period 
EMIF_SDEXT		.equ	0x01800020

EMIF_GCR_V   	.equ    0x00003078  ;GCTL REG Value
;EMIF_CE0_V		.equ    0x00000033  ;EMIF CE0control (32bit SDRAM 8M x 16)
EMIF_CE0_V		.equ    0xFFFFFF30  ;EMIF CE0control (32bit SDRAM)
EMIF_CE1_V		.equ    0xFFFFFF27  ;EMIF CE1control (16bit ROM)
;EMIF_CE2_V		.equ    0x4534D424  ;EMIF CE2control (I/O)
;EMIF_CE3_V		.equ    0x4534D424  ;EMIF CE3control (I/O)
EMIF_CE2_V		.equ    0x12914A21  ;EMIF CE2control (ASIC 100nsec)
;EMIF_CE3_V		.equ    0x11514521  ;EMIF CE3control (FPGA 50nsec)
EMIF_CE3_V		.equ    0x21F24723  ;EMIF CE3control (I/O)


;EMIF_SDCTRL_V	.equ    0x6348F000  ;EMIF SDRAM control
;EMIF_SDRP_V		.equ  	0x0200030D	;EMIF SDRAM refresh period = SDTIM
;EMIF_SDCTRL_V	.equ    0x07117000  ;EMIF SDRAM control (100MHz) 2017/06/28 SJL commented out
EMIF_SDCTRL_V	.equ    0x63117000  ;EMIF SDRAM control (100MHz);2017/06/28 SJL newly created
EMIF_SDRP_V		.equ  	0x0000061A	;EMIF SDRAM refresh period = SDTIM
EMIF_SDEXT_V	.equ	0x00058D29	;EMIF SDRM extension


;Address of the generated copy table
;COPY_TABLE .equ 0x90000400	; 8bit
COPY_TABLE .equ 0x90001000	; 16bit

	.sect ".boot_L"
	.global _boot

_boot:
;************************************************************************
;* DEBUG LOOP . COMMENT OUT B FOR NORMAL OPERATION
;************************************************************************
	   zero B1
_myloop: 
;    [!B1] B _myloop
	   nop 5

_myloopend: nop
;************************************************************************
;* CONFIGURE EMIF
;************************************************************************

	;****************************************************************
	; *EMIF_GCR = EMIF_GCR_V;
	;****************************************************************
	    mvkl EMIF_GCR,A4
	||  mvkl EMIF_GCR_V,B4
	    mvkh EMIF_GCR,A4
	||  mvkh EMIF_GCR_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_CE0 = EMIF_CE0_V
	;****************************************************************
	    mvkl EMIF_CE0,A4
	||  mvkl EMIF_CE0_V,B4
	    mvkh EMIF_CE0,A4
	||  mvkh EMIF_CE0_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_CE1 = EMIF_CE1_V (setup for 8.bit async)
	;****************************************************************
	    mvkl EMIF_CE1,A4
	||  mvkl EMIF_CE1_V,B4
	    mvkh EMIF_CE1,A4
	||  mvkh EMIF_CE1_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_CE2 = EMIF_CE2_V (setup for 32.bit async)
	;****************************************************************
	    mvkl EMIF_CE2,A4
	||  mvkl EMIF_CE2_V,B4
	    mvkh EMIF_CE2,A4
	||  mvkh EMIF_CE2_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_CE3 = EMIF_CE3_V (setup for 32.bit async)
	;****************************************************************
	||  mvkl EMIF_CE3,A4
	||  mvkl EMIF_CE3_V,B4 ;
	    mvkh EMIF_CE3,A4
	||  mvkh EMIF_CE3_V,B4
	    stw B4,*A4

	;****************************************************************
	; *EMIF_SDCTRL = EMIF_SDCTRL_V
	;****************************************************************
	||  mvkl EMIF_SDCTRL,A4
	||  mvkl EMIF_SDCTRL_V,B4 ;
	    mvkh EMIF_SDCTRL,A4
	||  mvkh EMIF_SDCTRL_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_SDRP = EMIF_SDRP_V
	;****************************************************************
	||  mvkl EMIF_SDRP,A4
	||  mvkl EMIF_SDRP_V,B4 ;
	    mvkh EMIF_SDRP,A4
	||  mvkh EMIF_SDRP_V,B4
	    stw B4,*A4
	;****************************************************************
	; *EMIF_SDRAMEXT = EMIF_SDRAMEXT_V
	;****************************************************************
	||  mvkl EMIF_SDEXT,A4
	||  mvkl EMIF_SDEXT_V,B4 ;
	    mvkh EMIF_SDEXT,A4
	||  mvkh EMIF_SDEXT_V,B4
	    stw B4,*A4

;****************************************************************************
; copy sections
;****************************************************************************
	mvkl COPY_TABLE, a3 ; load table pointer
	mvkh COPY_TABLE, a3
	;ldw *a3++, b1;	; Load entry point
	ldw *a3++, b4 ; byte count (low 16bit)
	nop	5
	ldw *a3++, b5 ; byte count (high 16bit)
	nop	5
	mvkl 0xffff, b6
	mvkh 0, b6
	and b4, b6, b4 ; set high-16bit as 0
	nop	5
	shl b5, 16, b6
	nop	5
	or	b4, b6, b1
	nop	5
copy_section_top:
	;ldw *a3++, b0 ; byte count
	ldw *a3++, b4 ; byte count (low 16bit)
	nop 5
	ldw *a3++, b5 ; byte count (high 16bit)
	nop 5
	mvkl 0xffff, b6
	mvkh 0, b6
	and b4, b6, b4 ; set high-16bit as 0
	nop 5
	shl b5, 16, b6
	nop 5
	or	b4, b6, b0
	nop 5
	;ldw *a3++, a4 ; ram start address
	ldw *a3++, a4 ; byte count (low 16bit)
	nop 5
	ldw *a3++, a5 ; byte count (high 16bit)
	nop 5
	mvkl 0xffff, a6
	mvkh 0, a6
	and a4, a6, a4 ; set high-16bit as 0 
	nop 5
	shl a5, 16, a6
	nop 5
	or	a4, a6, a4
	nop 5
  [!b0] b copy_done ; have we copied all sections?
	nop 5
copy_loop:
	ldw *a3++,b5
	sub b0,1,b0 ; decrement counter
  [ b0] b copy_highbyte ; setup branch if not done
  [!b0] b copy_section_top
	zero a1
  [!b0] and 3,a3,a1
	stb b5,*a4++
  [!b0] and -4,a3,a5 ; round address up to next multiple of 4
  [ a1] add 4,a5,a3 ; round address up to next multiple of 4

copy_highbyte:
	shr b5, 8, b5
	sub b0,1,b0 ; decrement counter
  [ b0] b copy_loop ; setup branch if not done
  [!b0] b copy_section_top
	zero a1
  [!b0] and 3,a3,a1
	stb b5,*a4++
  [!b0] and -4,a3,a5 ; round address up to next multiple of 4
  [ a1] add 4,a5,a3 ; round address up to next multiple of 4
	

;****************************************************************************
; jump to entry point
;****************************************************************************
copy_done:
	b .S2 b1
	nop 5

;COPY_TABLE: 
;text
;	.word 0x00001f80	
;	.word 0x00000920
;	.word 0x90000400	
	
;	.word 0 ; size End of Table
;	.word 0 ; dest End of Table
;	.word 0 ; src  End of Table