#ifndef _MK_AIO_DEFINES_H_
#define _MK_AIO_DEFINES_H_

enum _tcType {TC_TYPE_B, TC_TYPE_E, TC_TYPE_J, TC_TYPE_K, TC_TYPE_N, TC_TYPE_R, TC_TYPE_S, TC_TYPE_T};
enum _rtdType {RTD_TC100_2WIRE, RTD_TC1000_2WIRE, RTD_TC100_3WIRE, RTD_TC1000_3WIRE};

//  AI ġ ε  //
typedef struct{
	HANDLE hDevice; // PC=>Device handle, DSP=>Base address
	t_i32 nNumAi;
	t_i32 nAiIni;
	struct{
		t_ui32 Id:	8; // Device ID
		t_ui32 Ver:	4; // H/W Version
		t_ui32 ModId: 4; // Module Id (͸ ġ  )
		t_ui32 ModType: 2; // Module Type ( ,  , ĸ  reserved)
		t_ui32 Rsv:	14;
	}u;
	t_i32 nTcType;
	t_i32 nReserved[2];
}TAiDevice;

//  AO ġ ε  //
typedef struct{
	HANDLE hDevice; // PC=>Device handle, DSP=>Base address
	t_i32 nNumAo;
	t_i32 nAoIni;
	t_ui32 dwAoStates;
	struct{
		t_ui32 Id:	4; // Device ID
		t_ui32 Ver:	4; // H/W Version
		t_ui32 ModId: 4; // Module Id (͸ ġ  )
		t_ui32 ModType: 2; // Module Type ( ,  , ĸ  reserved)
		t_ui32 Rsv:	18;
	}u;
	t_i32 nReserved[2];	
}TAoDevice;

typedef struct{
    t_f32 aiOffset[36];
    t_f32 aiGain[36];
    t_ui32 aoOffset[16];
    t_ui32 aoGain[16];
} AioGainOffset;

void aioBootup(void);
t_i32 aioGetVersion(void);
void initaioset(void);

TAiDevice* aiGetDeviceDesc (t_ui16 uDevIdx);
TAoDevice* aoGetDeviceDesc (t_ui16 uDevIdx);

t_bool	aiInitial (t_ui16 nNumDevs, TAiDevice aAiDevInfo[]);
t_bool	aoInitial (t_ui16 nNumDevs, TAoDevice aAoDevInfo[]);

t_i32	aiGetNumDevice (void);
t_bool	aiIsValidChan(t_ui16 nAiChan);
t_ui16	aiGetNumChannels();

t_i32	aoGetNumDevice (void);
t_bool	aoIsValidChan(t_ui16 nAoChan);
t_ui16	aoGetNumChannels();

//   Լ
void	_aoSetChLED(t_ui32 nChannel, t_bool bState);
void	_aiSetChLED(t_ui32 nChannel, t_bool bState);

t_i32 aiSetVoltRangeMode(t_ui16 nChannel, t_i32 nMode); // nMode  mk_aio.c  Լպκп  .
t_i32 aiGetVoltRangeMode(t_ui16 nChannel, t_i32* pnMode);
t_i32 aiSetDegreeRangeMode(t_ui16 nChannel, t_i32 nMode);
t_i32 aiGetDegreeRangeMode(t_ui16 nChannel, t_i32* pnMode);
t_i32 aiGetRangeDigit(t_ui16 nChannel, t_i32* Dmin, t_i32* Dmax);
t_i32 aiGetDigit(t_ui16 nChannel, t_i16* pDigit);
t_i32 aiGetVolt(t_ui16 nChannel, t_f32* pfVolt);
t_i32 aiGetCurrent(t_ui16 nChannel, t_f32* pfCurrent);
t_i32 aiGetDegree(t_ui16 nChannel, t_f32* pfDegree);

t_i32 aoOutDigit(t_ui16 nChannel, t_i16 OutDigit);
t_i32 aoOutVolt(t_ui16 nChannel, t_f32 OutVolt);
t_i32 aoOutCurrent(t_ui16 nChannel, t_f32 OutCurrent);
t_i32 aiGetRef(t_ui16 nChannel, t_f32* pRef);

t_i32 _aiRntSetGain(t_ui16 nChannel, t_i32 nGain);
t_i32 _aiRntGetGain(t_ui16 nChannel, t_i32 *nGain);
t_i32 _aiRntSetOffset(t_ui16 nChannel, t_i32 nOffset);
t_i32 _aiRntGetOffset(t_ui16 nChannel, t_i32 *nOffset);
t_i32 _aiRntSaveFlash(t_ui16 nModIdx);
t_i32 _aiRntLoadFlash(t_ui16 nModIdx);
t_i32 _aiRntGetThermi(t_ui16 nModIdx, t_f32 *fVal);
t_i32 _aiRntGetRef(t_ui16 nModIdx, t_f32 *fVal);

void aioGainInit(void);
void aioGainOffsetWrite(void);
void aioGainOffsetRead(void);

t_i32 aiGainSet(t_i32 nChannel, t_f32 nGain);
t_i32 aiOffsetSet(t_i32 nChannel, t_f32 nOffset);
t_i32 aoGainSet(t_i32 nChannel, t_ui32 nGain);
t_i32 aoOffsetSet(t_i32 nChannel, t_ui32 nOffset);

t_i32 aiGainGet(t_i32 nChannel, t_f32* nGain);
t_i32 aiOffsetGet(t_i32 nChannel, t_f32* nOffset);
t_i32 aoGainGet(t_i32 nChannel, t_ui32* nGain);
t_i32 aoOffsetGet(t_i32 nChannel, t_ui32* nOffset);

t_i32 AIRTDReady(t_i32 nChannel);
t_i32 AIRTDRead(t_i32 nChannel, t_i32* nData);

#if (_PLATFORM==PLF_RTEX) //@@@@@@@@@@@@@@@@@ #1
extern TAiDevice g_aAiDev[NUM_MAX_AIOMODULE];
extern TAoDevice g_aAoDev[NUM_MAX_AIOMODULE];
#endif //@@@@@@@@@@@@@@@@@ #1

#endif

