//================================================================================================================
// [mk_dio.h] : 
// - Version: 1.0.0.0
// - Update Data: 2007/10/11
// - Created by OYS
// -. Revision history:
//   1 <Ver 1.0.0.0>:    .
//   2 <Ver 1.0.0.1>: [2009/03/17] 
//    1) ResetDIOModule Լ   => mk_common.h  ű.
//================================================================================================================
#ifndef _MK_DIO_DEFINES_H_
#define _MK_DIO_DEFINES_H_

// ---------------------------------------------------------------------------
// Channel Logic
// ---------------------------------------------------------------------------
#ifndef LOGIC_A
#define LOGIC_A 	0
#endif

#ifndef LOGIC_B
#define LOGIC_B 	1
#endif

enum _TDioMode {IOM_INPUT, IOM_OUTPUT}; // DIO channel IN/OUT  

//  DIO ġ ε  //
typedef struct{
	HANDLE hDevice; // PC=>Device handle, DSP=>Base address
	t_i32 nNumDio, nNumDi, nNumDo;
	t_i32 nDioIni;
	t_ui32 dwIOMM; //  äκ I/O mode mask
	t_ui32 dwIOMM_PRE; //  äκ I/O mode mask   ( ġ  ϱ    ϴ )
	t_ui32 dwDoStates;
	t_ui32 dwDioStates;
	struct{
		t_ui32 Id:	8; // Device ID
		t_ui32 Ver:	4; // H/W Version
		t_ui32 ModId: 4; // Module Id (͸ ġ  )
		t_ui32 Rsv:	16;
	}u;
}TDioDevice;

void	dioBootup(void);
t_i32 	dioGetVersion(void);
TDioDevice* dioGetDeviceDesc (t_ui16 uDevIdx);

t_bool	diIsValidChan(t_ui16 nDiChan);
t_ui16	diGetNumChannels();
t_bool	diGetLogic(t_ui16 nChannel);
void	diSetLogic(t_ui16 nChannel, t_bool bLogic);
t_ui32	diGetLogicMulti(t_ui16 nIniChan, t_ui16 nNumChan);
void	diSetLogicMulti(t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwLogicMask);
t_bool	diGetOne (t_ui16 nChannel);
t_ui32	diGetMulti (t_ui16 nIniChan, t_ui16 nNumChan);

t_bool	doIsValidChan(t_ui16 nDoChan);
t_ui16	doGetNumChannels();
t_bool	doGetLogic(t_ui16 nChannel);
void	doSetLogic(t_ui16 nChannel, t_bool bLogic);
t_ui32	doGetLogicMulti(t_ui16 nIniChan, t_ui16 nNumChan);
void	doSetLogicMulti(t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwLogicMask);
void	doPutOne (t_ui16 nChannel, t_bool bState);
t_bool	doGetOne (t_ui16 nChannel);
void	doPutMulti (t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwStates);
t_ui32	doGetMulti (t_ui16 nIniChan, t_ui16 nNumChan);

void	dioInitial (t_ui16 nNumDevs, TDioDevice aDioDevInfo[]);
t_i32	dioGetNumDevice (void);
t_i32 	dioGetNumDevice_Ex (t_ui16 nModType); // 0: ceD16CM, 1: ceDI32N, 2: ceDO32N
t_ui16	dioGetNumChannels();
t_bool	dioGetIomode (t_ui16 nChannel);
void	dioSetIomode (t_ui16 nChannel, t_bool nInOutMode);
t_ui32	dioGetIomodeMulti (t_ui16 nIniChan, t_ui16 nNumChan);
void	dioSetIomodeMulti (t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwIOMM);
t_bool	dioGetLogic (t_ui16 nChannel);
void	dioSetLogic (t_ui16 nChannel, t_bool bLogic);
t_ui32	dioGetLogicMulti (t_ui16 nIniChan, t_ui16 nNumChan);
void	dioSetLogicMulti (t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwLogicMask);
void	dioPutOne (t_ui16 nChannel, t_bool bState);
t_bool	dioGetOne (t_ui16 nChannel);
void	dioPutMulti (t_ui16 nIniChan, t_ui16 nNumChan, t_ui32 dwStates);
t_ui32	dioGetMulti (t_ui16 nIniChan, t_ui16 nNumChan);
t_i32 	GetModuleTrType(t_ui16 nModId);

#if (_PLATFORM==PLF_RTEX) //@@@@@@@@@@@@@@@@@ #1
extern TDioDevice g_aDioDev[NUM_MAX_DIOMODULE]; 
#endif

#endif
