//================================================================================================================
// [mk_common.c] : 
// - Version: 1.0.0.0
// - Update Data: 2007/10/11
// - Created by OYS
// -. Revision history:
//   1 <Ver 1.0.0.0>:    .
//   2 <Ver 1.0.0.1>: [2009/03/17] 
//    1) ResetMotionModule Լ   => mk_commoh.h  ű.
//================================================================================================================
#ifndef _MK_MOTION_DEFINES_H_
#define _MK_MOTION_DEFINES_H_

#include "mk_common.h"

#define P6045_BASE_CLK	(t_f64)(19660800L) //*(t_f64)1.00124)
//#define P6045_BASE_CLK	19660000L

#define DISABLE_BL_CORR		// [FIXME] Ŀ backlash correction ȭϷ   ּó  

typedef enum _TMCWAddr {COMW, OTPW, BUF0, BUF1}TMCWAddr;
typedef enum _TMCRAddr {MSTSW, SSTSW}TMCRAddr;
typedef enum _TMCBAddr {COMB0, COMB1, OTPB, MCB_INVALID, BUFB0, BUFB1, BUFB2, BUFB3}TMCBAddr;
typedef enum _TMMS8 {MSTSB0, MSTSB1, IOPB, SSTSB}TMMS8; // main space address for read in 8-bit interface

typedef enum _TPclRegId {PRMV=0, PRFL=1, PRFH=2, PRUR=3, PRDR=4, PRMG=5, PRDP=6, PRMD=7, PRIP=8, PRUS=9, 
	PRDS=10, PRCP5, PRCI, RMV=16, RFL=17, RFH=18, RUR=19, RDR=20, RMG=21, RDP=22, RMD=23, 
	RIP=24, RUS=25, RDS=26, RFA=27, RENV1=28, RENV2=29, RENV3=30, RENV4=31, RENV5=32, 
	RENV6, RENV7, RCUN1=35, RCUN2, RCUN3, RCUN4, RCMP1, RCMP2, RCMP3, RCMP4, RCMP5, 
	RIRQ, RLTC1, RLTC2, RLTC3, RLTC4, RSTS=49, REST, RIST, RPLS=52, RSPD, PSDC, RCI
}TPclRegId;

//  Motion controller ġ  //
typedef struct{
	HANDLE hDevice; // PC=>Device handle, DSP=>Base address
	t_i32 nNumAxes;
	t_i32 nAxisIni;
	struct{
		t_ui32 Id:	4; // Device ID
		t_ui32 Ver:	4; // H/W Version
		t_ui32 ModId: 4; // Module Id (͸ ġ  )
		t_ui32 Rsv:	20;
	}u;
	t_ui8 nHCMP[4];
}TMotDevice;

// Motion I/O Property ID //
typedef enum _TCmMioPropId{
	cmMPID_ALM_LOGIC,	cmMPID_ALM_MODE,	cmMPID_CMP_LOGIC,	cmMPID_DR_LOGIC,	cmMPID_EL_LOGIC,	cmMPID_EL_MODE, 
	cmMPID_ERC_LOGIC,	cmMPID_ERC_OUT,		cmMPID_EZ_LOGIC,	cmMPID_INP_EN,		cmMPID_INP_LOGIC,	cmMPID_LTC_LOGIC, 
	cmMPID_LTC_LTC2SRC,	cmMPID_ORG_LOGIC,	cmMPID_SD_EN,		cmMPID_SD_LOGIC,	cmMPID_SD_LATCH,	cmMPID_SD_MODE, 
	cmMPID_STA_MODE,	cmMPID_STA_TRG,		cmMPID_STP_MODE,	cmMPID_CLR_CNTR,	cmMPID_CLR_SIGTYPE,	cmMPID_CMP_PWIDTH, 
	cmMPID_ERC_ONTIME,	cmMPID_SVON_LOGIC,	cmMPID_ERC_OUT_EL,	cmMPID_CNT_D_SRC,	cmMPID_CNT_G_SRC,	cmMPID_LTC_TRGMODE,
	cmMPID_SLIM_EN=100,	cmMPID_OUT_MODE,	cmMPID_IN_MODE,		cmMPID_IN_INV,		cmMPID_CEMG_EN,		cmMPID_CTRL_MODE,
	cmMPID_SEQ_MODE
}TCmMioPropId;

// Bit order of StReadMioStatuses() return value  //
typedef enum _TCmMioState{
	cmIOST_RDY, cmIOST_ALM,	  cmIOST_ELN,  cmIOST_ELP, cmIOST_ORG, 
	cmIOST_DIR, cmIOST_EZ,	  cmIOST_LTC,  cmIOST_SD,  cmIOST_INP, 
	cmIOST_DRN, cmIOST_DRP,	  cmIOST_STA,  cmIOST_STP, cmIOST_ALMR,
	cmIOST_EMG, cmIOST_SVON,  cmIOST_HOMS, cmIOST_PLSA
}TCmMioState;

// Motion operation status ID //
typedef enum _TCmMotionState{ 
	cmMST_STOP,			cmMST_WAIT_DR,	cmMST_WAIT_STA,		cmMST_WAIT_INSYNC,	cmMST_WAIT_OTHER, 
	cmMST_WAIT_ERC,		cmMST_WAIT_DIR, cmMST_RESERVED1,	cmMST_WAIT_PLSR,	cmMST_IN_RVSSPD, 
	cmMST_IN_INISPD,	cmMST_IN_ACC,	cmMST_IN_WORKSPD,	cmMST_IN_DEC,		cmMST_WAIT_INP, 
	cmMST_SPARE0
}TCmMotionState;

// Signal logic definition //
typedef enum _TCmSigLogic{ 
	cmLOGIC_A=0 /*Normal open*/, cmLOGIC_B=1/*Normal close*/ 
}TCmSigLogic;

// Axis index definition //
typedef enum _TCmAxis{ 
	cmX1, cmY1, cmZ1, cmU1, cmX2, cmY2, cmZ2, cmU2 
}TCmAxis;

// Definition for axes mask  //
typedef enum _TCmAxisMask{ 
	cmX1_MASK=0x1, cmY1_MASK=0x2, cmZ1_MASK=0x4, cmU1_MASK=0x8,
	cmX2_MASK=0x10, cmY2_MASK=0x20, cmZ2_MASK=0x40, cmU2_MASK=0x80
}TCmAxisMask;

// Encoder and PA/PB input mode definition //
typedef enum _TCmInMode{ 
	cmIMODE_AB1X, cmIMODE_AB2X, cmIMODE_AB4X, cmIMODE_CWCCW, cmIMODE_STEP
}TCmInMode;

// Command output mode definition //
typedef enum _TCmOutMode{ 
	cmOMODE_PDIR0, cmOMODE_PDIR1, cmOMODE_PDIR2, cmOMODE_PDIR3,
	cmOMODE_CWCCW0, cmOMODE_CWCCW1, cmOMODE_CCWCW0, cmOMODE_CCWCW1
}TCmOutMode;

// Control Mode //
typedef enum _TCmCtrlMode{ 
	cmCTRL_OPEN, // Open loop control mode
	cmCTRL_SEMI_C, // Semi-closed loop control mode (applied only to absolute in-position commands)
	cmCTRL_FULL_C // Full-closed loop control mode (this is not supported at current version)
}TCmCtrlMode;

// Sequence Mode //
typedef enum _TCmSeqMode{
	cmSEQM_SKIP_RUN, cmSEQM_WAIT_RUN
}TCmSeqMode;
			
// (Linear)Operation direction //	
typedef enum _TCmDir{
	cmDIR_N /*(-)Dir*/, cmDIR_P /*(+)Dir*/
}TCmDir;

// Counter name //
typedef enum _TCmCntr { 
	cmCNT_COMM/*Command*/, cmCNT_FEED/*Feedback*/, cmCNT_DEV/*Deviation*/, 
	cmCNT_GEN/*General*/, cmCNT_REM/*Remained*/
}TCmCntr;

// Speed mode index definition //	
typedef enum _TCmSpeedMode{ 
	cmSMODE_KEEP=-1/* Keep previous setting*/, cmSMODE_C=0 /*Constant */, cmSMODE_T /*Trapeziodal*/, cmSMODE_S /*S-curve*/
}TCmSpeedMode;

// Arc operation direction //
typedef enum _TCmArcDir{ 
	cmARC_CW, cmARC_CCW
}TCmArcDir;

// Compare Method //
typedef enum _TCmCmpMethod{
	cmDISABLE, cmEQ_BIDIR, cmEQ_PDIR, cmEQ_NDIR, cmLESS/*Cnt<Data*/, cmGREATER/*Cnt>Data*/
}TCmCmpMethod;

// Action when general comparator met the condition //
typedef enum _TCmCmpAction{
	cmEVNT_ONLY, cmEVNT_IS, cmEVNT_DS, cmEVNT_SPDCHG
}TCmCmpAction;

// Backlash/Slip correction mode //
typedef enum _TCmCorrMode{
	cmCORR_DIS, // Disable correction 
	cmCORR_BACK, // Backlash correction mode 
	cmCORR_SLIP // Slip correction mode
}TCmCorrMode;

typedef enum _TCmExtOptionId{
	cmEXOPT_SET_USE_PREREG
}TCmExtOptionId;

// Interrupt Handler Type //
typedef enum _TCmIntHandlerType{
	cmIHT_MESSAGE=0, cmIHT_EVENT, cmIHT_CALLBACK
}TCmIntHandlerType;

// Interrupt Handler Type //
typedef enum _TCmStringID{
	cmSTR_AXIS_NAME, cmSTR_DIST_UNIT, cmSTR_SPEED_UNIT
}TCmStringID;

// Map Type //
typedef enum _TCmDevMapType{
	cmDMAP_MOTION, cmDMAP_DIO, cmDMAP_ALL
}TCmDevMapType;

// SetFilterAB  //
typedef enum _TCmABFilter{
	cmAB_ENC, cmAB_PULSAR
}TCmABFilter;

// Axis Capability ID //
typedef enum _TCmAxisCapID{
	cmCAPX_CMD_DIR=0, /* Command direction change function */
	cmCAPX_EL_MAN_SET, /* -/+EL Manual control function */
	cmCAPX_CMP_HIGH /* High-speed Compare Output function */
}TCmAxisCapID;

typedef enum _TCmHomePosClrMode{
	cmHPCM_DISABLE=-1, // Disable HomePosClearMode 
	cmHPCM_M0, // ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cmHPCM_M1, // ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cmHPCM_M2  // ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
}TCmHomePosClrMode;

// Sync mode //
typedef enum _TCmSyncMode{
	cmSYNC_DISABLE,
	cmSYNC_INT_SYNC,
	cmSYNC_OTHER_STOP
}TCmSyncMode;

// Internal sync. conditions //
typedef enum _TCmIntSyncCond{
	cmISYNC_ACC_STA, // 0: at start of acceleration
	cmISYNC_ACC_END, // 1: at end of acceleration
	cmISYNC_DEC_STA, // 2: at start of deceleration
	cmISYNC_DEC_END, // 3: at end of deceleration
	cmISYNC_SLN, // 4: when (-)software limit met
	cmISYNC_SLP, // 5: when (+)software limit met
	cmISYNC_GCMP, // 6: when General Comparator condition is satisfied
	cmISYNC_TCMP // 7: when Trigger Comparator condition is satisfied
}TCmIntSyncCond;

// Position latch trigger mode //
typedef enum _TCmLatchTrgMode{
	cmLTM_LTC, // LTC Է ȣ ؼ  ġ ˴ϴ.
	cmLTM_ORG // ORG Է ȣ ؼ  ġ ˴ϴ.
}TCmLatchTrgMode;

//====================== UTIL FUNCTIONS ==============================================================================//
t_i32	pclReadMainSpace (t_i32 nAxis, t_i32 nAddr);
t_bool	pclWriteMainSpace (t_i32 nAxis, t_i32 nAddr, t_i32 dwValue);
t_i32	pclReadReg (t_i32 nAxis, t_i32 nReg);
t_bool	pclWriteReg (t_i32 nAxis, t_i32 nReg, t_i32 dwVal);
t_bool	pclIsRegReady (t_i32 nAxis, t_bool bWaitDone);
t_bool	pclGetEmgStopUser();
t_bool 	pclPlsrIsActive (t_i32 nAxis);

//====================== API FUNCTIONS ===============================================================================//
void	mcBootup(void);
t_i32 	mcGetVersion(void);
t_i32	mcGnInitMotion (t_i32 nNumDevs, TMotDevice aMotDevInfo[]);
t_bool	mcGnResetDevice(void);
t_i32	mcGnGetNumAxes ();
t_i32	mcGnSetEmergency (t_i32 nState);
t_bool	mcGnGetEmergency (void);
t_i32	mcGnUserEmg_SetEnable(t_bool bEnable);
t_bool	mcGnUserEmg_GetEnable(void);
t_i32	mcCfgSetMioEnv(t_i32 nAxis, t_i32 dwPropId, t_i32 dwPropVal);
t_i32	mcCfgGetMioEnv(t_i32 nAxis, t_i32 dwPropId);
t_i32	mcCfgSetFilter(t_i32 nAxis, t_bool bIsEnable);
t_bool	mcCfgGetFilter(t_i32 nAxis);
t_i32	mcCfgSetFilterAB(t_i32 nAxis, t_i32 nTarget, t_bool bIsEnable);
t_bool	mcCfgGetFilterAB(t_i32 nAxis, t_i32 nTarget);
t_i32	mcCfgSetMaxPPS(t_i32 nAxis, t_f32 fMaxPPS);
t_f32	mcCfgGetMaxPPS(t_i32 nAxis);
t_i32	mcCfgSetLogicDist(t_i32 nAxis, t_f32 fPPUD);
t_f32	mcCfgGetLogicDist(t_i32 nAxis);
t_i32	mcCfgSetLogicSpeed(t_i32 nAxis, t_f32 fPPUS);
t_f32	mcCfgGetLogicSpeed(t_i32 nAxis);
t_i32 	mcCfgSetIniSpeed(t_i32 nAxis, t_f32 fIniSpeed);
t_f32	mcCfgGetIniSpeed(t_i32 nAxis);
t_i32	mcCfgSetSoftLimitRange(t_i32 nAxis, t_f32 fNegLim, t_f32 fPosLim);
void	mcCfgGetSoftLimitRange(t_i32 nAxis, t_f32 *pfNegLim, t_f32 *pfPosLim);
t_i32	mcCfgSetCorrection(t_i32 nAxis, t_i32 nCorrMode, t_f32 fCorrAmount, t_f32 fCorrVel, t_i32 dwCntrMask);
t_i32	mcCfgGetCorrection (t_i32 nAxis, t_i32 *pnCorrMode, t_f32 *pfCorrAmount, t_f32 *pfCorrVel, t_i32 *pdwCntrMask);
t_i32	mcCfgSetRingCntr(t_i32 nAxis, t_i32 nTargCntr, t_i32 bIsEnable, t_f32 fMaxPos);
t_i32	mcCfgGetRingCntr(t_i32 nAxis, t_i32 nTargCntr, t_i32* pbIsEnable, t_f32* pfMaxPos);
t_i32	mcHomeSetConfig (t_i32 nAxis, t_i32 nHomeMode, t_i32 nDir, t_i32 nEzCnt, t_f32 fEscDist);
void	mcHomeGetConfig (t_i32 nAxis, t_i32* pnHomeMode, t_i32 *pnDir, t_i32* pnEzCnt, t_f32* pfEscDist);
t_i32	mcHomeSetConfigEx (t_i32 nAxis, t_i32 nHomeMode, t_i32 nDir, t_i32 nEzCnt, t_f32 fEscDist, t_f32 fOffset);
t_i32	mcHomeGetConfigEx (t_i32 nAxis, t_i32* pnHomeMode, t_i32 *pnDir, t_i32* pnEzCnt, t_f32* pfEscDist, t_f32* pfOffset);
t_i32	mcHomeSetPosClrMode (t_i32 nAxis, t_i32 nPosClrMode);
t_i32	mcHomeGetPosClrMode (t_i32 nAxis);
t_i32	mcHomeSetSpeedPattern (t_i32 nAxis, t_i32 nVMode, t_f32 fVel, t_f32 fAcc, t_f32 fDec, t_f32 fRvsVel);
void	mcHomeGetSpeedPattern (t_i32 nAxis, t_i32* pnVMode, t_f32* pfVel, t_f32* pfAcc, t_f32* pfDec, t_f32* pfRvsVel);
t_i32	mcHomeMove (t_i32 nAxis, t_bool bWaitDone);
t_bool	mcHomeIsBusy(t_i32 nAxis);
t_i32	mcHomeWaitDone(t_i32 nAxis);
t_i32 	mcHomeSetSuccess(t_i32 nAxis, t_bool bSuccess);
t_bool	mcHomeGetSuccess(t_i32 nAxis);
//t_i32	mcSxSetSvon (t_i32 nAxis, t_i32 nState);
//t_bool	mcSxGetSvon (t_i32 nAxis);
t_i32   mcSxSetAWO (t_i32 nAxis, t_i32 nState);
t_bool  mcSxGetAWO (t_i32 nAxis);
t_i32   mcSxSetSCS (t_i32 nAxis, t_i32 nState);
t_bool  mcSxGetSCS (t_i32 nAxis);
t_bool  mcSxGetTIM (t_i32 nAxis);
t_i32	mcSxSetAlmRst(t_i32 nAxis, t_i32 nState);
t_bool	mcSxGetAlmRst(t_i32 nAxis);
t_i32	mcSxSetSpeedPattern (t_i32 nAxis, t_i32 nVMode, t_f32 fVel, t_f32 fAcc, t_f32 fDec);
t_bool	mcSxGetSpeedPattern (t_i32 nAxis, t_i32* pnVMode, t_f32* pfVel, t_f32* pfAcc, t_f32* pfDec);
t_i32	mcSxSetSpeedRatio (t_i32 nAxis, t_f32 fVelR, t_f32 fAccR, t_f32 fDecR);
t_i32	mcSxGetSpeedRatio (t_i32 nAxis, t_f32* pfVelR, t_f32* pfAccR, t_f32* pfDecR);
void	mcSxGetActSpeedSet(t_i32 nAxis, t_i32* pnVMode, t_f32 *pfVini, t_f32* pfVwork, t_f32* pfAcc, t_f32* pfDec);
t_i32	mcSxSetRdpOfs(t_i32 nAxis, t_f32 fRdpOfs);
t_f32	mcSxGetRdpOfs(t_i32 nAxis);
t_i32	mcSxJog (t_i32 nAxis, t_i32 nDir);
t_i32   mcSxSetDistance (t_i32 nAxis, t_f32 fDistance);
t_i32   mcSxStart (t_i32 nAxis, t_bool bWaitDone);
t_i32	mcSxMove (t_i32 nAxis, t_f32 fDistance, t_bool bWaitDone);
t_i32	mcSxMoveTo (t_i32 nAxis, t_f32 fPosition, t_bool bWaitDone);
t_i32	mcSxMove_2Vel (t_i32 nAxis, t_f32 fDistance, t_f32 fVel2, t_bool bWaitDone);
t_i32	mcSxMoveTo_2Vel (t_i32 nAxis, t_f32 fPosition, t_f32 fVel2, t_bool bWaitDone);
t_i32	mcSxWaitDone(t_i32 nAxis);
t_bool	mcSxIsDone(t_i32 nAxis);
t_bool	mcSxChangeToIniSpeed(t_i32 nAxis, t_bool bDecel);
t_bool	mcSxChangeToWorkSpeed(t_i32 nAxis, t_bool bDecel);
t_i32	mcSxStop(t_i32 nAxis, t_bool bDecel, t_bool bWaitDone);
t_f32	mcSxGetTargPos(t_i32 nAxis);
t_i32	mcMxMove (t_i32 nNumAxes, t_i32 anAxes[], t_f32 afDistance[], t_bool bWaitDone);
t_i32	mcMxMoveTo (t_i32 nNumAxes, t_i32 anAxes[], t_f32 afPosition[], t_bool bWaitDone);
t_i32	mcMxWaitDone(t_i32 nNumAxes, t_i32 anAxes[]);
t_bool	mcMxIsDone(t_i32 nNumAxes, t_i32 nAxes[]);
t_bool	mcMxIsDone_Mask(t_ui32 dwAxisMask);
t_i32	mcMxStop(t_i32 nNumAxes, t_i32 anAxes[], t_bool bDecel, t_bool bWaitDone);
t_i32	mcIxSetAxisMap(t_i32 nMapIndex, t_ui32 dwMapMask);
t_ui32	mcIxGetAxisMap(t_i32 nMapIndex);
t_i32	mcIxSetVelCorrMode(t_i32 nMapIndex, t_i32 nVelCorrOpt1, t_i32 nVelCorrOpt2);
t_i32	mcIxGetVelCorrMode(t_i32 nMapIndex, t_i32* pnVelCorrOpt1, t_i32* pnVelCorrOpt2);
t_i32	mcIxSetSpeedPattern (t_i32 nMapIndex, t_i32 bIsVectorSpeed, t_i32 nSpeedMode, t_f32 fVel, t_f32 fAcc, t_f32 fDec);
void	mcIxGetSpeedPattern (t_i32 nMapIndex, t_i32 *pbIsVectorSpeed, t_i32 *pnSpeedMode, t_f32 *pfVel, t_f32 *pfAcc, t_f32 *pfDec);
t_i32	mcIxLine (t_i32 nMapIndex, t_f32 afDistList[], t_bool bWaitDone, t_bool bIsBatchMode);
t_i32	mcIxLineTo (t_i32 nMapIndex, t_f32 afPosList[], t_bool bWaitDone, t_bool bIsBatchMode);
t_i32	mcIxArc(t_i32 nMapIndex, t_f32 fCenPos[], t_f32 fEndPos[], t_i32 nDir, t_bool bWaitDone);
t_i32	mcIxArcTo(t_i32 nMapIndex, t_f32 fCenPos[], t_f32 fEndPos[], t_i32 nDir, t_bool bWaitDone);
t_i32	mcIxArcA(t_i32 nMapIndex, t_f32 afCenPos[], t_f32 fAngle, t_bool bIsAbsPos, t_bool bWaitDone);
t_i32	mcIxArc3P(t_i32 nMapIndex, t_f32 P2[], t_f32 P3[], t_f32 fAngle, t_bool bIsAbsPos, t_bool bWaitDone);
t_i32	mcIxSpline(t_i32 nMapIndex, t_f32 **PP, t_i32 n_inp, t_i32 n_div);
t_bool	mcIxIsDone(t_i32 nMapIndex);
t_i32	mcIxWaitDone(t_i32 nMapIndex);
t_i32	mcIxStop(t_i32 nMapIndex, t_bool bDecel, t_bool bWaitDone);
t_i32	mcPlsrSetInMode(t_i32 nAxis, t_i32 nInputMode, t_bool bIsRevDir);
t_i32	mcPlsrGetInMode(t_i32 nAxis, t_i32* pnInputMode, t_bool* pbIsRevDir);
t_i32	mcPlsrSetGain(t_i32 nAxis, t_i32 nGainFactor, t_i32 nDivFactor);
t_i32	mcPlsrGetGain(t_i32 nAxis, t_i32* pnGainFactor, t_i32* pnDivFactor);
t_i32	mcPlsrHomeMoveStart(t_i32 nAxis, t_i32 nHomeType);
t_i32	mcPlsrJogStart(t_i32 nAxis);
t_i32	mcPlsrMove (t_i32 nAxis, t_f32 fDistance, t_bool bWaitDone);
t_i32	mcPlsrMoveTo (t_i32 nAxis, t_f32 fPosition, t_bool bWaitDone);
t_bool	mcPlsrIsActive (t_i32 nAxis);
t_i32	mcOverrideSpeedSet(t_i32 nAxis);
t_i32	mcOverrideMove (t_i32 nAxis, t_f32 fNewDist, t_bool bIsHardApply, t_i32 *pnState);
t_i32	mcOverrideMoveTo (t_i32 nAxis, t_f32 fNewPos, t_bool bIsHardApply, t_i32 *pnState);
t_i32	mcStGetCount(t_i32 nAxis, t_i32 nSource);
t_i32	mcStSetCount(t_i32 nAxis, t_i32 nSource, t_i32 nCount);
t_f32	mcStGetPosition(t_i32 nAxis, t_i32 nSource);
t_i32	mcStSetPosition(t_i32 nAxis, t_i32 nSource, t_f32 fPosition);
t_f32	mcStGetSpeed(t_i32 nAxis, t_i32 nSource);
t_i32	mcStGetMst(t_i32 nAxis);
t_ui32	mcStGetMio(t_i32 nAxis);
t_i32	mcErrClearAxisError(t_i32 nAxis);
t_i32	mcErrGetAxisError(t_i32 nAxis);
t_i32	mcErrGetLastError();
void	mcErrGetErrorString(t_i32 nErrCode, char* szBuffer);
void	mcErrClearLastError(t_ui32 dwAxisMask);
t_i32	mcIntSetMask(t_i32 nAxis, t_ui32 dwMask);
t_ui32	mcIntGetMask(t_i32 nAxis);
void	mcISR();
void	mcTimerCallback();
t_bool	mcLtcIsLatched(t_i32 nAxis);
t_f32	mcLtcReadLatch(t_i32 nAxis, t_i16 nCounter);
t_i32	mcLtcQue_Alloc(t_i32 nAxis, t_ui32 nQueSize, t_ui16 nLtcSrcCntr);
t_i32	mcLtcQue_Free(t_ui16 nAxis);
t_ui32	mcLtcQue_GetSize(t_ui16 nAxis);
t_i32	mcLtcQue_Reset(t_ui16 nAxis);
t_ui32	mcLtcQue_Check(t_ui16 nAxis);
t_f32	mcLtcQue_Pop(t_ui16 nAxis, t_i32 *pnErrCode);
t_f32	mcLtcQue_GetAt(t_ui16 nAxis, t_ui32 nIndex, t_i32 *pnErrCode);
t_i32	mcCmpErr_Set(t_i32 nAxis, t_f32 fCmpData, t_i32 nCmpAction);
t_i32	mcCmpErr_Get(t_i32 nAxis, t_f32* pfCmpData, t_i32* pnCmpAction);
t_i32	mcCmpGen_Set(t_i32 nAxis, t_i32 nCmpSrc, t_i32 nCmpMethod, t_f32 fCmpData, t_i32 nCmpAction);
t_i32	mcCmpGen_Get(t_i32 nAxis, t_i32 *pnCmpSrc, t_i32 *pnCmpMethod, t_f32 *pfCmpData, t_i32 *pnCmpAction);
t_i32	mcCmpTrg_SetCfg(t_i32 nAxis, t_i32 nCmpSrc, t_i32 nCmpMethod);
t_i32	mcCmpTrg_GetCfg(t_i32 nAxis, t_i32 *pnCmpSrc, t_i32 *pnCmpMethod);
t_i32	mcCmpTrg_SetData(t_i32 nAxis, t_f32 fCmpData);
t_i32	mcCmpTrg_GetData(t_i32 nAxis, t_f32 *pfCmpData);
t_i32	mcMs_RegSlave(t_i32 nAxis, t_f32 fMaxSpeed, t_bool bIsRevDir);
t_i32	mcMs_UnregSlave(t_i32 nAxis);
t_i32	mcMs_CheckSlaveState(t_i32 nAxis);
t_i32	mcMs_GetMaster(t_i32 nAxis);
t_i32	mcAdvGetNumDevices (); 
t_bool	mcAdvGetMotDevInfo(t_i32 nDevIdx, TMotDevice* pMotDevBuf);
t_i32	mcAdvStaTrigger(t_i32 nAxis);
t_i32	mcAdvErcOut(t_i32 nAxis);
t_i32	mcAdvErcReset(t_i32 nAxis);
t_bool	mcAdvIsPreRegFull(t_i32 nAxis);
void	mcAxisTask_Main(t_i32 nAxis);
t_i32	mcLm_Begin(t_ui16 LmIdx, t_ui32 AxisMask, t_ui32 QueSize);
t_i32	mcLm_End(t_ui16 LmIdx);
t_i32	mcLm_StartMot(t_ui16 LmIdx);
t_i32	mcLm_StopMot(t_ui16 LmIdx, t_ui8 StopMode, t_ui32 DecTime_ms, t_bool IsClearQue);
t_i32	mcLm_SetStepId_Reg(t_ui16 LmIdx, t_i32 StepId);
t_i32	mcLm_GetStepId_Reg(t_ui16 LmIdx, t_i32 *pStepId);
t_i32	mcLm_SetUserPara_Reg(t_ui16 LmIdx, t_ui32 ParamIdx, t_i32 ParamVal);
t_i32	mcLm_GetUserPara_Reg(t_ui16 LmIdx, t_ui32 ParamIdx, t_i32 *pParamVal);
t_i32	mcLm_GetUserPara_Run(t_ui16 LmIdx, t_ui32 ParamIdx, t_i32 *pParamVal);
t_i32	mcLm_GetStates(t_ui16 LmIdx, t_byte *pFlags, t_ui16 *pQueFreeSize, t_ui16 *pRunStepCnt, t_ui32 *pRunStepId);
t_i32	mcLm_IsDone(t_ui16 LmIdx, t_i32 *isDone);

t_bool siGetOne(t_ui32 nChannel);
t_i32 siGetMulti(t_ui32 nIniChan, t_ui32 nNumChan);
void soPutOne(t_ui32 nChannel, t_bool bState);
t_bool soGetOne(t_ui32 nChannel);
void soPutMulti(t_ui32 nIniChan, t_ui32 nNumChan, t_ui32 dwStates);
t_i32 soGetMulti(t_ui32 nIniChan, t_ui32 nNumChan);

t_i32 mcSxOptSetSyncMode(t_i32 nAxis, t_i32 nMode, t_i32 nRefAxis, t_i32 Condition);
t_i32 mcSxOptGetSyncMode(t_i32 nAxis, t_i32 *nMode, t_i32 *nRefAxis, t_i32 *Condition);
t_i32 mcSxOptSetSyncOut(t_i32 nAxis, t_i32 Mode, t_i32 DoChan_local, t_i32 DoLogic);
t_i32 mcSxOptGetSyncOut(t_i32 nAxis, t_i32 *Mode, t_i32 *DoChan_local, t_i32 *DoLogic);

t_i32 mcCfgSetVelCorrRatio(t_i32 nAxis, t_f32 fCorrRatio);
t_i32 mcCfgGetVelCorrRatio(t_i32 nAxis, t_f32 *fCorrRatio);

void hommingCallback(t_i32 nAxis);

t_i32 mcIxSetMasterAxis(t_i32 nAxis, t_i32 bSetValue);
t_i32 mcIxGetMasterAxis(t_i32 nAxis, t_i32 *bSetValue);
t_i32 mcIxSetSmartDecel(t_i32 nAxis, t_i32 bSetValue);
t_i32 mcIxGetSmartDecel(t_i32 nAxis, t_i32 *bSetValue);
t_i32 mcIxSmartStop(t_i32 nMapIndex, t_f32 fDecelTimeSec);

t_i32 mcCfgSetActSpdCheck(t_i32 nAxis, t_i32 nIsEnable, t_i32 msInterval);
t_i32 mcCfgGetActSpdCheck(t_i32 nAxis, t_i32 *nIsEnable, t_i32 *msInterval);
t_i32 mcCfgSetActSpdFilter(t_i32 nAxis, t_i32 avrFilterNum);
t_i32 mcCfgGetActSpdFilter(t_i32 nAxis, t_i32 *avrFilterNum);

extern t_bool g_isFxOnForced;

void mcHCMPSyncCount(t_i32 nAxis);
void mcHCMPSyncCountAll(t_i32 nDevIdx);
void mcHCMPSetRefCount(t_i32 nAxis, t_i32 nCount);
t_i32 mcHCMPGetRefCount(t_i32 nAxis);
void mcHCMPResetFifo(t_i32 nAxis);
void mcHCMPResetFifoAll(t_i32 nDevIdx);
void mcHCMPSetIrqNum(t_i32 nAxis, t_i32 nIrqNum);
t_i32 mcHCMPGetIrqNum(t_i32 nAxis);
void mcHCMPSetPulseWidth(t_i32 nAxis, t_i32 nUs);
void mcHCMPSetPulseLogic(t_i32 nAxis, t_i32 nLogic);
void mcHCMPPushCmpPos(t_i32 nAxis, t_i32 nPos);
t_i32 mcHCMPGetNumData(t_i32 nAxis);
t_i32 mcHCMPCheckIrq(t_i32 nAxis);
t_i32 mcHCMPCheckIrqAll(t_i32 nDevIdx);
void mcHCMPSetOutEnable(t_i32 nAxis, t_i32 nEnable);
void mcHCMPSetEncEnable(t_i32 nAxis, t_i32 nEnable);
void mcHCMPSetEncMode(t_i32 nAxis, t_i32 nMode);
t_i32 mcHCMPGetOutEnable(t_i32 nAxis);
t_i32 mcHCMPGetEncEnable(t_i32 nAxis);
t_i32 mcHCMPIsFifoFull(t_i32 nAxis);

t_i32 memcHCMPPush(t_i32 nChan, t_i32 nInterval, t_i32 nNum);
t_i32 memcHCMPPush2(t_i32 nChan, t_i32 nStartPos, t_i32 nInterval, t_i32 nNum);
t_i32 memcHCMPGetOutCnt(t_i32 nAxis);
void pclTimerCallback();

#if (_PLATFORM==PLF_RTEX) //@@@@@@@@@@@@@@@@@ #1
extern TMotDevice g_aMotDev[NUM_MAX_MOTIONMODULE];
#endif

#endif
