﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ComiDll;
using System.Runtime.InteropServices;

namespace ADCcon
{
    public partial class Form1 : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;
        public bool g_bScanStart = false;
        public const int BufSize = 10240;
        public bool single1 = true;
        public const int CH_NUM = 8; // AD 스캔을 원하는 채널 개수

        double[] g_fData = new double[1024];

        public enum CHLIST
        {
            CH0, CH1, CH2, CH3, CH4, CH5, CH6, CH7
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.COMI_SD101, 0);

            if (g_hDevice == IntPtr.Zero) MessageBox.Show("Device SD101 로드 실패");
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            CDDLL.COMI_US_Stop(g_hDevice, 1);
            g_bScanStart = false;
        }

        private void EdtFreq_TextChanged(object sender, EventArgs e)
        {
            //if (EdtFreq.Text.Length==0)
            //{
            //    EdtFreq.Text = convert.100;
            //}
            //else if (EdtFreq.Text > 1000)
            //{
            //    EdtFreq.Text = "1000";
            //}
            //else if (EdtFreq.Text < 0)
            //{
            //    EdtFreq.Text = "100";
            //}
        }

        private void BtnStart_Click(object sender, EventArgs e)
        {
            int i;
            int ScanFreq = Convert.ToInt32(this.EdtFreq.Text);
            int nResult;

            int[] ChannelList = new int[CH_NUM];

            for (i = 0; i < CH_NUM; i++)
            {
                ChannelList[i] = i;
            }

            try
            {
                nResult = CDDLL.COMI_US_Start(g_hDevice, CH_NUM, ChannelList, ScanFreq, BufSize, (int)CDDLL.TCdAiScanTrs.cmTRS_BLOCK);

                if (nResult > 0) // nResult 는 적용된 scan freq 를 반환
                {
                    g_bScanStart = true;
                }
                else
                {
                    MessageBox.Show("Aiscan 이 정상적으로 수행되지 않음");
                }
            }
            catch
            {
                MessageBox.Show("Aiscanstart함수오류 발생");
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (!g_bScanStart) return;

#if false  // Single Point AD 방식 사용 시

            float fVal = 0.0f;

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                fVal = CDDLL.COMI_AD_GetVolt(g_hDevice, ch);

                if (ch == 0) txtCh0.Text = fVal.ToString();
                else if (ch == 1) txtCh1.Text = fVal.ToString();
                else if (ch == 2) txtCh2.Text = fVal.ToString();
                else if (ch == 3) txtCh3.Text = fVal.ToString();
                else if (ch == 4) txtCh4.Text = fVal.ToString();
                else if (ch == 5) txtCh5.Text = fVal.ToString();
                else if (ch == 6) txtCh6.Text = fVal.ToString();
                else if (ch == 7) txtCh7.Text = fVal.ToString();
            }
#else // Continuous (Unlimited scan 버퍼 사용 시)
            IntPtr repsPtr;

            CDDLL.ScanData scandata = new CDDLL.ScanData();
            scandata.fData = new float[1024];

            //repsPtr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            repsPtr = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            Marshal.StructureToPtr(scandata, repsPtr, false);

            for (int i = 0; i < 1024; i++)
                scandata.fData[i] = 0.0f;
            
            int nRetrvCount;

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                nRetrvCount = CDDLL.COMI_US_RetrvChannel(g_hDevice, ch, 0, 1024, repsPtr, (int)CDDLL.TCdVarType.VT_FLOAT);

                if (nRetrvCount > 0)
                {
                    CDDLL.ScanData reps = (CDDLL.ScanData)Marshal.PtrToStructure(repsPtr, typeof(CDDLL.ScanData));

                    // reps.fData 가 A/D 된 데이터 버퍼입니다.
                    float fMean = 0.0f;
                    float fSum = 0.0f;
                    for (int k = 0; k < 1024; k++)
                    {
                        fSum += reps.fData[k];
                    }
                    fMean = fSum / 1024; // 평균값임. 실제로는 노이즈 성분을 제외하기 위해 평균값이 아닌 중간값으로 계산해서 사용하세요.

                    if (ch == 0) txtCh0.Text = fMean.ToString();
                    else if (ch == 1) txtCh1.Text = fMean.ToString();
                    else if (ch == 2) txtCh2.Text = fMean.ToString();
                    else if (ch == 3) txtCh3.Text = fMean.ToString();
                    else if (ch == 4) txtCh4.Text = fMean.ToString();
                    else if (ch == 5) txtCh5.Text = fMean.ToString();
                    else if (ch == 6) txtCh6.Text = fMean.ToString();
                    else if (ch == 7) txtCh7.Text = fMean.ToString();
                }
            }

            //Marshal.FreeCoTaskMem(repsPtr);
            Marshal.FreeHGlobal(repsPtr);
#endif
        }

        private void CmbRange_SelectedIndexChanged(object sender, EventArgs e)
        {
            float Vmin = 0, Vmax = 0;
            switch (CmbRange.SelectedIndex)
            {
                case 0:
                    Vmin = -1;
                    Vmax = 1;
                    break;

                case 1:
                    Vmin = -2;
                    Vmax = 2;
                    break;

                case 2:
                    Vmin = -5;
                    Vmax = 5;
                    break;

                case 3:
                    Vmin = -10;
                    Vmax = 10;
                    break;
            }

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                CDDLL.COMI_AD_SetRange(g_hDevice, ch, Vmin, Vmax);
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }
    }
}
