// --------------------------------------------------------------
//            Copyright (C) 2000-2008 COMIZOA Co., LTD.          
// --------------------------------------------------------------

// DATE	: 2008-08-19
// TIME	: 16:24:17

unit Cmmsdk;

interface

uses
	Windows,
	Messages,
	SysUtils,
	Classes,
	Graphics,
	Controls,
	Forms,
	Dialogs;

const
//******************************************************************************
//* [ CmmsdkDef.h ]
//* Header file for definitions of constants and data in CMMSDK library
//* - Update Data: 2007/01/12
//* - Provider: COMIZOA Co., Ltd.
//* - Phone: +82-42-936-6500~6
//* - Fax  : +82-42-936-6507
//* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
//*******************************************************************************

	//*******************************************************************************

	// Device ID definition //

	COMI_SD401 = 	$B401;

	COMI_SD402 = 	$B402;

	COMI_SD403 = 	$B403;

	COMI_SD404 = 	$B404;

	COMI_SD414 = 	$B414;

	COMI_SD424 = 	$B424;

	COMI_LX501 = 	$A501;

	COMI_LX502 = 	$A502;

	COMI_LX504 = 	$A504;

	COMI_LX508 = 	$A508;

	COMI_LX534 = 	$A534;

	COMI_LX544 = 	$A544;

	COMI_LX504A = 	$A544;

	// Definition of maximum number of things //

	CMM_MAX_NUM_MOT_DEV = 	16;
	// Maximum number of Motion Devices in one PC 

	CMM_MAX_NUM_DIO_DEV = 	16;
	// Maximum number of Digital I/O Devices in one PC 

	CMM_MAX_NUM_AXES = 	64;
	// Maximum number of motion axes 

	CMM_MAX_DI_CH = 	512;
	// Maximum number of D/I channels 

	CMM_MAX_DO_CH = 	512;
	// Maximum number of D/O channels 

	CMM_MAX_STR_LEN_AXIS_TITLE = 	30;
	// Maximum string length of axis title 

	CMM_MAX_STR_LEN_DIST_UNIT = 	30;
	// Maximum string length of distance unit 

	CMM_MAX_STR_LEN_VEL_UNIT = 	30;
	// Maximum string length of velocity unit 

	CMM_MAX_STR_LEN_ERR = 	128;
	// Maximum error string length: a buffer to receive error string must be larger than this size.

	// Motion Chip Main-space Address //
	COMW =	0;
	OTPW =	1;
	BUF0 =	2;
	BUF1 =	3;
	MSTSW =	0;
	SSTSW =	1;

	// Motion Chip Registers //
	
	PRMV =	0;
	PRFL =	1;
	PRFH =	2;
	PRUR =	3;
	PRDR =	4;
	PRMG =	5;
	PRDP =	6;
	PRMD =	7;
	PRIP =	8;
	PRUS =	9;
	PRDS =	10;
	PRCP5 =	11;
	PRCI =	12;

	RMV = 	16;
	RFL =	17;
	RFH =	18;
	RUR =	19;
	RDR =	20;
	RMG =	21;
	RDP =	22;
	RMD =	23;
	RIP =	24;
	RUS =	25;
	RDS =	26;
	RFA =	27;
	RENV1 =	28;
	RENV2 =	29;
	RENV3 =	30;
	RENV4 =	31;
	RENV5 =	32;
	RENV6 =	33;
	RENV7 =	34;

	RCUN1 = 	35;
	RCUN2 =	36;
	RCUN3 =	37;
	RCUN4 =	38;
	RCMP1 =	39;
	RCMP2 =	40;
	RCMP3 =	41;
	RCMP4 =	42;
	RCMP5 =	43;
	RIRQ =	44;
	RLTC1 =	45;
	RLTC2 =	46;
	RLTC3 =	47;
	RLTC4 =	48;

	RSTS = 	49;
	REST =	50;
	RIST =	51;
	RPLS =	52;
	RSPD =	53;
	PSDC =	54;

	RCI = 	60;
	RCIC =	61;

	RIPS = 	63;
	

	//***********************************************************************************************

	//								CONSTATNS for User												*

	//***********************************************************************************************

	// Boolean type definition //
	 
	cmFALSE =	0;
	cmTRUE =	1;
	

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// MIO Property ID 

	// <TCmMioPropId>  <TCmMioPropIdEx>   MIO Property ID Ÿ Դϴ. <TCmMioPropIdEx>  

	// <TCmMioPropId>  ̸ ٲپ Դϴ.     ߿ ƹų ص ˴ϴ.
	
	cmALM_LOGIC =	0;
	cmALM_MODE =	1;
	cmCMP_LOGIC =	2;
	cmDR_LOGIC =	3;
	cmEL_LOGIC =	4;
	cmEL_MODE =	5;
	cmERC_LOGIC =	6;
	cmERC_OUT =	7;
	cmEZ_LOGIC =	8;
	cmINP_EN =	9;
	cmINP_LOGIC =	10;
	cmLTC_LOGIC =	11;
	cmLTC_LTC2SRC =	12;
	cmORG_LOGIC =	13;
	cmSD_EN =	14;
	cmSD_LOGIC =	15;
	cmSD_LATCH =	16;
	cmSD_MODE =	17;
	cmSTA_MODE =	18;
	cmSTA_TRG =	19;
	cmSTP_MODE =	20;
	cmCLR_CNTR =	21;
	cmCLR_SIGTYPE =	22;
	cmCMP_PWIDTH =	23;
	cmERC_ONTIME =	24;
	cmSVON_LOGIC =	25;
	cmERC_OUT_EL =	26;
	cmCNT_D_SRC =	27;
	cmCNT_G_SRC =	28;
	
	
	cmMPID_ALM_LOGIC =	0;
	cmMPID_ALM_MODE =	1;
	cmMPID_CMP_LOGIC =	2;
	cmMPID_DR_LOGIC =	3;
	cmMPID_EL_LOGIC =	4;
	cmMPID_EL_MODE =	5;
	cmMPID_ERC_LOGIC =	6;
	cmMPID_ERC_OUT =	7;
	cmMPID_EZ_LOGIC =	8;
	cmMPID_INP_EN =	9;
	cmMPID_INP_LOGIC =	10;
	cmMPID_LTC_LOGIC =	11;
	cmMPID_LTC_LTC2SRC =	12;
	cmMPID_ORG_LOGIC =	13;
	cmMPID_SD_EN =	14;
	cmMPID_SD_LOGIC =	15;
	cmMPID_SD_LATCH =	16;
	cmMPID_SD_MODE =	17;
	cmMPID_STA_MODE =	18;
	cmMPID_STA_TRG =	19;
	cmMPID_STP_MODE =	20;
	cmMPID_CLR_CNTR =	21;
	cmMPID_CLR_SIGTYPE =	22;
	cmMPID_CMP_PWIDTH =	23;
	cmMPID_ERC_ONTIME =	24;
	cmMPID_SVON_LOGIC =	25;
	cmMPID_ERC_OUT_EL =	26;
	cmMPID_CNT_D_SRC =	27;
	cmMPID_CNT_G_SRC =	28;
	

	// Bit order of StReadMioStatuses() return value  //
	
	cmIOST_RDY =	0;
	cmIOST_ALM =	1;
	cmIOST_ELP =	2;
	cmIOST_ELN =	3;
	cmIOST_ORG =	4;
	cmIOST_DIR =	5;
	cmIOST_RSV1 =	6;
	cmIOST_PCS =	7;
	cmIOST_ERC =	8;
	cmIOST_EZ =	9;
	cmIOST_CLR =	10;
	cmIOST_LTC =	11;
	cmIOST_SD =	12;
	cmIOST_INP =	13;
	cmIOST_DRP =	14;
	cmIOST_DRN =	15;
	cmIOST_STA =	16;
	cmIOST_STP =	17;
	

	// Motion operation status ID //
	 
	cmMST_STOP =	0;
	cmMST_WAIT_DR =	1;
	cmMST_WAIT_STA =	2;
	cmMST_WAIT_INSYNC =	3;
	cmMST_WAIT_OTHER =	4;
	cmMST_WAIT_ERC =	5;
	cmMST_WAIT_DIR =	6;
	cmMST_RESERVED1 =	7;
	cmMST_WAIT_PLSR =	8;
	cmMST_IN_RVSSPD =	9;
	cmMST_IN_INISPD =	10;
	cmMST_IN_ACC =	11;
	cmMST_IN_WORKSPD =	12;
	cmMST_IN_DEC =	13;
	cmMST_WAIT_INP =	14;
	cmMST_SPARE0 =	15;
	

	// Signal logic definition //
	 

	cmLOGIC_A = 	0;
	//Normal open 
	cmLOGIC_B = 	1;
	//Normal close 
	

	// Axis index definition //
	 
	cmX1 =	0;
	cmY1 =	1;
	cmZ1 =	2;
	cmU1 =	3;
	cmX2 =	4;
	cmY2 =	5;
	cmZ2 =	6;
	cmU2 =	7;
	

	// Definition for axes mask  //
	 

	cmX1_MASK = 	$1;
	cmY1_MASK = 	$2;
	cmZ1_MASK = 	$4;
	cmU1_MASK = 	$8;

	cmX2_MASK = 	$10;
	cmY2_MASK = 	$20;
	cmZ2_MASK = 	$40;
	cmU2_MASK = 	$80;
	

	// Encoder and PA/PB input mode definition //
	 
	cmIMODE_AB1X =	0;
	cmIMODE_AB2X =	1;
	cmIMODE_AB4X =	2;
	cmIMODE_CWCCW =	3;
	cmIMODE_STEP =	4;
	

	// Command output mode definition //
	 
	cmOMODE_PDIR0 =	0;
	cmOMODE_PDIR1 =	1;
	cmOMODE_PDIR2 =	2;
	cmOMODE_PDIR3 =	3;
	cmOMODE_CWCCW0 =	4;
	cmOMODE_CWCCW1 =	5;
	cmOMODE_CCWCW0 =	6;
	cmOMODE_CCWCW1 =	7;
	

	// Control Mode //
	 
	cmCTRL_OPEN =	0;
	// Open loop control mode 
	cmCTRL_SEMI_C =	1;
	// Semi-closed loop control mode (applied only to absolute in-position commands)
	cmCTRL_FULL_C =	2;
	// Full-closed loop control mode (this is not supported at current version)
	
	

	// (Linear)Operation direction //	
	
	cmDIR_N =	0;
	//(-)Dir 
	cmDIR_P =	1;
	//(+)Dir 
	

	// Counter name //
	 

	cmCNT_COMM =	0;
	//Command 
	cmCNT_FEED =	1;
	//Feedback 
	cmCNT_DEV =	2;
	//Deviation 

	cmCNT_GEN =	3;
	//General 
	cmCNT_REM =	4;
	//Remained 
	

	// Speed mode index definition //	
	 

	cmSMODE_KEEP = 	-1;
	// Keep previous setting 
	cmSMODE_C = 	0;
	//Constant  
	cmSMODE_T =	1;
	//Trapeziodal 
	cmSMODE_S =	2;
	//S-curve 
	

	// Arc operation direction //
	 
	cmARC_CW =	0;
	cmARC_CCW =	1;
	

	// Compare Method //
	
	cmDISABLE =	0;
	cmEQ_BIDIR =	1;
	cmEQ_PDIR =	2;
	cmEQ_NDIR =	3;
	cmLESS =	4;
	//Cnt<Data 
	cmGREATER =	5;
	//Cnt>Data 
	

	// Action when general comparator met the condition //
	
	cmEVNT_ONLY =	0;
	cmEVNT_IS =	1;
	cmEVNT_DS =	2;
	cmEVNT_SPDCHG =	3;
	

	// Backlash/Slip correction mode //
	
	cmCORR_DIS =	0;
	// Disable correction 
	cmCORR_BACK =	1;
	// Backlash correction mode 
	cmCORR_SLIP =	2;
	// Slip correction mode 
	
	
	cmEXOPT_SET_USE_PREREG =	0;
	

	// Interrupt Handler Type //
	

	cmIHT_MESSAGE = 	0;
	cmIHT_EVENT =	1;
	cmIHT_CALLBACK =	2;
	

	// Interrupt Handler Type //
	
	cmSTR_AXIS_NAME =	0;
	cmSTR_DIST_UNIT =	1;
	cmSTR_SPEED_UNIT =	2;
	

	// Sequence Mode //
	
	cmSEQM_SKIP_RUN =	0;
	cmSEQM_WAIT_RUN =	1;
	

	// Map Type //
	
	cmDMAP_MOTION =	0;
	cmDMAP_DIO =	1;
	cmDMAP_ALL =	2;
	

	// SetFilterAB  //
	
	cmAB_ENC =	0;
	cmAB_PULSAR =	1;
	

	// Axis Capability ID //
	

	cmCAPX_CMD_DIR = 	0;
	// Command direction change function  
	cmCAPX_EL_MAN_SET =	1;
	// -/+EL Manual control function  
	cmCAPX_CMP_HIGH =	2;
	// High-speed Compare Output function  
	
	
	cmHPCM_M0 =	0;
	// ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	cmHPCM_M1 =	1;
	// ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	cmHPCM_M2 =	2;
	// ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
	

	// Sync mode //
	
	cmSYNC_DISABLE =	0;
	cmSYNC_INT_SYNC =	1;
	cmSYNC_OTHER_STOP =	2;
	

	// Internal sync. conditions //
	
	cmISYNC_ACC_STA =	0;
	// 0: at start of acceleration 
	cmISYNC_ACC_END =	1;
	// 1: at end of acceleration 
	cmISYNC_DEC_STA =	2;
	// 2: at start of deceleration 
	cmISYNC_DEC_END =	3;
	// 3: at end of deceleration 
	cmISYNC_SLN =	4;
	// 4: when (-)software limit met 
	cmISYNC_SLP =	5;
	// 5: when (+)software limit met 
	cmISYNC_GCMP =	6;
	// 6: when General Comparator condition is satisfied 
	cmISYNC_TCMP =	7;
	// 7: when Trigger Comparator condition is satisfied 
	

	//***********************************************************************************************

	//								FUNCTION Prototype												*

	//***********************************************************************************************

	// Interrupt Handler Callback Function Prototype //

	// Informations of all actually installed motion devices //

	// Informations of motion devices defined by user //

	//------------------- DIO Device Informations -----------------------------------------------------------//

	// Informations of a DIO device //

	// Informations of all actually installed DIO devices //

	// Informations of DIO devices defined by user//

	//-------------------- MOTION CONFIGURATION ------------------------------------------------------------//

	//------------------------------------------------------------------------------------------------------//

	//--------------------------------- CME FILE STRUCTURE (ALL) --------------------------------------------//

	//***********************************************************************************************

	//									ERROR CODE DEFINITIONs										*

	//***********************************************************************************************

	cmERR_NONE = 	0;

	cmERR_MEM_ALLOC_FAIL = 	-290;	
	// Memory allocation fail 

	cmERR_GLOBAL_MEM_FAIL = 	-292;	
	// Global memory allocation fail 

	cmERR_ISR_CONNEC_FAIL = 	-310;	
	// ISR registration fail 

	cmERR_DIVIDE_BY_ZERO = 	-400;	
	// Cause divide by zero error 

	cmERR_WORNG_NUM_DATA = 	-500;	
	// Number of data is too small or too big 

	cmERR_VER_MISMATCH = 	-600;	
	// Version(of file or device) mismatch 

	cmERR_INVALID_DEVICE_ID = 	-1010;
	// Invalid device id => Load Device Ǵ SetDeviceId()...

	cmERR_INVALID_HANDLE = 	-1020;

	cmERR_UNSUPORTED_FUNC = 	-1030;

	cmERR_INVALID_PARAMETER = 	-1101;

	cmERR_INVALID_CHANNEL = 	-1105;

	cmERR_INVALID_INPUT_RANGE = 	-1111;
	// Invalid range value (AI, AO)

	cmERR_INVALID_FREQ_RANGE = 	-1121;
	// Invalid input or output frequency 

	cmERR_FILE_CREATE_FAIL = 	-1501;
	// File create fail 

	cmERR_FILE_OPEN_FAIL = 	-1511;
	// File open fail 

	cmERR_FILE_READ_FAIL = 	-1522;
	// File reading fail 

	cmERR_EVENT_CREATE_FAIL = 	-1550;
	// Event handle creation fail 

	cmERR_INT_INSTANCE_FAIL = 	-1560;
	// Interrupt event instance creation fail 

	cmERR_DITHREAD_CRE = 	-1570;
	// D/I state change monitor thread creation fail 

	cmERR_BUFFER_SMALL = 	-1580;
	// Buffer size is too small 

	cmERR_HIGH_TIMER_UNSUPP = 	-1590;
	// The installed hardware does not support a high-resolution performance counter (cmmUtlDelayMicroSec() function fails)

	cmERR_OUT_OF_RANGE = 	-1600;
	// The range of some parameter is out of range 

	cmERR_ON_MOTION = 	-5001;

	cmERR_STOP_BY_SLP = 	-5002;
	// Abnormally stopped by positive soft limit 

	cmERR_STOP_BY_SLN = 	-5003;
	// Abnormally stopped by negative soft limit 

	cmERR_STOP_BY_CMP3 = 	-5004;
	// Abnormally stopped by comparator3 

	cmERR_STOP_BY_CMP4 = 	-5005;
	// Abnormally stopped by comparator4 

	cmERR_STOP_BY_CMP5 = 	-5006;
	// Abnormally stopped by comparator5 

	cmERR_STOP_BY_ELP = 	-5007;
	// Abnormally stopped by (+) external limit 

	cmERR_STOP_BY_ELN = 	-5008;
	// Abnormally stopped by (-) external limit 

	cmERR_STOP_BY_ALM = 	-5009;
	// Abnormally stopped by alarm input signal 

	cmERR_STOP_BY_CSTP = 	-5010;
	// Abnormally stopped by CSTP input signal 

	cmERR_STOP_BY_CEMG = 	-5011;
	// Abnormally stopped by CEMG input signal 

	cmERR_STOP_BY_SD = 	-5012;
	// Abnormally stopped by SD input signal 

	cmERR_STOP_BY_DERROR = 	-5013;
	// Abnormally stopped by operation data error 

	cmERR_STOP_BY_IP = 	-5014;
	// Abnormally stopped by other axis error during interpolation 

	cmERR_STOP_BY_PO = 	-5015;
	// An overflow occurred in the PA/PB input buffer 

	cmERR_STOP_BY_AO = 	-5016;
	// Out of range position counter during interpolation 

	cmERR_STOP_BY_EE = 	-5017;
	// An EA/EB input error occurred (does not stop)

	cmERR_STOP_BY_PE = 	-5018;
	// An PA/PB input error occurred (does not stop)

	cmERR_STOP_BY_SLVERR = 	-5019;
	// Abnormally stopped because slave axis has been stopped 

	cmERR_STOP_BY_SEMG = 	-5020;
	// Abnormally stopped by software emergency setting 

	cmERR_MOT_MAOMODE = 	-5110;
	// Master output mode is not CW/CCW mode // Master/Slave ۽ÿ Master output尡 CW/CCW尡 ƴϴ.

	cmERR_MOT_SLAVE_SET = 	-5120;
	// Slave start fail (Motion state "Wait for Pulsar Input"  ʴ´.

	cmERR_SPEED_RANGE_OVER = 	-5130;

	cmERR_INVALID_SPEED_SET = 	-5140;
	// Speed setting value is not valid 

	cmERR_INVALID_IXMAP = 	-5150;
	// Invalid interpolation map 

	cmERR_INVALID_LMMAP = 	-5160;
	// Invalid List-Motion Map 

	cmERR_MOT_SEQ_SKIPPED = 	-5170;
	// Motion command is skipped because the axis is already running.

	cmERR_CMPIX_INVALID_MAP = 	-5180;
	// Interpolated position compare output map is not valid 

	cmERR_INVALID_ARC_POS = 	-5190;
	// Arc-interpolation position data is invalid 

	cmERR_UNKNOWN = 	-9999;

type
// * [ Cmmsdk.h ]
// * Header file for API fuctions in CMMSDK library
// * - Update Data: 2008/04/21
// * - Provider: COMIZOA Co., Ltd.
// * - Phone: +82-42-936-6500~6
// * - Fax  : +82-42-936-6507
// * - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
	//*******************************************************************************************************
	//								API FUNCTIONS                                                           *
	//*******************************************************************************************************
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// SetBit() :   Ư Ʈ  Ѵ. ũ̹Ƿ Լ ȣ  ʵʿ !
	// v: , n:bitȣ, s:氪(state)
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// GetBit() :   Ư Ʈ  ȯѴ. ũ̹Ƿ Լ ȣ  ʵʿ !
	// v: , n:bitȣ
	//====================== DLL LOAD/UNLOAD FUNCTIONS ============================================//
	//====================== General FUNCTIONS ====================================================//
	TCMM_Gn_DeviceLoad	= function (IsResetDevice : LongInt; NumAxes : PLongInt) : LongInt; stdcall;
	TCMM_Gn_DeviceUnload	= function () : LongInt; stdcall;
	TCMM_Gn_DeviceIsLoaded	= function (IsLoaded : PLongInt) : LongInt; stdcall;
	TCMM_Gn_DeviceReset	= function () : LongInt; stdcall;
	TCMM_Gn_InitFromFile	= function (szCmeFile : PChar) : LongInt; stdcall;
	TCMM_Gn_InitFromFile_MapOnly	= function (szCmeFile : PChar; MapType : LongInt) : LongInt; stdcall;
	TCMM_Gn_SetServoOn	= function (Axis : LongInt; Enable : LongInt) : LongInt; stdcall;
	TCMM_Gn_GetServoOn	= function (Axis : LongInt; Enable : PLongInt) : LongInt; stdcall;
	TCMM_Gn_SetAlarmRes	= function (Channel : LongInt; IsOn : LongInt) : LongInt; stdcall;
	TCMM_Gn_GetAlarmRes	= function (Channel : LongInt; IsOn : PLongInt) : LongInt; stdcall;
	TCMM_Gn_PulseAlarmRes	= function (Channel : LongInt; IsOnPulse : LongInt; dwDuration : LongInt; IsWaitPulseEnd : LongInt) : LongInt; stdcall;
	TCMM_Gn_SetSimulMode	= function (Axis : LongInt; IsSimulMode : LongInt) : LongInt; stdcall;
	TCMM_Gn_GetSimulMode	= function (Axis : LongInt; IsSimulMode : PLongInt) : LongInt; stdcall;
	TCMM_Gn_PutInternalSTA	= function (AxesMask : LongInt) : LongInt; stdcall;
	TCMM_Gn_SetEmergency	= function (IsEnable : LongInt; IsDecStop : LongInt) : LongInt; stdcall;
	TCMM_Gn_GetEmergency	= function (IsEnabled : PLongInt) : LongInt; stdcall;
	TCMM_Gn_BitShift	= function (Value : LongInt; ShiftOption : LongInt; Result : PLongInt) : LongInt; stdcall;
	//====================== Configuration FUNCTIONS ==============================================//
	TCMM_Cfg_SetMioProperty	= function (Axis : LongInt; PropId : LongInt; PropVal : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetMioProperty	= function (Axis : LongInt; PropId : LongInt; PropVal : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetFilter	= function (Axis : LongInt; IsEnable : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetFilter	= function (Axis : LongInt; IsEnabled : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetFilterAB	= function (Channel : LongInt; Target : LongInt; IsEnable : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetFilterAB	= function (Channel : LongInt; Target : LongInt; IsEnabled : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetInMode	= function (Axis : LongInt; InputMode : LongInt; IsReverse : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetInMode	= function (Axis : LongInt; InputMode : PLongInt; IsReverse : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetOutMode	= function (Axis : LongInt; OutputMode : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetOutMode	= function (Axis : LongInt; OutputMode : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetCtrlMode	= function (Axis : LongInt; CtrlMode : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetCtrlMode	= function (Axis : LongInt; CtrlMode : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetInOutRatio	= function (Axis : LongInt; Ratio : Double) : LongInt; stdcall;
	TCMM_Cfg_GetInOutRatio	= function (Axis : LongInt; Ratio : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetUnitDist	= function (Axis : LongInt; UnitDist : Double) : LongInt; stdcall;
	TCMM_Cfg_GetUnitDist	= function (Axis : LongInt; UnitDist : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetUnitSpeed	= function (Axis : LongInt; UnitSpeed : Double) : LongInt; stdcall;
	TCMM_Cfg_GetUnitSpeed	= function (Axis : LongInt; UnitSpeed : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetSpeedRange	= function (Axis : LongInt; MaxPPS : Double) : LongInt; stdcall;
	TCMM_Cfg_GetSpeedRange	= function (Axis : LongInt; MinPPS : PDouble; MaxPPS : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetSpeedPattern	= function (Axis : LongInt; SpeedMode : LongInt; WorkSpeed : Double; Accel : Double; Decel : Double) : LongInt; stdcall;
	TCMM_Cfg_GetSpeedPattern	= function (Axis : LongInt; SpeedMode : PLongInt; WorkSpeed : PDouble; Accel : PDouble; Decel : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetActSpdCheck	= function (IsEnable : LongInt; Interval : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetActSpdCheck	= function (IsEnable : PLongInt; Interval : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetSoftLimit	= function (Axis : LongInt; IsEnable : LongInt; LimitN : Double; LimitP : Double) : LongInt; stdcall;
	TCMM_Cfg_GetSoftLimit	= function (Axis : LongInt; IsEnable : PLongInt; LimitN : PDouble; LimitP : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetRingCntr	= function (Channel : LongInt; TargCntr : LongInt; IsEnable : LongInt; CntMax : Double) : LongInt; stdcall;
	TCMM_Cfg_GetRingCntr	= function (Channel : LongInt; TargCntr : LongInt; IsEnable : PLongInt; CntMax : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetVelCorrRatio	= function (Axis : LongInt; fCorrRatio : Double) : LongInt; stdcall;
	TCMM_Cfg_GetVelCorrRatio	= function (Channel : LongInt; fCorrRatio : PDouble) : LongInt; stdcall;
	TCMM_Cfg_SetSeqMode	= function (SeqMode : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetSeqMode	= function (SeqMode : PLongInt) : LongInt; stdcall;
	TCMM_Cfg_SetManExtLimit	= function (Channel : LongInt; IsSetELP : LongInt; IsEnable : LongInt; ManState : LongInt) : LongInt; stdcall;
	TCMM_Cfg_GetManExtLimit	= function (Channel : LongInt; IsGetELP : LongInt; IsEnable : PLongInt; ManState : PLongInt) : LongInt; stdcall;
	//====================== HOME-RETURN FUNCTIONS ================================================//
	TCMM_Home_SetConfig	= function (Axis : LongInt; HomeMode : LongInt; EzCount : LongInt; EscDist : Double; Offset : Double) : LongInt; stdcall;
	TCMM_Home_GetConfig	= function (Axis : LongInt; HomeMode : PLongInt; EzCount : PLongInt; EscDist : PDouble; Offset : PDouble) : LongInt; stdcall;
	TCMM_Home_SetPosClrMode	= function (Axis : LongInt; PosClrMode : LongInt) : LongInt; stdcall;
	TCMM_Home_GetPosClrMode	= function (Axis : LongInt; PosClrMode : PLongInt) : LongInt; stdcall;
	TCMM_Home_SetSpeedPattern	= function (Axis : LongInt; SpeedMode : LongInt; Vel : Double; Accel : Double; Decel : Double; RevVel : Double) : LongInt; stdcall;
	TCMM_Home_GetSpeedPattern	= function (Axis : LongInt; SpeedMode : PLongInt; Vel : PDouble; Accel : PDouble; Decel : PDouble; RevVel : PDouble) : LongInt; stdcall;
	TCMM_Home_MoveStart	= function (Axis : LongInt; Direction : LongInt) : LongInt; stdcall;
	TCMM_Home_Move	= function (Axis : LongInt; Direction : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Home_MoveAll	= function (NumAxes : LongInt; AxisList : PLongInt; DirList : PLongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Home_MoveAllStart	= function (NumAxes : LongInt; AxisList : PLongInt; DirList : PLongInt) : LongInt; stdcall;
	TCMM_Home_GetSuccess	= function (Axis : LongInt; IsSuccess : PLongInt) : LongInt; stdcall;
	TCMM_Home_SetSuccess	= function (Axis : LongInt; IsSuccess : LongInt) : LongInt; stdcall;
	TCMM_Home_IsBusy	= function (Axis : LongInt; IsBusy : PLongInt) : LongInt; stdcall;
	TCMM_Home_WaitDone	= function (Axis : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	//====================== Single Axis Move FUNCTIONS ===========================================//
	TCMM_Sx_SetSpeedRatio	= function (Axis : LongInt; SpeedMode : LongInt; VelRatio : Double; AccRatio : Double; DecRatio : Double) : LongInt; stdcall;
	TCMM_Sx_GetSpeedRatio	= function (Axis : LongInt; SpeedMode : PLongInt; VelRatio : PDouble; AccRatio : PDouble; DecRatio : PDouble) : LongInt; stdcall;
	TCMM_Sx_MoveStart	= function (Axis : LongInt; Distance : Double) : LongInt; stdcall;
	TCMM_Sx_Move	= function (Axis : LongInt; Distance : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Sx_MoveToStart	= function (Axis : LongInt; Position : Double) : LongInt; stdcall;
	TCMM_Sx_MoveTo	= function (Axis : LongInt; Position : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Sx_VMoveStart	= function (Axis : LongInt; Dir : LongInt) : LongInt; stdcall;
	TCMM_Sx_Stop	= function (Axis : LongInt; IsWaitComplete : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Sx_StopEmg	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Sx_IsDone	= function (Axis : LongInt; IsDone : PLongInt) : LongInt; stdcall;
	TCMM_Sx_WaitDone	= function (Axis : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Sx_GetTargetPos	= function (Channel : LongInt; Position : PDouble) : LongInt; stdcall;
	TCMM_Sx_OptSetIniSpeed	= function (Axis : LongInt; IniSpeed : Double) : LongInt; stdcall;
	TCMM_Sx_OptGetIniSpeed	= function (Axis : LongInt; IniSpeed : PDouble) : LongInt; stdcall;
	TCMM_Sx_SetCorrection	= function (Axis : LongInt; CorrMode : LongInt; CorrAmount : Double; CorrVel : Double; CntrMask : LongInt) : LongInt; stdcall;
	TCMM_Sx_GetCorrection	= function (Axis : LongInt; CorrMode : PLongInt; CorrAmount : PDouble; CorrVel : PDouble; CntrMask : PLongInt) : LongInt; stdcall;
	TCMM_Sx_OptSetSyncMode	= function (Axis : LongInt; Mode : LongInt; RefAxis : LongInt; Condition : LongInt) : LongInt; stdcall;
	TCMM_Sx_OptGetSyncMode	= function (Axis : LongInt; Mode : PLongInt; RefAxis : PLongInt; Condition : PLongInt) : LongInt; stdcall;
	TCMM_Sx_OptSetSyncOut	= function (Axis : LongInt; Mode : LongInt; DoChan_local : LongInt; DoLogic : LongInt) : LongInt; stdcall;
	TCMM_Sx_OptGetSyncOut	= function (Axis : LongInt; Mode : PLongInt; DoChan_local : PLongInt; DoLogic : PLongInt) : LongInt; stdcall;
	TCMM_Sx_OptSetRdpOffset	= function (Axis : LongInt; OffsetDist : Double) : LongInt; stdcall;
	TCMM_Sx_OptGetRdpOffset	= function (Axis : LongInt; OffsetDist : PDouble) : LongInt; stdcall;
	//====================== Multiple Axes Move FUNCTIONS =========================================//
	TCMM_Mx_Move	= function (NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Mx_VMoveStart	= function (NumAxes : LongInt; AxisList : PLongInt; DirList : PLongInt) : LongInt; stdcall;
	TCMM_Mx_MoveStart	= function (NumAxes : LongInt; AxisList : PLongInt; DistList : PDouble) : LongInt; stdcall;
	TCMM_Mx_MoveTo	= function (NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Mx_MoveToStart	= function (NumAxes : LongInt; AxisList : PLongInt; PosList : PDouble) : LongInt; stdcall;
	TCMM_Mx_Stop	= function (NumAxes : LongInt; AxisList : PLongInt; IsWaitComplete : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Mx_StopEmg	= function (NumAxes : LongInt; AxisList : PLongInt) : LongInt; stdcall;
	TCMM_Mx_IsDone	= function (NumAxes : LongInt; AxisList : PLongInt; IsDone : PLongInt) : LongInt; stdcall;
	TCMM_Mx_WaitDone	= function (NumAxes : LongInt; AxisList : PLongInt; IsBlocking : LongInt) : LongInt; stdcall;
	//====================== Interpolation Move FUNCTIONS =========================================//
	TCMM_Ix_MapAxes	= function (MapIndex : LongInt; MapMask1 : LongInt; MapMask2 : LongInt) : LongInt; stdcall;
	TCMM_Ix_SetSpeedPattern	= function (MapIndex : LongInt; IsVectorSpeed : LongInt; SpeedMode : LongInt; Vel : Double; Acc : Double; Dec : Double) : LongInt; stdcall;
	TCMM_Ix_GetSpeedPattern	= function (MapIndex : LongInt; IsVectorSpeed : PLongInt; SpeedMode : PLongInt; Vel : PDouble; Acc : PDouble; Dec : PDouble) : LongInt; stdcall;
	TCMM_Ix_Line	= function (MapIndex : LongInt; DistList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_LineStart	= function (MapIndex : LongInt; DistList : PDouble) : LongInt; stdcall;
	TCMM_Ix_LineTo	= function (MapIndex : LongInt; PosList : PDouble; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_LineToStart	= function (MapIndex : LongInt; PosList : PDouble) : LongInt; stdcall;
	TCMM_Ix_ArcA	= function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_ArcAStart	= function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; EndAngle : Double) : LongInt; stdcall;
	TCMM_Ix_ArcATo	= function (MapIndex : LongInt; XCent : Double; YCent : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_ArcAToStart	= function (MapIndex : LongInt; XCent : Double; YCent : Double; EndAngle : Double) : LongInt; stdcall;
	TCMM_Ix_ArcP	= function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_ArcPStart	= function (MapIndex : LongInt; XCentOffset : Double; YCentOffset : Double; XEndPointDist : Double; YEndPointDist : Double; Direction : LongInt) : LongInt; stdcall;
	TCMM_Ix_ArcPTo	= function (MapIndex : LongInt; XCent : Double; YCent : Double; XEndPos : Double; YEndPos : Double; Direction : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_ArcPToStart	= function (MapIndex : LongInt; XCent : Double; YCent : Double; XEndPos : Double; YEndPos : Double; Direction : LongInt) : LongInt; stdcall;
	TCMM_Ix_Arc3PStart	= function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double) : LongInt; stdcall;
	TCMM_Ix_Arc3P	= function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_Arc3PToStart	= function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double) : LongInt; stdcall;
	TCMM_Ix_Arc3PTo	= function (MapIndex : LongInt; P2X : Double; P2Y : Double; P3X : Double; P3Y : Double; EndAngle : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_IsDone	= function (MapIndex : LongInt; IsDone : PLongInt) : LongInt; stdcall;
	TCMM_Ix_WaitDone	= function (MapIndex : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_Stop	= function (MapIndex : LongInt; IsWaitComplete : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ix_StopEmg	= function (MapIndex : LongInt) : LongInt; stdcall;
	TCMM_Ixx_HelOnceSetSpeed	= function (HelId : LongInt; Master : LongInt; SpeedMode : LongInt; WorkSpeed : Double; Acc : Double; Dec : Double) : LongInt; stdcall;
	TCMM_Ixx_HelOnceGetSpeed	= function (HelId : LongInt; SpeedMaster : PLongInt; SpeedMode : PLongInt; WorkSpeed : PDouble; Acc : PDouble; Dec : PDouble) : LongInt; stdcall;
	TCMM_Ixx_HelOnce	= function (HelId : LongInt; NumAxes : LongInt; AxisList : PLongInt; CoordList : PDouble; ArcAngle : Double; DistU : PDouble; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Ixx_HelOnceStart	= function (HelId : LongInt; NumAxes : LongInt; AxisList : PLongInt; CoordList : PDouble; ArcAngle : Double; DistU : PDouble) : LongInt; stdcall;
	TCMM_Ixx_SplineBuild	= function (InArray : PDouble; NumInArray : LongInt; OutArray : PDouble; NumOutArray : LongInt) : LongInt; stdcall;
	//====================== External Switch Move FUNCTIONS =======================================//
	TCMM_Ex_VMoveStart	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Ex_MoveStart	= function (Axis : LongInt; Distance : Double) : LongInt; stdcall;
	TCMM_Ex_MoveToStart	= function (Axis : LongInt; Position : Double) : LongInt; stdcall;
	//====================== Manual Pulsar FUNCTIONS ==============================================//
	TCMM_Plsr_SetInMode	= function (Axis : LongInt; InputMode : LongInt; IsInverse : LongInt) : LongInt; stdcall;
	TCMM_Plsr_GetInMode	= function (Axis : LongInt; InputMode : PLongInt; IsInverse : PLongInt) : LongInt; stdcall;
	TCMM_Plsr_SetGain	= function (Axis : LongInt; GainFactor : LongInt; DivFactor : LongInt) : LongInt; stdcall;
	TCMM_Plsr_GetGain	= function (Axis : LongInt; GainFactor : PLongInt; DivFactor : PLongInt) : LongInt; stdcall;
	TCMM_Plsr_HomeMoveStart	= function (Axis : LongInt; HomeType : LongInt) : LongInt; stdcall;
	TCMM_Plsr_MoveStart	= function (Axis : LongInt; Distance : Double) : LongInt; stdcall;
	TCMM_Plsr_Move	= function (Axis : LongInt; Distance : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Plsr_MoveToStart	= function (Axis : LongInt; Position : Double) : LongInt; stdcall;
	TCMM_Plsr_MoveTo	= function (Axis : LongInt; Position : Double; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Plsr_VMoveStart	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Plsr_IsActive	= function (Channel : LongInt; IsActive : PLongInt) : LongInt; stdcall;
	//====================== MASTER/SLAVE FUNCTIONS ===============================================//
	TCMM_Ms_RegisterSlave	= function (Axis : LongInt; MaxSpeed : Double; IsInverse : LongInt) : LongInt; stdcall;
	TCMM_Ms_UnregisterSlave	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Ms_CheckSlaveState	= function (SlaveAxis : LongInt; SlaveState : PLongInt) : LongInt; stdcall;
	TCMM_Ms_GetMasterAxis	= function (SlaveAxis : LongInt; MasterAxis : PLongInt) : LongInt; stdcall;
	//====================== Overriding FUNCTIONS =================================================//
	TCMM_Override_SpeedSet	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Override_SpeedSetAll	= function (NumAxes : LongInt; AxisList : PLongInt) : LongInt; stdcall;
	TCMM_Override_Move	= function (Axis : LongInt; NewDistance : Double; IsIgnored : PLongInt) : LongInt; stdcall;
	TCMM_Override_MoveTo	= function (Axis : LongInt; NewPosition : Double; IsIgnored : PLongInt) : LongInt; stdcall;
	//====================== LIST-MOTION FUNCTIONS ================================================//
	TCMM_Lm_MapAxes	= function (LmIndex : LongInt; MapMask1 : LongInt; MapMask2 : LongInt) : LongInt; stdcall;
	TCMM_Lm_BeginList	= function (LmIndex : LongInt) : LongInt; stdcall;
	TCMM_Lm_EndList	= function (LmIndex : LongInt) : LongInt; stdcall;
	TCMM_Lm_StartMotion	= function (LmIndex : LongInt) : LongInt; stdcall;
	TCMM_Lm_AbortMotion	= function (LmIndex : LongInt) : LongInt; stdcall;
	TCMM_Lm_IsDone	= function (LmIndex : LongInt; IsDone : PLongInt) : LongInt; stdcall;
	TCMM_Lm_WaitDone	= function (LmIndex : LongInt; IsBlocking : LongInt) : LongInt; stdcall;
	TCMM_Lm_CurSequence	= function (LmIndex : LongInt; SeqIndex : PLongInt) : LongInt; stdcall;
	TCMM_Lm_ImmediacySet	= function (LmIndex : LongInt) : LongInt; stdcall;
	TCMM_Lm_DoPutOne	= function (LmIndex : LongInt; hDoDevice : THandle; Channel : LongInt; OutState : LongInt) : LongInt; stdcall;
	TCMM_Lm_DoPutMulti	= function (LmIndex : LongInt; hDoDevice : THandle; ChannelGroup : LongInt; Mask : LongInt; OutStates : LongInt) : LongInt; stdcall;
	TCMM_Lm_DoPulseOne	= function (LmIndex : LongInt; hDoDevice : THandle; Channel : LongInt; OutState : LongInt; Duration : LongInt) : LongInt; stdcall;
	TCMM_Lm_DoPulseMulti	= function (LmIndex : LongInt; hDoDevice : THandle; ChannelGroup : LongInt; Mask : LongInt; OutStates : LongInt; Duration : LongInt) : LongInt; stdcall;
	//====================== ° FUNCTIONS ===================================================//
	TCMM_St_SetCount	= function (Axis : LongInt; Target : LongInt; Count : LongInt) : LongInt; stdcall;
	TCMM_St_GetCount	= function (Axis : LongInt; Source : LongInt; Count : PLongInt) : LongInt; stdcall;
	TCMM_St_SetPosition	= function (Axis : LongInt; Target : LongInt; Position : Double) : LongInt; stdcall;
	TCMM_St_GetPosition	= function (Axis : LongInt; Source : LongInt; Position : PDouble) : LongInt; stdcall;
	TCMM_St_GetSpeed	= function (Axis : LongInt; Source : LongInt; Speed : PDouble) : LongInt; stdcall;
	TCMM_St_ReadMotionState	= function (Axis : LongInt; MotStates : PLongInt) : LongInt; stdcall;
	TCMM_St_ReadMioStatuses	= function (Axis : LongInt; MioStates : PLongInt) : LongInt; stdcall;
	TCMM_St_GetMstString	= function (MstCode : LongInt; Buffer : PChar; BufferLen : LongInt) : LongInt; stdcall;
	//====================== INTERRUPT FUNCTIONS ==================================================//
	TCMM_Int_SetMask	= function (Axis : LongInt; Mask : LongInt) : LongInt; stdcall;
	TCMM_Int_GetMask	= function (Axis : LongInt; Mask : PLongInt) : LongInt; stdcall;
	TCMM_INTERRUPT_CALLBACK = procedure (lParam : THandle); stdcall;
	TCMM_Int_HandlerSetup	= function (HandlerType : LongInt; Handler : TCMM_INTERRUPT_CALLBACK; nMessage : LongInt; lParam : THandle) : LongInt; stdcall;
	TCMM_Int_HandlerEnable	= function (IsEnable : LongInt) : LongInt; stdcall;
	TCMM_Int_ReadFlag	= function (IntFlag1 : PLongInt; IntFlag2 : PLongInt) : LongInt; stdcall;
	TCMM_Int_ReadErrorStatus	= function (Axis : LongInt; ErrState : PLongInt) : LongInt; stdcall;
	TCMM_Int_ReadEventStatus	= function (Axis : LongInt; EventState : PLongInt) : LongInt; stdcall;
	//====================== LATCH FUNCTIONS =======================================================//
	TCMM_Ltc_IsLatched	= function (Axis : LongInt; IsLatched : PLongInt) : LongInt; stdcall;
	TCMM_Ltc_ReadLatch	= function (Axis : LongInt; Counter : LongInt; LatchedPos : PDouble) : LongInt; stdcall;
	//====================== Position Compare FUNCTIONS ===========================================//
	TCMM_Cmp_ErrSetConfig	= function (Axis : LongInt; Tolerance : Double; IsEnable : LongInt) : LongInt; stdcall;
	TCMM_Cmp_ErrGetConfig	= function (Axis : LongInt; Tolerance : PDouble; IsEnabled : PLongInt) : LongInt; stdcall;
	TCMM_Cmp_GenSetConfig	= function (Axis : LongInt; CmpSrc : LongInt; CmpMethod : LongInt; CmpAction : LongInt; CmpData : Double) : LongInt; stdcall;
	TCMM_Cmp_GenGetConfig	= function (Axis : LongInt; CmpSrc : PLongInt; CmpMethod : PLongInt; CmpAction : PLongInt; CmpData : PLongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgSetConfig	= function (Axis : LongInt; CmpSrc : LongInt; CmpMethod : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgGetConfig	= function (Axis : LongInt; CmpSrc : PLongInt; CmpMethod : PLongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgSetOneData	= function (Axis : LongInt; Data : Double) : LongInt; stdcall;
	TCMM_Cmp_TrgGetCurData	= function (Axis : LongInt; Data : PDouble) : LongInt; stdcall;
	TCMM_Cmp_TrgContRegTable	= function (Axis : LongInt; Buffer : PDouble; NumData : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgContBuildTable	= function (Axis : LongInt; StartData : Double; Interval : Double; NumData : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgContStart	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgContStop	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgContIsActive	= function (Channel : LongInt; IsActive : PLongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgHigh_WriteData	= function (Channel : LongInt; CMPH_No : LongInt; IniPos : Double; Interval : Double) : LongInt; stdcall;
	TCMM_Cmp_TrgHigh_ReadData	= function (Channel : LongInt; CMPH_No : PLongInt; IniPos : PDouble; Interval : PDouble) : LongInt; stdcall;
	TCMM_Cmp_TrgHigh_Start	= function (Channel : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgHigh_Stop	= function (Channel : LongInt) : LongInt; stdcall;
	TCMM_Cmp_TrgHigh_Check	= function (Channel : LongInt; IsActive : PLongInt; OutCount : PLongInt) : LongInt; stdcall;
// CMM_EXTERN long	(WINAPI *cmmCmpTrgIx_SetMap)	(long MapIdx, long Axis_X, long Axis_Y, long DoChan);
// CMM_EXTERN long	(WINAPI *cmmCmpTrgIx_GetMap)	(long MapIdx, long *Axis_X, long *Axis_Y, long *DoChan, long *IsValid);
// CMM_EXTERN long	(WINAPI *cmmCmpTrgIx_Start) 	(long MapIdx, double PosArray_X[], double PosArray_Y[], long SrcSelArray[], long ArraySize);
// CMM_EXTERN long	(WINAPI *cmmCmpTrgIx_Stop)  	(long MapIdx);
// CMM_EXTERN long	(WINAPI *cmmCmpTrgIx_GetState)	(long MapIdx, long *CmpOutCnt, long *IsActive);
	//====================== Digital In/Out FUNCTIONS =============================================//
	TCMM_Di_SetInputLogic	= function (Channel : LongInt; InputLogic : LongInt) : LongInt; stdcall;
	TCMM_Di_GetInputLogic	= function (Channel : LongInt; InputLogic : PLongInt) : LongInt; stdcall;
	TCMM_Di_GetOne	= function (Channel : LongInt; InputState : PLongInt) : LongInt; stdcall;
	TCMM_Di_GetMulti	= function (IniChannel : LongInt; NumChannels : LongInt; InputStates : PLongInt) : LongInt; stdcall;
	TCMM_Di_GetOneF	= function (Channel : LongInt; CutoffTime_us : LongInt; InputState : PLongInt) : LongInt; stdcall;
	TCMM_Di_GetMultiF	= function (IniChannel : LongInt; NumChannels : LongInt; CutoffTime_us : LongInt; InputStates : PLongInt) : LongInt; stdcall;
	TCMM_Do_SetOutputLogic	= function (Channel : LongInt; OutputLogic : LongInt) : LongInt; stdcall;
	TCMM_Do_GetOutputLogic	= function (Channel : LongInt; OutputLogic : PLongInt) : LongInt; stdcall;
	TCMM_Do_PutOne	= function (Channel : LongInt; OutState : LongInt) : LongInt; stdcall;
	TCMM_Do_GetOne	= function (Channel : LongInt; OutState : PLongInt) : LongInt; stdcall;
	TCMM_Do_PulseOne	= function (Channel : LongInt; IsOnPulse : LongInt; dwDuration : LongInt; IsWaitPulseEnd : LongInt) : LongInt; stdcall;
	TCMM_Do_PutMulti	= function (IniChannel : LongInt; NumChannels : LongInt; OutStates : LongInt) : LongInt; stdcall;
	TCMM_Do_GetMulti	= function (IniChannel : LongInt; NumChannels : LongInt; InputStates : PLongInt) : LongInt; stdcall;
	TCMM_Do_PulseMulti	= function (IniChannel : LongInt; NumChannels : LongInt; OutStates : LongInt; dwDuration : LongInt; IsWaitPulseEnd : LongInt) : LongInt; stdcall;
	//====================== Advanced FUNCTIONS ===================================================//
	TCMM_Adv_GetNumAvailAxes	= function (NumAxes : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetNumDefinedAxes	= function (NumAxes : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetNumAvailDioChan	= function (IsInputChannel : LongInt; NumChannels : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetNumDefinedDioChan	= function (IsInputChannel : LongInt; NumChannels : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetMotDeviceId	= function (Axis : LongInt; DeviceId : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetMotDevInstance	= function (Axis : LongInt; DevInstance : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetDioDeviceId	= function (Axis : LongInt; IsInputChannel : LongInt; DeviceId : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetDioDevInstance	= function (Axis : LongInt; IsInputChannel : LongInt; DevInstance : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetDeviceHandle	= function (DeviceId : LongInt; DevInstance : LongInt; DevHandle : THandle) : LongInt; stdcall;
	TCMM_Adv_WriteMainSpace	= function (Axis : LongInt; Addr : LongInt; Value : LongInt) : LongInt; stdcall;
	TCMM_Adv_ReadMainSpace	= function (Axis : LongInt; Addr : LongInt; Value : PLongInt) : LongInt; stdcall;
	TCMM_Adv_WriteRegister	= function (Axis : LongInt; RegisterNo : LongInt; RegVal : LongInt) : LongInt; stdcall;
	TCMM_Adv_ReadRegister	= function (Axis : LongInt; RegisterNo : LongInt; RegVal : PLongInt) : LongInt; stdcall;
	TCMM_Adv_GetMioCfg1Dword	= function (Axis : LongInt; Mio1Dword : PLongInt) : LongInt; stdcall;
	TCMM_Adv_SetMioCfg1Dword	= function (Axis : LongInt; Mio1Dword : LongInt) : LongInt; stdcall;
	TCMM_Adv_SetToolboxMode	= function (EnInterrupt : LongInt) : LongInt; stdcall;
	TCMM_Adv_GetString	= function (Axis : LongInt; StringID : LongInt; szBuffer : PChar) : LongInt; stdcall;
	TCMM_Adv_ErcOut	= function (Axis : LongInt; IsWaitOff : LongInt) : LongInt; stdcall;
	TCMM_Adv_ErcReset	= function (Axis : LongInt) : LongInt; stdcall;
	TCMM_Adv_SetExtOptions	= function (OptionId : LongInt; lParam1 : LongInt; lParam2 : LongInt; fParam1 : Double; fParam2 : Double) : LongInt; stdcall;
//CMM_EXTERN long (WINAPI *cmmAdvEnumMotDevices)	(TMotDevEnum *EnumBuffer);

//CMM_EXTERN long (WINAPI *cmmAdvGetMotDevMap)	(TMotDevMap *MapBuffer);

//CMM_EXTERN long (WINAPI *cmmAdvEnumDioDevices)	(TDioDevEnum *EnumBuffer);

//CMM_EXTERN long (WINAPI *cmmAdvGetDioDevMap)	(TDioDevMap *MapBuffer);

//CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer) (TCmeData_V2 *pCmeBuffer);

//CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer_MapOnly) (TCmeData_V2 *pCmeBuffer, int nMapType);

	TCMM_Adv_GetLatestCmeFile	= function (szCmeFile : PChar) : LongInt; stdcall;
	TCMM_Adv_GetAxisCapability	= function (Channel : LongInt; CapId : LongInt; CapBuffer : PLongInt) : LongInt; stdcall;
	//====================== DEBUG-LOGGING FUNCTIONS ==============================================//
	TCMM_Dlog_Setup	= function (Level : LongInt; szLogFile : PChar) : LongInt; stdcall;
	TCMM_Dlog_AddComment	= function (szComment : PChar) : LongInt; stdcall;
	TCMM_Dlog_GetCurLevel	= function (CurLevel : PLongInt) : LongInt; stdcall;
	TCMM_Dlog_GetCurFilePath	= function (szFilePath : PChar) : LongInt; stdcall;
	//====================== ERROR HANDLING FUNCTIONS =============================================//
	TCMM_Err_GetLastCode	= function (ErrorCode : PLongInt) : LongInt; stdcall;
	TCMM_Err_ParseAxis	= function (ErrorCode : LongInt) : ShortInt; stdcall;
	TCMM_Err_ParseReason	= function (ErrorCode : LongInt) : ShortInt; stdcall;
	TCMM_Err_GetString	= function (ErrorCode : LongInt; Buffer : PChar; BufferLen : LongInt) : LongInt; stdcall;
	TCMM_Err_ShowLast	= function (ParentWnd : THandle) : LongInt; stdcall;
	TCMM_Err_SetSkipShowMessage	= function (IsSkip : LongInt) : LongInt; stdcall;
	TCMM_Err_GetSkipShowMessage	= function (IsSkip : PLongInt) : LongInt; stdcall;
	TCMM_Err_SetEnableAutoMessage	= function (Enable : LongInt) : LongInt; stdcall;
	TCMM_Err_GetEnableAutoMessage	= function (Enabled : PLongInt) : LongInt; stdcall;
	//====================== Utility FUNCTIONS ===================================================//
	TCMM_Utl_ProcessWndMsgS	= function (WndHandle : THandle; IsEmpty : PLongInt) : LongInt; stdcall;
	TCMM_Utl_ProcessWndMsgM	= function (WndHandle : THandle; TimeOut : LongInt; IsTimeOuted : PLongInt) : LongInt; stdcall;
	TCMM_Utl_ReadUserTable	= function (hDevice : THandle; nAddress : LongInt; nSize : LongInt; pBuffer : PChar) : LongInt; stdcall;
	TCMM_Utl_WriteUserTable	= function (hDevice : THandle; nAddress : LongInt; nSize : LongInt; pBuffer : PChar) : LongInt; stdcall;
	TCMM_Utl_DelayMicroSec	= function (Delay_us : LongInt) : LongInt; stdcall;

	var

//====================== General FUNCTIONS ====================================================//
	cmmGnDeviceLoad : TCMM_Gn_DeviceLoad;
	cmmGnDeviceUnload : TCMM_Gn_DeviceUnload;
	cmmGnDeviceIsLoaded : TCMM_Gn_DeviceIsLoaded;
	cmmGnDeviceReset : TCMM_Gn_DeviceReset;
	cmmGnInitFromFile : TCMM_Gn_InitFromFile;
	cmmGnInitFromFile_MapOnly : TCMM_Gn_InitFromFile_MapOnly;
	cmmGnSetServoOn : TCMM_Gn_SetServoOn;
	cmmGnGetServoOn : TCMM_Gn_GetServoOn;
	cmmGnSetAlarmRes : TCMM_Gn_SetAlarmRes;
	cmmGnGetAlarmRes : TCMM_Gn_GetAlarmRes;
	cmmGnPulseAlarmRes : TCMM_Gn_PulseAlarmRes;
	cmmGnSetSimulMode : TCMM_Gn_SetSimulMode;
	cmmGnGetSimulMode : TCMM_Gn_GetSimulMode;
	cmmGnPutInternalSTA : TCMM_Gn_PutInternalSTA;
	cmmGnSetEmergency : TCMM_Gn_SetEmergency;
	cmmGnGetEmergency : TCMM_Gn_GetEmergency;
	cmmGnBitShift : TCMM_Gn_BitShift;
//====================== Configuration FUNCTIONS ==============================================//
	cmmCfgSetMioProperty : TCMM_Cfg_SetMioProperty;
	cmmCfgGetMioProperty : TCMM_Cfg_GetMioProperty;
	cmmCfgSetFilter : TCMM_Cfg_SetFilter;
	cmmCfgGetFilter : TCMM_Cfg_GetFilter;
	cmmCfgSetFilterAB : TCMM_Cfg_SetFilterAB;
	cmmCfgGetFilterAB : TCMM_Cfg_GetFilterAB;
	cmmCfgSetInMode : TCMM_Cfg_SetInMode;
	cmmCfgGetInMode : TCMM_Cfg_GetInMode;
	cmmCfgSetOutMode : TCMM_Cfg_SetOutMode;
	cmmCfgGetOutMode : TCMM_Cfg_GetOutMode;
	cmmCfgSetCtrlMode : TCMM_Cfg_SetCtrlMode;
	cmmCfgGetCtrlMode : TCMM_Cfg_GetCtrlMode;
	cmmCfgSetInOutRatio : TCMM_Cfg_SetInOutRatio;
	cmmCfgGetInOutRatio : TCMM_Cfg_GetInOutRatio;
	cmmCfgSetUnitDist : TCMM_Cfg_SetUnitDist;
	cmmCfgGetUnitDist : TCMM_Cfg_GetUnitDist;
	cmmCfgSetUnitSpeed : TCMM_Cfg_SetUnitSpeed;
	cmmCfgGetUnitSpeed : TCMM_Cfg_GetUnitSpeed;
	cmmCfgSetSpeedRange : TCMM_Cfg_SetSpeedRange;
	cmmCfgGetSpeedRange : TCMM_Cfg_GetSpeedRange;
	cmmCfgSetSpeedPattern : TCMM_Cfg_SetSpeedPattern;
	cmmCfgGetSpeedPattern : TCMM_Cfg_GetSpeedPattern;
	cmmCfgSetActSpdCheck : TCMM_Cfg_SetActSpdCheck;
	cmmCfgGetActSpdCheck : TCMM_Cfg_GetActSpdCheck;
	cmmCfgSetSoftLimit : TCMM_Cfg_SetSoftLimit;
	cmmCfgGetSoftLimit : TCMM_Cfg_GetSoftLimit;
	cmmCfgSetRingCntr : TCMM_Cfg_SetRingCntr;
	cmmCfgGetRingCntr : TCMM_Cfg_GetRingCntr;
	cmmCfgSetVelCorrRatio : TCMM_Cfg_SetVelCorrRatio;
	cmmCfgGetVelCorrRatio : TCMM_Cfg_GetVelCorrRatio;
	cmmCfgSetSeqMode : TCMM_Cfg_SetSeqMode;
	cmmCfgGetSeqMode : TCMM_Cfg_GetSeqMode;
	cmmCfgSetManExtLimit : TCMM_Cfg_SetManExtLimit;
	cmmCfgGetManExtLimit : TCMM_Cfg_GetManExtLimit;
//====================== HOME-RETURN FUNCTIONS ================================================//
	cmmHomeSetConfig : TCMM_Home_SetConfig;
	cmmHomeGetConfig : TCMM_Home_GetConfig;
	cmmHomeSetPosClrMode : TCMM_Home_SetPosClrMode;
	cmmHomeGetPosClrMode : TCMM_Home_GetPosClrMode;
	cmmHomeSetSpeedPattern : TCMM_Home_SetSpeedPattern;
	cmmHomeGetSpeedPattern : TCMM_Home_GetSpeedPattern;
	cmmHomeMoveStart : TCMM_Home_MoveStart;
	cmmHomeMove : TCMM_Home_Move;
	cmmHomeMoveAll : TCMM_Home_MoveAll;
	cmmHomeMoveAllStart : TCMM_Home_MoveAllStart;
	cmmHomeGetSuccess : TCMM_Home_GetSuccess;
	cmmHomeSetSuccess : TCMM_Home_SetSuccess;
	cmmHomeIsBusy : TCMM_Home_IsBusy;
	cmmHomeWaitDone : TCMM_Home_WaitDone;
//====================== Single Axis Move FUNCTIONS ===========================================//
	cmmSxSetSpeedRatio : TCMM_Sx_SetSpeedRatio;
	cmmSxGetSpeedRatio : TCMM_Sx_GetSpeedRatio;
	cmmSxMoveStart : TCMM_Sx_MoveStart;
	cmmSxMove : TCMM_Sx_Move;
	cmmSxMoveToStart : TCMM_Sx_MoveToStart;
	cmmSxMoveTo : TCMM_Sx_MoveTo;
	cmmSxVMoveStart : TCMM_Sx_VMoveStart;
	cmmSxStop : TCMM_Sx_Stop;
	cmmSxStopEmg : TCMM_Sx_StopEmg;
	cmmSxIsDone : TCMM_Sx_IsDone;
	cmmSxWaitDone : TCMM_Sx_WaitDone;
	cmmSxGetTargetPos : TCMM_Sx_GetTargetPos;
	cmmSxOptSetIniSpeed : TCMM_Sx_OptSetIniSpeed;
	cmmSxOptGetIniSpeed : TCMM_Sx_OptGetIniSpeed;
	cmmSxSetCorrection : TCMM_Sx_SetCorrection;
	cmmSxGetCorrection : TCMM_Sx_GetCorrection;
	cmmSxOptSetSyncMode : TCMM_Sx_OptSetSyncMode;
	cmmSxOptGetSyncMode : TCMM_Sx_OptGetSyncMode;
	cmmSxOptSetSyncOut : TCMM_Sx_OptSetSyncOut;
	cmmSxOptGetSyncOut : TCMM_Sx_OptGetSyncOut;
	cmmSxOptSetRdpOffset : TCMM_Sx_OptSetRdpOffset;
	cmmSxOptGetRdpOffset : TCMM_Sx_OptGetRdpOffset;
//====================== Multiple Axes Move FUNCTIONS =========================================//
	cmmMxMove : TCMM_Mx_Move;
	cmmMxVMoveStart : TCMM_Mx_VMoveStart;
	cmmMxMoveStart : TCMM_Mx_MoveStart;
	cmmMxMoveTo : TCMM_Mx_MoveTo;
	cmmMxMoveToStart : TCMM_Mx_MoveToStart;
	cmmMxStop : TCMM_Mx_Stop;
	cmmMxStopEmg : TCMM_Mx_StopEmg;
	cmmMxIsDone : TCMM_Mx_IsDone;
	cmmMxWaitDone : TCMM_Mx_WaitDone;
//====================== Interpolation Move FUNCTIONS =========================================//
	cmmIxMapAxes : TCMM_Ix_MapAxes;
	cmmIxSetSpeedPattern : TCMM_Ix_SetSpeedPattern;
	cmmIxGetSpeedPattern : TCMM_Ix_GetSpeedPattern;
	cmmIxLine : TCMM_Ix_Line;
	cmmIxLineStart : TCMM_Ix_LineStart;
	cmmIxLineTo : TCMM_Ix_LineTo;
	cmmIxLineToStart : TCMM_Ix_LineToStart;
	cmmIxArcA : TCMM_Ix_ArcA;
	cmmIxArcAStart : TCMM_Ix_ArcAStart;
	cmmIxArcATo : TCMM_Ix_ArcATo;
	cmmIxArcAToStart : TCMM_Ix_ArcAToStart;
	cmmIxArcP : TCMM_Ix_ArcP;
	cmmIxArcPStart : TCMM_Ix_ArcPStart;
	cmmIxArcPTo : TCMM_Ix_ArcPTo;
	cmmIxArcPToStart : TCMM_Ix_ArcPToStart;
	cmmIxArc3PStart : TCMM_Ix_Arc3PStart;
	cmmIxArc3P : TCMM_Ix_Arc3P;
	cmmIxArc3PToStart : TCMM_Ix_Arc3PToStart;
	cmmIxArc3PTo : TCMM_Ix_Arc3PTo;
	cmmIxIsDone : TCMM_Ix_IsDone;
	cmmIxWaitDone : TCMM_Ix_WaitDone;
	cmmIxStop : TCMM_Ix_Stop;
	cmmIxStopEmg : TCMM_Ix_StopEmg;
	cmmIxxHelOnceSetSpeed : TCMM_Ixx_HelOnceSetSpeed;
	cmmIxxHelOnceGetSpeed : TCMM_Ixx_HelOnceGetSpeed;
	cmmIxxHelOnce : TCMM_Ixx_HelOnce;
	cmmIxxHelOnceStart : TCMM_Ixx_HelOnceStart;
	cmmIxxSplineBuild : TCMM_Ixx_SplineBuild;
//====================== External Switch Move FUNCTIONS =======================================//
	cmmExVMoveStart : TCMM_Ex_VMoveStart;
	cmmExMoveStart : TCMM_Ex_MoveStart;
	cmmExMoveToStart : TCMM_Ex_MoveToStart;
//====================== Manual Pulsar FUNCTIONS ==============================================//
	cmmPlsrSetInMode : TCMM_Plsr_SetInMode;
	cmmPlsrGetInMode : TCMM_Plsr_GetInMode;
	cmmPlsrSetGain : TCMM_Plsr_SetGain;
	cmmPlsrGetGain : TCMM_Plsr_GetGain;
	cmmPlsrHomeMoveStart : TCMM_Plsr_HomeMoveStart;
	cmmPlsrMoveStart : TCMM_Plsr_MoveStart;
	cmmPlsrMove : TCMM_Plsr_Move;
	cmmPlsrMoveToStart : TCMM_Plsr_MoveToStart;
	cmmPlsrMoveTo : TCMM_Plsr_MoveTo;
	cmmPlsrVMoveStart : TCMM_Plsr_VMoveStart;
	cmmPlsrIsActive : TCMM_Plsr_IsActive;
//====================== MASTER/SLAVE FUNCTIONS ===============================================//
	cmmMsRegisterSlave : TCMM_Ms_RegisterSlave;
	cmmMsUnregisterSlave : TCMM_Ms_UnregisterSlave;
	cmmMsCheckSlaveState : TCMM_Ms_CheckSlaveState;
	cmmMsGetMasterAxis : TCMM_Ms_GetMasterAxis;
//====================== Overriding FUNCTIONS =================================================//
	cmmOverrideSpeedSet : TCMM_Override_SpeedSet;
	cmmOverrideSpeedSetAll : TCMM_Override_SpeedSetAll;
	cmmOverrideMove : TCMM_Override_Move;
	cmmOverrideMoveTo : TCMM_Override_MoveTo;
//====================== LIST-MOTION FUNCTIONS ================================================//
	cmmLmMapAxes : TCMM_Lm_MapAxes;
	cmmLmBeginList : TCMM_Lm_BeginList;
	cmmLmEndList : TCMM_Lm_EndList;
	cmmLmStartMotion : TCMM_Lm_StartMotion;
	cmmLmAbortMotion : TCMM_Lm_AbortMotion;
	cmmLmIsDone : TCMM_Lm_IsDone;
	cmmLmWaitDone : TCMM_Lm_WaitDone;
	cmmLmCurSequence : TCMM_Lm_CurSequence;
	cmmLmImmediacySet : TCMM_Lm_ImmediacySet;
	cmmLmDoPutOne : TCMM_Lm_DoPutOne;
	cmmLmDoPutMulti : TCMM_Lm_DoPutMulti;
	cmmLmDoPulseOne : TCMM_Lm_DoPulseOne;
	cmmLmDoPulseMulti : TCMM_Lm_DoPulseMulti;
//====================== ° FUNCTIONS ===================================================//
	cmmStSetCount : TCMM_St_SetCount;
	cmmStGetCount : TCMM_St_GetCount;
	cmmStSetPosition : TCMM_St_SetPosition;
	cmmStGetPosition : TCMM_St_GetPosition;
	cmmStGetSpeed : TCMM_St_GetSpeed;
	cmmStReadMotionState : TCMM_St_ReadMotionState;
	cmmStReadMioStatuses : TCMM_St_ReadMioStatuses;
	cmmStGetMstString : TCMM_St_GetMstString;
//====================== INTERRUPT FUNCTIONS ==================================================//
	cmmIntSetMask : TCMM_Int_SetMask;
	cmmIntGetMask : TCMM_Int_GetMask;
	cmmIntHandlerSetup : TCMM_Int_HandlerSetup;
	cmmIntHandlerEnable : TCMM_Int_HandlerEnable;
	cmmIntReadFlag : TCMM_Int_ReadFlag;
	cmmIntReadErrorStatus : TCMM_Int_ReadErrorStatus;
	cmmIntReadEventStatus : TCMM_Int_ReadEventStatus;
//====================== LATCH FUNCTIONS =======================================================//
	cmmLtcIsLatched : TCMM_Ltc_IsLatched;
	cmmLtcReadLatch : TCMM_Ltc_ReadLatch;
//====================== Position Compare FUNCTIONS ===========================================//
	cmmCmpErrSetConfig : TCMM_Cmp_ErrSetConfig;
	cmmCmpErrGetConfig : TCMM_Cmp_ErrGetConfig;
	cmmCmpGenSetConfig : TCMM_Cmp_GenSetConfig;
	cmmCmpGenGetConfig : TCMM_Cmp_GenGetConfig;
	cmmCmpTrgSetConfig : TCMM_Cmp_TrgSetConfig;
	cmmCmpTrgGetConfig : TCMM_Cmp_TrgGetConfig;
	cmmCmpTrgSetOneData : TCMM_Cmp_TrgSetOneData;
	cmmCmpTrgGetCurData : TCMM_Cmp_TrgGetCurData;
	cmmCmpTrgContRegTable : TCMM_Cmp_TrgContRegTable;
	cmmCmpTrgContBuildTable : TCMM_Cmp_TrgContBuildTable;
	cmmCmpTrgContStart : TCMM_Cmp_TrgContStart;
	cmmCmpTrgContStop : TCMM_Cmp_TrgContStop;
	cmmCmpTrgContIsActive : TCMM_Cmp_TrgContIsActive;
	cmmCmpTrgHigh_WriteData : TCMM_Cmp_TrgHigh_WriteData;
	cmmCmpTrgHigh_ReadData : TCMM_Cmp_TrgHigh_ReadData;
	cmmCmpTrgHigh_Start : TCMM_Cmp_TrgHigh_Start;
	cmmCmpTrgHigh_Stop : TCMM_Cmp_TrgHigh_Stop;
	cmmCmpTrgHigh_Check : TCMM_Cmp_TrgHigh_Check;
//====================== Digital In/Out FUNCTIONS =============================================//
	cmmDiSetInputLogic : TCMM_Di_SetInputLogic;
	cmmDiGetInputLogic : TCMM_Di_GetInputLogic;
	cmmDiGetOne : TCMM_Di_GetOne;
	cmmDiGetMulti : TCMM_Di_GetMulti;
	cmmDiGetOneF : TCMM_Di_GetOneF;
	cmmDiGetMultiF : TCMM_Di_GetMultiF;
	cmmDoSetOutputLogic : TCMM_Do_SetOutputLogic;
	cmmDoGetOutputLogic : TCMM_Do_GetOutputLogic;
	cmmDoPutOne : TCMM_Do_PutOne;
	cmmDoGetOne : TCMM_Do_GetOne;
	cmmDoPulseOne : TCMM_Do_PulseOne;
	cmmDoPutMulti : TCMM_Do_PutMulti;
	cmmDoGetMulti : TCMM_Do_GetMulti;
	cmmDoPulseMulti : TCMM_Do_PulseMulti;
//====================== Advanced FUNCTIONS ===================================================//
	cmmAdvGetNumAvailAxes : TCMM_Adv_GetNumAvailAxes;
	cmmAdvGetNumDefinedAxes : TCMM_Adv_GetNumDefinedAxes;
	cmmAdvGetNumAvailDioChan : TCMM_Adv_GetNumAvailDioChan;
	cmmAdvGetNumDefinedDioChan : TCMM_Adv_GetNumDefinedDioChan;
	cmmAdvGetMotDeviceId : TCMM_Adv_GetMotDeviceId;
	cmmAdvGetMotDevInstance : TCMM_Adv_GetMotDevInstance;
	cmmAdvGetDioDeviceId : TCMM_Adv_GetDioDeviceId;
	cmmAdvGetDioDevInstance : TCMM_Adv_GetDioDevInstance;
	cmmAdvGetDeviceHandle : TCMM_Adv_GetDeviceHandle;
	cmmAdvWriteMainSpace : TCMM_Adv_WriteMainSpace;
	cmmAdvReadMainSpace : TCMM_Adv_ReadMainSpace;
	cmmAdvWriteRegister : TCMM_Adv_WriteRegister;
	cmmAdvReadRegister : TCMM_Adv_ReadRegister;
	cmmAdvGetMioCfg1Dword : TCMM_Adv_GetMioCfg1Dword;
	cmmAdvSetMioCfg1Dword : TCMM_Adv_SetMioCfg1Dword;
	cmmAdvSetToolboxMode : TCMM_Adv_SetToolboxMode;
	cmmAdvGetString : TCMM_Adv_GetString;
	cmmAdvErcOut : TCMM_Adv_ErcOut;
	cmmAdvErcReset : TCMM_Adv_ErcReset;
	cmmAdvSetExtOptions : TCMM_Adv_SetExtOptions;
	cmmAdvGetLatestCmeFile : TCMM_Adv_GetLatestCmeFile;
	cmmAdvGetAxisCapability : TCMM_Adv_GetAxisCapability;
//====================== DEBUG-LOGGING FUNCTIONS ==============================================//
	cmmDlogSetup : TCMM_Dlog_Setup;
	cmmDlogAddComment : TCMM_Dlog_AddComment;
	cmmDlogGetCurLevel : TCMM_Dlog_GetCurLevel;
	cmmDlogGetCurFilePath : TCMM_Dlog_GetCurFilePath;
//====================== ERROR HANDLING FUNCTIONS =============================================//
	cmmErrGetLastCode : TCMM_Err_GetLastCode;
	cmmErrParseAxis : TCMM_Err_ParseAxis;
	cmmErrParseReason : TCMM_Err_ParseReason;
	cmmErrGetString : TCMM_Err_GetString;
	cmmErrShowLast : TCMM_Err_ShowLast;
	cmmErrSetSkipShowMessage : TCMM_Err_SetSkipShowMessage;
	cmmErrGetSkipShowMessage : TCMM_Err_GetSkipShowMessage;
	cmmErrSetEnableAutoMessage : TCMM_Err_SetEnableAutoMessage;
	cmmErrGetEnableAutoMessage : TCMM_Err_GetEnableAutoMessage;
//====================== Utility FUNCTIONS ===================================================//
	cmmUtlProcessWndMsgS : TCMM_Utl_ProcessWndMsgS;
	cmmUtlProcessWndMsgM : TCMM_Utl_ProcessWndMsgM;
	cmmUtlReadUserTable : TCMM_Utl_ReadUserTable;
	cmmUtlWriteUserTable : TCMM_Utl_WriteUserTable;
	cmmUtlDelayMicroSec : TCMM_Utl_DelayMicroSec;


	FDLLInstance : THandle;

procedure LoadDll;
procedure UnloadDll;

implementation

{ TComiDaq }

Const
LIBRARY_FILENAME : AnsiString = 'Cmmsdk.dll';

procedure LoadDll;
var
	LibraryFilename : AnsiString;
	// FDLLPath : string;

begin
	LibraryFilename := LIBRARY_FILENAME;
	FDLLInstance := LoadLibrary(PChar(LibraryFileName));

	if ( FDLLInstance <> 0 ) then
	begin

//====================== General FUNCTIONS ====================================================//
		@cmmGnDeviceLoad := GetProcAddress(FDLLInstance, 'cmmGnDeviceLoad');
		@cmmGnDeviceUnload := GetProcAddress(FDLLInstance, 'cmmGnDeviceUnload');
		@cmmGnDeviceIsLoaded := GetProcAddress(FDLLInstance, 'cmmGnDeviceIsLoaded');
		@cmmGnDeviceReset := GetProcAddress(FDLLInstance, 'cmmGnDeviceReset');
		@cmmGnInitFromFile := GetProcAddress(FDLLInstance, 'cmmGnInitFromFile');
		@cmmGnInitFromFile_MapOnly := GetProcAddress(FDLLInstance, 'cmmGnInitFromFile_MapOnly');
		@cmmGnSetServoOn := GetProcAddress(FDLLInstance, 'cmmGnSetServoOn');
		@cmmGnGetServoOn := GetProcAddress(FDLLInstance, 'cmmGnGetServoOn');
		@cmmGnSetAlarmRes := GetProcAddress(FDLLInstance, 'cmmGnSetAlarmRes');
		@cmmGnGetAlarmRes := GetProcAddress(FDLLInstance, 'cmmGnGetAlarmRes');
		@cmmGnPulseAlarmRes := GetProcAddress(FDLLInstance, 'cmmGnPulseAlarmRes');
		@cmmGnSetSimulMode := GetProcAddress(FDLLInstance, 'cmmGnSetSimulMode');
		@cmmGnGetSimulMode := GetProcAddress(FDLLInstance, 'cmmGnGetSimulMode');
		@cmmGnPutInternalSTA := GetProcAddress(FDLLInstance, 'cmmGnPutInternalSTA');
		@cmmGnSetEmergency := GetProcAddress(FDLLInstance, 'cmmGnSetEmergency');
		@cmmGnGetEmergency := GetProcAddress(FDLLInstance, 'cmmGnGetEmergency');
		@cmmGnBitShift := GetProcAddress(FDLLInstance, 'cmmGnBitShift');
//====================== Configuration FUNCTIONS ==============================================//
		@cmmCfgSetMioProperty := GetProcAddress(FDLLInstance, 'cmmCfgSetMioProperty');
		@cmmCfgGetMioProperty := GetProcAddress(FDLLInstance, 'cmmCfgGetMioProperty');
		@cmmCfgSetFilter := GetProcAddress(FDLLInstance, 'cmmCfgSetFilter');
		@cmmCfgGetFilter := GetProcAddress(FDLLInstance, 'cmmCfgGetFilter');
		@cmmCfgSetFilterAB := GetProcAddress(FDLLInstance, 'cmmCfgSetFilterAB');
		@cmmCfgGetFilterAB := GetProcAddress(FDLLInstance, 'cmmCfgGetFilterAB');
		@cmmCfgSetInMode := GetProcAddress(FDLLInstance, 'cmmCfgSetInMode');
		@cmmCfgGetInMode := GetProcAddress(FDLLInstance, 'cmmCfgGetInMode');
		@cmmCfgSetOutMode := GetProcAddress(FDLLInstance, 'cmmCfgSetOutMode');
		@cmmCfgGetOutMode := GetProcAddress(FDLLInstance, 'cmmCfgGetOutMode');
		@cmmCfgSetCtrlMode := GetProcAddress(FDLLInstance, 'cmmCfgSetCtrlMode');
		@cmmCfgGetCtrlMode := GetProcAddress(FDLLInstance, 'cmmCfgGetCtrlMode');
		@cmmCfgSetInOutRatio := GetProcAddress(FDLLInstance, 'cmmCfgSetInOutRatio');
		@cmmCfgGetInOutRatio := GetProcAddress(FDLLInstance, 'cmmCfgGetInOutRatio');
		@cmmCfgSetUnitDist := GetProcAddress(FDLLInstance, 'cmmCfgSetUnitDist');
		@cmmCfgGetUnitDist := GetProcAddress(FDLLInstance, 'cmmCfgGetUnitDist');
		@cmmCfgSetUnitSpeed := GetProcAddress(FDLLInstance, 'cmmCfgSetUnitSpeed');
		@cmmCfgGetUnitSpeed := GetProcAddress(FDLLInstance, 'cmmCfgGetUnitSpeed');
		@cmmCfgSetSpeedRange := GetProcAddress(FDLLInstance, 'cmmCfgSetSpeedRange');
		@cmmCfgGetSpeedRange := GetProcAddress(FDLLInstance, 'cmmCfgGetSpeedRange');
		@cmmCfgSetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmCfgSetSpeedPattern');
		@cmmCfgGetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmCfgGetSpeedPattern');
		@cmmCfgSetActSpdCheck := GetProcAddress(FDLLInstance, 'cmmCfgSetActSpdCheck');
		@cmmCfgGetActSpdCheck := GetProcAddress(FDLLInstance, 'cmmCfgGetActSpdCheck');
		@cmmCfgSetSoftLimit := GetProcAddress(FDLLInstance, 'cmmCfgSetSoftLimit');
		@cmmCfgGetSoftLimit := GetProcAddress(FDLLInstance, 'cmmCfgGetSoftLimit');
		@cmmCfgSetRingCntr := GetProcAddress(FDLLInstance, 'cmmCfgSetRingCntr');
		@cmmCfgGetRingCntr := GetProcAddress(FDLLInstance, 'cmmCfgGetRingCntr');
		@cmmCfgSetVelCorrRatio := GetProcAddress(FDLLInstance, 'cmmCfgSetVelCorrRatio');
		@cmmCfgGetVelCorrRatio := GetProcAddress(FDLLInstance, 'cmmCfgGetVelCorrRatio');
		@cmmCfgSetSeqMode := GetProcAddress(FDLLInstance, 'cmmCfgSetSeqMode');
		@cmmCfgGetSeqMode := GetProcAddress(FDLLInstance, 'cmmCfgGetSeqMode');
		@cmmCfgSetManExtLimit := GetProcAddress(FDLLInstance, 'cmmCfgSetManExtLimit');
		@cmmCfgGetManExtLimit := GetProcAddress(FDLLInstance, 'cmmCfgGetManExtLimit');
//====================== HOME-RETURN FUNCTIONS ================================================//
		@cmmHomeSetConfig := GetProcAddress(FDLLInstance, 'cmmHomeSetConfig');
		@cmmHomeGetConfig := GetProcAddress(FDLLInstance, 'cmmHomeGetConfig');
		@cmmHomeSetPosClrMode := GetProcAddress(FDLLInstance, 'cmmHomeSetPosClrMode');
		@cmmHomeGetPosClrMode := GetProcAddress(FDLLInstance, 'cmmHomeGetPosClrMode');
		@cmmHomeSetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmHomeSetSpeedPattern');
		@cmmHomeGetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmHomeGetSpeedPattern');
		@cmmHomeMoveStart := GetProcAddress(FDLLInstance, 'cmmHomeMoveStart');
		@cmmHomeMove := GetProcAddress(FDLLInstance, 'cmmHomeMove');
		@cmmHomeMoveAll := GetProcAddress(FDLLInstance, 'cmmHomeMoveAll');
		@cmmHomeMoveAllStart := GetProcAddress(FDLLInstance, 'cmmHomeMoveAllStart');
		@cmmHomeGetSuccess := GetProcAddress(FDLLInstance, 'cmmHomeGetSuccess');
		@cmmHomeSetSuccess := GetProcAddress(FDLLInstance, 'cmmHomeSetSuccess');
		@cmmHomeIsBusy := GetProcAddress(FDLLInstance, 'cmmHomeIsBusy');
		@cmmHomeWaitDone := GetProcAddress(FDLLInstance, 'cmmHomeWaitDone');
//====================== Single Axis Move FUNCTIONS ===========================================//
		@cmmSxSetSpeedRatio := GetProcAddress(FDLLInstance, 'cmmSxSetSpeedRatio');
		@cmmSxGetSpeedRatio := GetProcAddress(FDLLInstance, 'cmmSxGetSpeedRatio');
		@cmmSxMoveStart := GetProcAddress(FDLLInstance, 'cmmSxMoveStart');
		@cmmSxMove := GetProcAddress(FDLLInstance, 'cmmSxMove');
		@cmmSxMoveToStart := GetProcAddress(FDLLInstance, 'cmmSxMoveToStart');
		@cmmSxMoveTo := GetProcAddress(FDLLInstance, 'cmmSxMoveTo');
		@cmmSxVMoveStart := GetProcAddress(FDLLInstance, 'cmmSxVMoveStart');
		@cmmSxStop := GetProcAddress(FDLLInstance, 'cmmSxStop');
		@cmmSxStopEmg := GetProcAddress(FDLLInstance, 'cmmSxStopEmg');
		@cmmSxIsDone := GetProcAddress(FDLLInstance, 'cmmSxIsDone');
		@cmmSxWaitDone := GetProcAddress(FDLLInstance, 'cmmSxWaitDone');
		@cmmSxGetTargetPos := GetProcAddress(FDLLInstance, 'cmmSxGetTargetPos');
		@cmmSxOptSetIniSpeed := GetProcAddress(FDLLInstance, 'cmmSxOptSetIniSpeed');
		@cmmSxOptGetIniSpeed := GetProcAddress(FDLLInstance, 'cmmSxOptGetIniSpeed');
		@cmmSxSetCorrection := GetProcAddress(FDLLInstance, 'cmmSxSetCorrection');
		@cmmSxGetCorrection := GetProcAddress(FDLLInstance, 'cmmSxGetCorrection');
		@cmmSxOptSetSyncMode := GetProcAddress(FDLLInstance, 'cmmSxOptSetSyncMode');
		@cmmSxOptGetSyncMode := GetProcAddress(FDLLInstance, 'cmmSxOptGetSyncMode');
		@cmmSxOptSetSyncOut := GetProcAddress(FDLLInstance, 'cmmSxOptSetSyncOut');
		@cmmSxOptGetSyncOut := GetProcAddress(FDLLInstance, 'cmmSxOptGetSyncOut');
		@cmmSxOptSetRdpOffset := GetProcAddress(FDLLInstance, 'cmmSxOptSetRdpOffset');
		@cmmSxOptGetRdpOffset := GetProcAddress(FDLLInstance, 'cmmSxOptGetRdpOffset');
//====================== Multiple Axes Move FUNCTIONS =========================================//
		@cmmMxMove := GetProcAddress(FDLLInstance, 'cmmMxMove');
		@cmmMxVMoveStart := GetProcAddress(FDLLInstance, 'cmmMxVMoveStart');
		@cmmMxMoveStart := GetProcAddress(FDLLInstance, 'cmmMxMoveStart');
		@cmmMxMoveTo := GetProcAddress(FDLLInstance, 'cmmMxMoveTo');
		@cmmMxMoveToStart := GetProcAddress(FDLLInstance, 'cmmMxMoveToStart');
		@cmmMxStop := GetProcAddress(FDLLInstance, 'cmmMxStop');
		@cmmMxStopEmg := GetProcAddress(FDLLInstance, 'cmmMxStopEmg');
		@cmmMxIsDone := GetProcAddress(FDLLInstance, 'cmmMxIsDone');
		@cmmMxWaitDone := GetProcAddress(FDLLInstance, 'cmmMxWaitDone');
//====================== Interpolation Move FUNCTIONS =========================================//
		@cmmIxMapAxes := GetProcAddress(FDLLInstance, 'cmmIxMapAxes');
		@cmmIxSetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmIxSetSpeedPattern');
		@cmmIxGetSpeedPattern := GetProcAddress(FDLLInstance, 'cmmIxGetSpeedPattern');
		@cmmIxLine := GetProcAddress(FDLLInstance, 'cmmIxLine');
		@cmmIxLineStart := GetProcAddress(FDLLInstance, 'cmmIxLineStart');
		@cmmIxLineTo := GetProcAddress(FDLLInstance, 'cmmIxLineTo');
		@cmmIxLineToStart := GetProcAddress(FDLLInstance, 'cmmIxLineToStart');
		@cmmIxArcA := GetProcAddress(FDLLInstance, 'cmmIxArcA');
		@cmmIxArcAStart := GetProcAddress(FDLLInstance, 'cmmIxArcAStart');
		@cmmIxArcATo := GetProcAddress(FDLLInstance, 'cmmIxArcATo');
		@cmmIxArcAToStart := GetProcAddress(FDLLInstance, 'cmmIxArcAToStart');
		@cmmIxArcP := GetProcAddress(FDLLInstance, 'cmmIxArcP');
		@cmmIxArcPStart := GetProcAddress(FDLLInstance, 'cmmIxArcPStart');
		@cmmIxArcPTo := GetProcAddress(FDLLInstance, 'cmmIxArcPTo');
		@cmmIxArcPToStart := GetProcAddress(FDLLInstance, 'cmmIxArcPToStart');
		@cmmIxArc3PStart := GetProcAddress(FDLLInstance, 'cmmIxArc3PStart');
		@cmmIxArc3P := GetProcAddress(FDLLInstance, 'cmmIxArc3P');
		@cmmIxArc3PToStart := GetProcAddress(FDLLInstance, 'cmmIxArc3PToStart');
		@cmmIxArc3PTo := GetProcAddress(FDLLInstance, 'cmmIxArc3PTo');
		@cmmIxIsDone := GetProcAddress(FDLLInstance, 'cmmIxIsDone');
		@cmmIxWaitDone := GetProcAddress(FDLLInstance, 'cmmIxWaitDone');
		@cmmIxStop := GetProcAddress(FDLLInstance, 'cmmIxStop');
		@cmmIxStopEmg := GetProcAddress(FDLLInstance, 'cmmIxStopEmg');
		@cmmIxxHelOnceSetSpeed := GetProcAddress(FDLLInstance, 'cmmIxxHelOnceSetSpeed');
		@cmmIxxHelOnceGetSpeed := GetProcAddress(FDLLInstance, 'cmmIxxHelOnceGetSpeed');
		@cmmIxxHelOnce := GetProcAddress(FDLLInstance, 'cmmIxxHelOnce');
		@cmmIxxHelOnceStart := GetProcAddress(FDLLInstance, 'cmmIxxHelOnceStart');
		@cmmIxxSplineBuild := GetProcAddress(FDLLInstance, 'cmmIxxSplineBuild');
//====================== External Switch Move FUNCTIONS =======================================//
		@cmmExVMoveStart := GetProcAddress(FDLLInstance, 'cmmExVMoveStart');
		@cmmExMoveStart := GetProcAddress(FDLLInstance, 'cmmExMoveStart');
		@cmmExMoveToStart := GetProcAddress(FDLLInstance, 'cmmExMoveToStart');
//====================== Manual Pulsar FUNCTIONS ==============================================//
		@cmmPlsrSetInMode := GetProcAddress(FDLLInstance, 'cmmPlsrSetInMode');
		@cmmPlsrGetInMode := GetProcAddress(FDLLInstance, 'cmmPlsrGetInMode');
		@cmmPlsrSetGain := GetProcAddress(FDLLInstance, 'cmmPlsrSetGain');
		@cmmPlsrGetGain := GetProcAddress(FDLLInstance, 'cmmPlsrGetGain');
		@cmmPlsrHomeMoveStart := GetProcAddress(FDLLInstance, 'cmmPlsrHomeMoveStart');
		@cmmPlsrMoveStart := GetProcAddress(FDLLInstance, 'cmmPlsrMoveStart');
		@cmmPlsrMove := GetProcAddress(FDLLInstance, 'cmmPlsrMove');
		@cmmPlsrMoveToStart := GetProcAddress(FDLLInstance, 'cmmPlsrMoveToStart');
		@cmmPlsrMoveTo := GetProcAddress(FDLLInstance, 'cmmPlsrMoveTo');
		@cmmPlsrVMoveStart := GetProcAddress(FDLLInstance, 'cmmPlsrVMoveStart');
		@cmmPlsrIsActive := GetProcAddress(FDLLInstance, 'cmmPlsrIsActive');
//====================== MASTER/SLAVE FUNCTIONS ===============================================//
		@cmmMsRegisterSlave := GetProcAddress(FDLLInstance, 'cmmMsRegisterSlave');
		@cmmMsUnregisterSlave := GetProcAddress(FDLLInstance, 'cmmMsUnregisterSlave');
		@cmmMsCheckSlaveState := GetProcAddress(FDLLInstance, 'cmmMsCheckSlaveState');
		@cmmMsGetMasterAxis := GetProcAddress(FDLLInstance, 'cmmMsGetMasterAxis');
//====================== Overriding FUNCTIONS =================================================//
		@cmmOverrideSpeedSet := GetProcAddress(FDLLInstance, 'cmmOverrideSpeedSet');
		@cmmOverrideSpeedSetAll := GetProcAddress(FDLLInstance, 'cmmOverrideSpeedSetAll');
		@cmmOverrideMove := GetProcAddress(FDLLInstance, 'cmmOverrideMove');
		@cmmOverrideMoveTo := GetProcAddress(FDLLInstance, 'cmmOverrideMoveTo');
//====================== LIST-MOTION FUNCTIONS ================================================//
		@cmmLmMapAxes := GetProcAddress(FDLLInstance, 'cmmLmMapAxes');
		@cmmLmBeginList := GetProcAddress(FDLLInstance, 'cmmLmBeginList');
		@cmmLmEndList := GetProcAddress(FDLLInstance, 'cmmLmEndList');
		@cmmLmStartMotion := GetProcAddress(FDLLInstance, 'cmmLmStartMotion');
		@cmmLmAbortMotion := GetProcAddress(FDLLInstance, 'cmmLmAbortMotion');
		@cmmLmIsDone := GetProcAddress(FDLLInstance, 'cmmLmIsDone');
		@cmmLmWaitDone := GetProcAddress(FDLLInstance, 'cmmLmWaitDone');
		@cmmLmCurSequence := GetProcAddress(FDLLInstance, 'cmmLmCurSequence');
		@cmmLmImmediacySet := GetProcAddress(FDLLInstance, 'cmmLmImmediacySet');
		@cmmLmDoPutOne := GetProcAddress(FDLLInstance, 'cmmLmDoPutOne');
		@cmmLmDoPutMulti := GetProcAddress(FDLLInstance, 'cmmLmDoPutMulti');
		@cmmLmDoPulseOne := GetProcAddress(FDLLInstance, 'cmmLmDoPulseOne');
		@cmmLmDoPulseMulti := GetProcAddress(FDLLInstance, 'cmmLmDoPulseMulti');
//====================== ° FUNCTIONS ===================================================//
		@cmmStSetCount := GetProcAddress(FDLLInstance, 'cmmStSetCount');
		@cmmStGetCount := GetProcAddress(FDLLInstance, 'cmmStGetCount');
		@cmmStSetPosition := GetProcAddress(FDLLInstance, 'cmmStSetPosition');
		@cmmStGetPosition := GetProcAddress(FDLLInstance, 'cmmStGetPosition');
		@cmmStGetSpeed := GetProcAddress(FDLLInstance, 'cmmStGetSpeed');
		@cmmStReadMotionState := GetProcAddress(FDLLInstance, 'cmmStReadMotionState');
		@cmmStReadMioStatuses := GetProcAddress(FDLLInstance, 'cmmStReadMioStatuses');
		@cmmStGetMstString := GetProcAddress(FDLLInstance, 'cmmStGetMstString');
//====================== INTERRUPT FUNCTIONS ==================================================//
		@cmmIntSetMask := GetProcAddress(FDLLInstance, 'cmmIntSetMask');
		@cmmIntGetMask := GetProcAddress(FDLLInstance, 'cmmIntGetMask');
		@cmmIntHandlerSetup := GetProcAddress(FDLLInstance, 'cmmIntHandlerSetup');
		@cmmIntHandlerEnable := GetProcAddress(FDLLInstance, 'cmmIntHandlerEnable');
		@cmmIntReadFlag := GetProcAddress(FDLLInstance, 'cmmIntReadFlag');
		@cmmIntReadErrorStatus := GetProcAddress(FDLLInstance, 'cmmIntReadErrorStatus');
		@cmmIntReadEventStatus := GetProcAddress(FDLLInstance, 'cmmIntReadEventStatus');
//====================== LATCH FUNCTIONS =======================================================//
		@cmmLtcIsLatched := GetProcAddress(FDLLInstance, 'cmmLtcIsLatched');
		@cmmLtcReadLatch := GetProcAddress(FDLLInstance, 'cmmLtcReadLatch');
//====================== Position Compare FUNCTIONS ===========================================//
		@cmmCmpErrSetConfig := GetProcAddress(FDLLInstance, 'cmmCmpErrSetConfig');
		@cmmCmpErrGetConfig := GetProcAddress(FDLLInstance, 'cmmCmpErrGetConfig');
		@cmmCmpGenSetConfig := GetProcAddress(FDLLInstance, 'cmmCmpGenSetConfig');
		@cmmCmpGenGetConfig := GetProcAddress(FDLLInstance, 'cmmCmpGenGetConfig');
		@cmmCmpTrgSetConfig := GetProcAddress(FDLLInstance, 'cmmCmpTrgSetConfig');
		@cmmCmpTrgGetConfig := GetProcAddress(FDLLInstance, 'cmmCmpTrgGetConfig');
		@cmmCmpTrgSetOneData := GetProcAddress(FDLLInstance, 'cmmCmpTrgSetOneData');
		@cmmCmpTrgGetCurData := GetProcAddress(FDLLInstance, 'cmmCmpTrgGetCurData');
		@cmmCmpTrgContRegTable := GetProcAddress(FDLLInstance, 'cmmCmpTrgContRegTable');
		@cmmCmpTrgContBuildTable := GetProcAddress(FDLLInstance, 'cmmCmpTrgContBuildTable');
		@cmmCmpTrgContStart := GetProcAddress(FDLLInstance, 'cmmCmpTrgContStart');
		@cmmCmpTrgContStop := GetProcAddress(FDLLInstance, 'cmmCmpTrgContStop');
		@cmmCmpTrgContIsActive := GetProcAddress(FDLLInstance, 'cmmCmpTrgContIsActive');
		@cmmCmpTrgHigh_WriteData := GetProcAddress(FDLLInstance, 'cmmCmpTrgHigh_WriteData');
		@cmmCmpTrgHigh_ReadData := GetProcAddress(FDLLInstance, 'cmmCmpTrgHigh_ReadData');
		@cmmCmpTrgHigh_Start := GetProcAddress(FDLLInstance, 'cmmCmpTrgHigh_Start');
		@cmmCmpTrgHigh_Stop := GetProcAddress(FDLLInstance, 'cmmCmpTrgHigh_Stop');
		@cmmCmpTrgHigh_Check := GetProcAddress(FDLLInstance, 'cmmCmpTrgHigh_Check');
//====================== Digital In/Out FUNCTIONS =============================================//
		@cmmDiSetInputLogic := GetProcAddress(FDLLInstance, 'cmmDiSetInputLogic');
		@cmmDiGetInputLogic := GetProcAddress(FDLLInstance, 'cmmDiGetInputLogic');
		@cmmDiGetOne := GetProcAddress(FDLLInstance, 'cmmDiGetOne');
		@cmmDiGetMulti := GetProcAddress(FDLLInstance, 'cmmDiGetMulti');
		@cmmDiGetOneF := GetProcAddress(FDLLInstance, 'cmmDiGetOneF');
		@cmmDiGetMultiF := GetProcAddress(FDLLInstance, 'cmmDiGetMultiF');
		@cmmDoSetOutputLogic := GetProcAddress(FDLLInstance, 'cmmDoSetOutputLogic');
		@cmmDoGetOutputLogic := GetProcAddress(FDLLInstance, 'cmmDoGetOutputLogic');
		@cmmDoPutOne := GetProcAddress(FDLLInstance, 'cmmDoPutOne');
		@cmmDoGetOne := GetProcAddress(FDLLInstance, 'cmmDoGetOne');
		@cmmDoPulseOne := GetProcAddress(FDLLInstance, 'cmmDoPulseOne');
		@cmmDoPutMulti := GetProcAddress(FDLLInstance, 'cmmDoPutMulti');
		@cmmDoGetMulti := GetProcAddress(FDLLInstance, 'cmmDoGetMulti');
		@cmmDoPulseMulti := GetProcAddress(FDLLInstance, 'cmmDoPulseMulti');
//====================== Advanced FUNCTIONS ===================================================//
		@cmmAdvGetNumAvailAxes := GetProcAddress(FDLLInstance, 'cmmAdvGetNumAvailAxes');
		@cmmAdvGetNumDefinedAxes := GetProcAddress(FDLLInstance, 'cmmAdvGetNumDefinedAxes');
		@cmmAdvGetNumAvailDioChan := GetProcAddress(FDLLInstance, 'cmmAdvGetNumAvailDioChan');
		@cmmAdvGetNumDefinedDioChan := GetProcAddress(FDLLInstance, 'cmmAdvGetNumDefinedDioChan');
		@cmmAdvGetMotDeviceId := GetProcAddress(FDLLInstance, 'cmmAdvGetMotDeviceId');
		@cmmAdvGetMotDevInstance := GetProcAddress(FDLLInstance, 'cmmAdvGetMotDevInstance');
		@cmmAdvGetDioDeviceId := GetProcAddress(FDLLInstance, 'cmmAdvGetDioDeviceId');
		@cmmAdvGetDioDevInstance := GetProcAddress(FDLLInstance, 'cmmAdvGetDioDevInstance');
		@cmmAdvGetDeviceHandle := GetProcAddress(FDLLInstance, 'cmmAdvGetDeviceHandle');
		@cmmAdvWriteMainSpace := GetProcAddress(FDLLInstance, 'cmmAdvWriteMainSpace');
		@cmmAdvReadMainSpace := GetProcAddress(FDLLInstance, 'cmmAdvReadMainSpace');
		@cmmAdvWriteRegister := GetProcAddress(FDLLInstance, 'cmmAdvWriteRegister');
		@cmmAdvReadRegister := GetProcAddress(FDLLInstance, 'cmmAdvReadRegister');
		@cmmAdvGetMioCfg1Dword := GetProcAddress(FDLLInstance, 'cmmAdvGetMioCfg1Dword');
		@cmmAdvSetMioCfg1Dword := GetProcAddress(FDLLInstance, 'cmmAdvSetMioCfg1Dword');
		@cmmAdvSetToolboxMode := GetProcAddress(FDLLInstance, 'cmmAdvSetToolboxMode');
		@cmmAdvGetString := GetProcAddress(FDLLInstance, 'cmmAdvGetString');
		@cmmAdvErcOut := GetProcAddress(FDLLInstance, 'cmmAdvErcOut');
		@cmmAdvErcReset := GetProcAddress(FDLLInstance, 'cmmAdvErcReset');
		@cmmAdvSetExtOptions := GetProcAddress(FDLLInstance, 'cmmAdvSetExtOptions');
		@cmmAdvGetLatestCmeFile := GetProcAddress(FDLLInstance, 'cmmAdvGetLatestCmeFile');
		@cmmAdvGetAxisCapability := GetProcAddress(FDLLInstance, 'cmmAdvGetAxisCapability');
//====================== DEBUG-LOGGING FUNCTIONS ==============================================//
		@cmmDlogSetup := GetProcAddress(FDLLInstance, 'cmmDlogSetup');
		@cmmDlogAddComment := GetProcAddress(FDLLInstance, 'cmmDlogAddComment');
		@cmmDlogGetCurLevel := GetProcAddress(FDLLInstance, 'cmmDlogGetCurLevel');
		@cmmDlogGetCurFilePath := GetProcAddress(FDLLInstance, 'cmmDlogGetCurFilePath');
//====================== ERROR HANDLING FUNCTIONS =============================================//
		@cmmErrGetLastCode := GetProcAddress(FDLLInstance, 'cmmErrGetLastCode');
		@cmmErrParseAxis := GetProcAddress(FDLLInstance, 'cmmErrParseAxis');
		@cmmErrParseReason := GetProcAddress(FDLLInstance, 'cmmErrParseReason');
		@cmmErrGetString := GetProcAddress(FDLLInstance, 'cmmErrGetString');
		@cmmErrShowLast := GetProcAddress(FDLLInstance, 'cmmErrShowLast');
		@cmmErrSetSkipShowMessage := GetProcAddress(FDLLInstance, 'cmmErrSetSkipShowMessage');
		@cmmErrGetSkipShowMessage := GetProcAddress(FDLLInstance, 'cmmErrGetSkipShowMessage');
		@cmmErrSetEnableAutoMessage := GetProcAddress(FDLLInstance, 'cmmErrSetEnableAutoMessage');
		@cmmErrGetEnableAutoMessage := GetProcAddress(FDLLInstance, 'cmmErrGetEnableAutoMessage');
//====================== Utility FUNCTIONS ===================================================//
		@cmmUtlProcessWndMsgS := GetProcAddress(FDLLInstance, 'cmmUtlProcessWndMsgS');
		@cmmUtlProcessWndMsgM := GetProcAddress(FDLLInstance, 'cmmUtlProcessWndMsgM');
		@cmmUtlReadUserTable := GetProcAddress(FDLLInstance, 'cmmUtlReadUserTable');
		@cmmUtlWriteUserTable := GetProcAddress(FDLLInstance, 'cmmUtlWriteUserTable');
		@cmmUtlDelayMicroSec := GetProcAddress(FDLLInstance, 'cmmUtlDelayMicroSec');


	end
end;

procedure UnloadDll;
begin
	if not FreeLibrary(FDLLInstance) then exit;
end;

Initialization

begin
	LoadDll;

end;

Finalization
	UnloadDll;
end.
