// --------------------------------------------------------------
//            Copyright (C) 2000-2008 COMIZOA Co., LTD.          
// --------------------------------------------------------------

// DATE	: 2009-02-24
// TIME	: 11:11:11

unit CNETSDK;

interface

uses
	Windows,
	Messages,
	SysUtils,
	Classes,
	Graphics,
	Controls,
	Forms,
	Dialogs;

const
//******************************************************************************
//* [ ComiNETSDKDef.h ]
//* Header file for definitions of constants and data in CMNSDK library
//* - Update Data: 2007/04/23
//* - Provider: COMIZOA Co., Ltd.
//* - Phone: +82-42-936-6500~6
//* - Fax  : +82-42-936-6507
//* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
//*******************************************************************************

	//*******************************************************************************

	VERSION_STRING_LENGTH = 	21+1;

	VERSION_STRING = 	'C-NET Library 3.0';

	//////////////////////////////////////////////////////////////////////////

	cmnERR_NONE = 	0;

	cmnERR_INVALID_PARAMETER = 	-190;

	cmnERR_MEM_ALLOC_FAIL = 	-290;

	cmnERR_GLOBAL_MEM_FAIL = 	-292;

	//////////////////////////////////////////////////////////////////////////

	cmnTRUE = 	1;

	cmnFALSE = 	0;

	//////////////////////////////////////////////////////////////////////////

	cmnERR_GN_RELOAD_DEVICE_FAIL = 	-9000;

	cmnERR_GN_LOAD_DEVICE_FAIL = 	-10000;

	cmnERR_GN_UNLOAD_DEVICE_FAIL = 	-10001;

	cmnERR_GET_SLAVE_INFO_FAIL = 	-10002;

	cmnERR_GET_SLAVE_INFO_ALL_FAIL = 	-10003;

	cmnERR_GET_GLOBAL_CHANNEL_MAP_FAIL = 	-10004;

	cmnERR_GN_GET_GLOBAL_CHANNEL_MAP_FAIL = 	-10005;

	cmnERR_GN_PUT_USER_CHANNEL_MAP_FAIL = 	-10006;

	cmnERR_GN_DLG_SETUP_FAIL = 	-10007;

	cmnERR_LOCAL_DI_GET_ONE_FAIL = 	-10008;

	cmnERR_LOCAL_DI_GET_MULTI_FAIL = 	-10009;

	cmnERR_LOCAL_DO_PUT_ONE_FAIL = 	-10010;

	cmnERR_LOCAL_DO_PUT_MULTI_FAIL = 	-10011;

	cmnERR_LOCAL_DO_GET_ONE_FAIL = 	-10012;

	cmnERR_LOCAL_DO_GET_MULTI_FAIL = 	-10013;

	cmnERR_DI_GET_ONE_FAIL = 	-10014;

	cmnERR_DI_GET_MULTI_FAIL = 	-10015;

	cmnERR_DO_PUT_ONE_FAIL = 	-10016;

	cmnERR_DO_PUT_MULTI_FAIL = 	-10017;

	cmnERR_DO_GET_ONE_FAIL = 	-10018;

	cmnERR_DO_GET_MULTI_FAIL = 	-10019;

	cmnERR_GN_START_RING_ALL_FAIL = 	-10020;

	cmnERR_GN_START_RING_FAIL = 	-10021;

	cmnERR_GN_RESET_RING_FAIL = 	-10022;

	cmnERR_GN_STOP_RING_FAIL = 	-10023;

	cmnERR_GN_RESET_DEVICE_FAIL = 	-10024;

	cmnERR_GN_ISRESET_DEVICE_FAIL = 	-10025;

	cmnERR_GN_GET_COM_STATUS_FAIL = 	-10026;

	cmmERR_GN_GET_COM_SPEED_FAIL = 	-10027;

	cmnERR_GN_SET_COM_SPEED = 	-10028;

	cmnERR_GN_DLG_GET_LAST_MESSAGE_FAIL = 	-10029;

	cmnERR_GN_DLG_GET_NO_MORE_MESSAGE_FAIL = 	-10030;

	cmnERR_GN_DLG_GET_BUFFER_SMALL_FAIL = 	-10031;

	//////////////////////////////////////////////////////////////////////////

	cmnLOGIC_A = 	0;

	cmnLOGIC_B = 	1;

	//////////////////////////////////////////////////////////////////////////

	// Device Information

	//////////////////////////////////////////////////////////////////////////

	DI_00_DO_32C = 	$0;

	DI_08_DO_08C = 	$1;

	DI_16_DO_16C = 	$2;

	DI_16_DO_OOH = 	$3;

	DI_32_DO_00C = 	$4;

	DI_08_DO_08H = 	DI_08_DO_08C;

	DI_00_DO_16H = 	$5;

	//////////////////////////////////////////////////////////////////////////

	// Communication Speed

	//////////////////////////////////////////////////////////////////////////

	SPEED_1X = 	$0;	
	// 2.5Mbps 

	SPEED_2X = 	$1;	
	// 5Mbps 

	SPEED_3X = 	$2;	
	// 10Mbps 

	SPEED_4X = 	$3;	
	// 20Mbps 

	//////////////////////////////////////////////////////////////////////////

	// Communication Status

	//////////////////////////////////////////////////////////////////////////

	RING_DISCONNECTED = 	13;

	RING_CONNECTED = 	12;

	SLAVE_ERROR = 	3;

	RING_STOP = 	2;

	//////////////////////////////////////////////////////////////////////////

	// Debugging

	//////////////////////////////////////////////////////////////////////////

	DEBUG_LEVEL_SUMMERY = 	0;

	DEBUG_LEVEL_DETAIL = 	1;

	DEBUG_LEVEL_DEBUG = 	2;

	DEBUG_LEVEL_ALL = 	3;

	DEBUG_DISABLE = 	0;

	DEBUG_ENABLE = 	1;

	DEBUG_OUT_WINDOW = 	0;

	DEBUG_OUT_LOCALFILE = 	1;

	DEBUG_OUT_CONSOLE = 	2;

	DEBUG_OUT_SOCKET = 	3;

	DEBUG_OUT_CALLBACK = 	4;

	//////////////////////////////////////////////////////////////////////////

	//  Master ġ    ü̴.

	//////////////////////////////////////////////////////////////////////////

	MAX_SLAVE = 	64;

	MAX_RING = 	2;

	//////////////////////////////////////////////////////////////////////////

	//  Slave IP   ü̴.

	//////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////

	// 1   Slave IP   ü̴.

	//////////////////////////////////////////////////////////////////////////
/	/////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////

	// User Mapped Channel  Global Channel  ϴ ü

	//////////////////////////////////////////////////////////////////////////

	//  

	//////////////////////////////////////////////////////////////////////////
/	/////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////

	// Ʒ ü nTotalSlaveDevice ŭ Ͽ ϵȴ.

	//////////////////////////////////////////////////////////////////////////
/	/////////////////////////////////////////////////////////////////////////

type
// * [ ComiNETSDK.h ]
// * Header file for definitions of constants and data in CMNSDK library
// * - Update Data: 2007/04/23
// * - Provider: COMIZOA Co., Ltd.
// * - Phone: +82-42-936-6500~6
// * - Fax  : +82-42-936-6507
// * - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
	//////////////////////////////////////////////////////////////////////////
	// Debug Handler Function Definition
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	// External Functions for DLL(Dynamic Link Library)
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	// Device Load / Unload
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_LoadDevice	= function (IsResetDevice : LongInt; nTotalMasterDevices : PLongInt) : LongInt; stdcall;
	TCMN_Gn_ReloadDevice	= function (IsResetDevice : LongInt; nTotalMasterDevices : PLongInt) : LongInt; stdcall;
	TCMN_Gn_CtrlBoost	= function (IsEnable : LongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Basic Control
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_IsResetDevice	= function (nDeviceNo : LongInt; nRingNo : LongInt; IsReset : PLongInt) : LongInt; stdcall;
	TCMN_Gn_ResetDevice	= function (nDeviceNo : LongInt; nRingNo : LongInt) : LongInt; stdcall;
	TCMN_Gn_SetSearchSpeicalDelay	= function (nDeviceNo : LongInt; nDelay_us : LongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Debug Function
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_DlgSetup	= function (IsEnable : BOOL; nLevel : Double; nDebugType : Double; Handler : THandle; lParam : THandle; szDebugFileName : PChar) : LongInt; stdcall;
	TCMN_Gn_DlgGetLastMessage	= function (nBufferSize : LongInt; szBuffer : PChar; StoredMsg : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// C-NET Communcation internal  (MASTER)
	//////////////////////////////////////////////////////////////////////////
	TCMN_Local_DiSetInputLogic	= function (GlobalChNo : LongInt; InputLogic : LongInt) : LongInt; stdcall;
	TCMN_Local_DiGetInputLogic	= function (GlobalChNo : LongInt; InputLogic : PLongInt) : LongInt; stdcall;
	TCMN_Local_DoSetOutputLogic	= function (GlobalChNo : LongInt; OutputLogic : LongInt) : LongInt; stdcall;
	TCMN_Local_DoGetOutputLogic	= function (GlobalChNo : LongInt; OutputLogic : PLongInt) : LongInt; stdcall;
	TCMN_Local_DiGetOne	= function (GlobalChNo : LongInt; InputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Local_DiGetMulti	= function (IniChannel : LongInt; NumChannel : LongInt; InuptStates : PLongInt) : LongInt; stdcall;
	TCMN_Local_DoPutOne	= function (GlobalChNo : LongInt; OutState : LongInt) : LongInt; stdcall;
	TCMN_Local_DoPutMulti	= function (IniChannel : LongInt; NumChannel : LongInt; OutStates : LongInt) : LongInt; stdcall;
	TCMN_Local_DoGetOne	= function (GlobalChNo : LongInt; OutputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Local_DoGetMulti	= function (IniChannel : LongInt; NumChannel : LongInt; OutStates : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// C-NET Communication between slave and master  (SLAVE)
	//////////////////////////////////////////////////////////////////////////
	TCMN_Di_SetInputLogic	= function (GlobalChNo : LongInt; InputLogic : LongInt) : LongInt; stdcall;
	TCMN_Di_GetInputLogic	= function (GlobalChNo : LongInt; InputLogic : PLongInt) : LongInt; stdcall;
	TCMN_Do_SetOutputLogic	= function (GlobalChNo : LongInt; OutputLogic : LongInt) : LongInt; stdcall;
	TCMN_Do_GetOutputLogic	= function (GlobalChNo : LongInt; OutputLogic : PLongInt) : LongInt; stdcall;
	TCMN_Di_GetOne	= function (GlobalChNo : LongInt; InputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Di_GetMulti	= function (IniChannel : LongInt; nChannels : LongInt; InputStates : PLongInt) : LongInt; stdcall;
	TCMN_Do_PutOne	= function (GlobalChNo : LongInt; OutState : LongInt) : LongInt; stdcall;
	TCMN_Do_PutMulti	= function (IniChannel : LongInt; nChannels : LongInt; OutStates : LongInt) : LongInt; stdcall;
	TCMN_Do_GetOne	= function (GlobalChNo : LongInt; OutputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Do_GetMulti	= function (IniChannel : LongInt; nChannels : LongInt; OutStates : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// C-NET Communication between slave and master  (SLAVE) (EX Functions)
	//////////////////////////////////////////////////////////////////////////
	TCMN_Di_GetOneEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; nChannelNo : LongInt; InputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Di_GetMultiEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; InputStatus : PLongInt) : LongInt; stdcall;
	TCMN_Do_PutOneEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; nChannel : LongInt; OutState : LongInt) : LongInt; stdcall;
	TCMN_Do_PutMultiEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; OutStates : LongInt) : LongInt; stdcall;
	TCMN_Do_GetOneEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; nChannelNo : LongInt; OutState : PLongInt) : LongInt; stdcall;
	TCMN_Do_GetMultiEx	= function (nMasterCardNo : LongInt; nRingNo : LongInt; nDevIp : LongInt; nPortNo : LongInt; OutStates : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Communication Control
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_StartRingAll	= function () : LongInt; stdcall;
	TCMN_Gn_StartRing	= function (nDeviceNo : LongInt; nRingNo : LongInt; nSlaveIp : LongInt) : LongInt; stdcall;
	TCMN_Gn_ResetRing	= function (nDeviceNo : LongInt; nRingNo : LongInt) : LongInt; stdcall;
	TCMN_Gn_StopRing	= function (nDeviceNo : LongInt; nRingNo : LongInt) : LongInt; stdcall;
	TCMN_Gn_GetComStatus	= function (nDeviceNo : LongInt; nRingNo : LongInt; nStatus : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Communication Speed Control
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetComSpeed	= function (nDeviceNo : LongInt; nRingNo : LongInt; pStatus : PLongInt) : LongInt; stdcall;
	TCMN_Gn_SetComSpeed	= function (nDeviceNo : LongInt; nRingNo : LongInt; nStatus : LongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// General Device Information Functions
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetMasterTotal	= function (pTotalDeviceNum : PLongInt) : LongInt; stdcall;
	TCMN_Gn_GetSlaveTotal	= function (pTotalDeviceNum : PLongInt) : LongInt; stdcall;
	TCMN_Gn_GetDITotal	= function (pTotalDiChannelNum : PLongInt) : LongInt; stdcall;
	TCMN_Gn_GetDOTotal	= function (pTotalDOChannelNum : PLongInt) : LongInt; stdcall;
	// ش ̽    ȯѴ.
	TCMN_Gn_GetRingTotal	= function (nDeviceNo : LongInt; pRingTotal : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Master Device Information Functions
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetMasterInfo	= function (nDeviceNo : LongInt; pDeviceId : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Slave Device Information Functions
	//////////////////////////////////////////////////////////////////////////
	//TCMN_Gn_GetSlaveInfoAll	= function (nDeviceNo : LongInt; Info : (null); DevInfo : (null); pRing0SlaveTotal : PLongInt; pRing1SlaveTotal : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Set/Get of Error Communication Slave Device Number
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetSlaveComError	= function (nDeviceNo : LongInt; nRingNo : LongInt; pStatus1 : PLongInt; pStatus2 : PLongInt) : LongInt; stdcall;
	TCMN_Gn_ClrSlaveComError	= function (nDeviceNo : LongInt; nRingNo : LongInt; nStatus1 : LongInt; nStatus2 : LongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// Interrupt Functions
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetMasterInterruptStatus	= function (nDeviceNo : LongInt; nRingNo : LongInt; pStatus : PLongInt) : LongInt; stdcall;
	TCMN_Gn_SetInputInterruptEnable	= function (nDeviceNo : LongInt; nRingNo : LongInt; pStatus1 : PLongInt; pStatus2 : PLongInt) : LongInt; stdcall;
	TCMN_Gn_GetInputInterruptStatus	= function (nDeviceNo : LongInt; nRingNo : LongInt; pStatus1 : PLongInt; pStatus2 : PLongInt) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////
	// User Mapped Channel And Global Channel
	//////////////////////////////////////////////////////////////////////////
	TCMN_Gn_GetGlobalChannelMap	= function (szFileName : PChar) : LongInt; stdcall;
	TCMN_Gn_PutUserChannelMap	= function (szFileName : PChar) : LongInt; stdcall;
	//////////////////////////////////////////////////////////////////////////

	var

	cmnGnLoadDevice : TCMN_Gn_LoadDevice;
	cmnGnReloadDevice : TCMN_Gn_ReloadDevice;
	cmnGnCtrlBoost : TCMN_Gn_CtrlBoost;
	cmnGnIsResetDevice : TCMN_Gn_IsResetDevice;
	cmnGnResetDevice : TCMN_Gn_ResetDevice;
	cmnGnSetSearchSpeicalDelay : TCMN_Gn_SetSearchSpeicalDelay;
	cmnGnDlgSetup : TCMN_Gn_DlgSetup;
	cmnGnDlgGetLastMessage : TCMN_Gn_DlgGetLastMessage;
	cmnLocalDiSetInputLogic : TCMN_Local_DiSetInputLogic;
	cmnLocalDiGetInputLogic : TCMN_Local_DiGetInputLogic;
	cmnLocalDoSetOutputLogic : TCMN_Local_DoSetOutputLogic;
	cmnLocalDoGetOutputLogic : TCMN_Local_DoGetOutputLogic;
	cmnLocalDiGetOne : TCMN_Local_DiGetOne;
	cmnLocalDiGetMulti : TCMN_Local_DiGetMulti;
	cmnLocalDoPutOne : TCMN_Local_DoPutOne;
	cmnLocalDoPutMulti : TCMN_Local_DoPutMulti;
	cmnLocalDoGetOne : TCMN_Local_DoGetOne;
	cmnLocalDoGetMulti : TCMN_Local_DoGetMulti;
	cmnDiSetInputLogic : TCMN_Di_SetInputLogic;
	cmnDiGetInputLogic : TCMN_Di_GetInputLogic;
	cmnDoSetOutputLogic : TCMN_Do_SetOutputLogic;
	cmnDoGetOutputLogic : TCMN_Do_GetOutputLogic;
	cmnDiGetOne : TCMN_Di_GetOne;
	cmnDiGetMulti : TCMN_Di_GetMulti;
	cmnDoPutOne : TCMN_Do_PutOne;
	cmnDoPutMulti : TCMN_Do_PutMulti;
	cmnDoGetOne : TCMN_Do_GetOne;
	cmnDoGetMulti : TCMN_Do_GetMulti;
	cmnDiGetOneEx : TCMN_Di_GetOneEx;
	cmnDiGetMultiEx : TCMN_Di_GetMultiEx;
	cmnDoPutOneEx : TCMN_Do_PutOneEx;
	cmnDoPutMultiEx : TCMN_Do_PutMultiEx;
	cmnDoGetOneEx : TCMN_Do_GetOneEx;
	cmnDoGetMultiEx : TCMN_Do_GetMultiEx;
	cmnGnStartRingAll : TCMN_Gn_StartRingAll;
	cmnGnStartRing : TCMN_Gn_StartRing;
	cmnGnResetRing : TCMN_Gn_ResetRing;
	cmnGnStopRing : TCMN_Gn_StopRing;
	cmnGnGetComStatus : TCMN_Gn_GetComStatus;
	cmnGnGetComSpeed : TCMN_Gn_GetComSpeed;
	cmnGnSetComSpeed : TCMN_Gn_SetComSpeed;
	cmnGnGetMasterTotal : TCMN_Gn_GetMasterTotal;
	cmnGnGetSlaveTotal : TCMN_Gn_GetSlaveTotal;
	cmnGnGetDITotal : TCMN_Gn_GetDITotal;
	cmnGnGetDOTotal : TCMN_Gn_GetDOTotal;
	cmnGnGetRingTotal : TCMN_Gn_GetRingTotal;
	cmnGnGetMasterInfo : TCMN_Gn_GetMasterInfo;
	//cmnGnGetSlaveInfoAll : TCMN_Gn_GetSlaveInfoAll;
	cmnGnGetSlaveComError : TCMN_Gn_GetSlaveComError;
	cmnGnClrSlaveComError : TCMN_Gn_ClrSlaveComError;
	cmnGnGetMasterInterruptStatus : TCMN_Gn_GetMasterInterruptStatus;
	cmnGnSetInputInterruptEnable : TCMN_Gn_SetInputInterruptEnable;
	cmnGnGetInputInterruptStatus : TCMN_Gn_GetInputInterruptStatus;
	cmnGnGetGlobalChannelMap : TCMN_Gn_GetGlobalChannelMap;
	cmnGnPutUserChannelMap : TCMN_Gn_PutUserChannelMap;


	FDLLInstance : THandle;

procedure LoadDll;
procedure UnloadDll;

implementation

{ TComiDaq }

Const
LIBRARY_FILENAME : AnsiString = 'CNETSDK.dll';

procedure LoadDll;
var
	LibraryFilename : AnsiString;
	// FDLLPath : string;

begin
	LibraryFilename := LIBRARY_FILENAME;
	FDLLInstance := LoadLibrary(PChar(LibraryFileName));

	if ( FDLLInstance <> 0 ) then
	begin

		@cmnGnLoadDevice := GetProcAddress(FDLLInstance, 'cmnGnLoadDevice');
		@cmnGnReloadDevice := GetProcAddress(FDLLInstance, 'cmnGnReloadDevice');
		@cmnGnCtrlBoost := GetProcAddress(FDLLInstance, 'cmnGnCtrlBoost');
		@cmnGnIsResetDevice := GetProcAddress(FDLLInstance, 'cmnGnIsResetDevice');
		@cmnGnResetDevice := GetProcAddress(FDLLInstance, 'cmnGnResetDevice');
		@cmnGnSetSearchSpeicalDelay := GetProcAddress(FDLLInstance, 'cmnGnSetSearchSpeicalDelay');
		@cmnGnDlgSetup := GetProcAddress(FDLLInstance, 'cmnGnDlgSetup');
		@cmnGnDlgGetLastMessage := GetProcAddress(FDLLInstance, 'cmnGnDlgGetLastMessage');
		@cmnLocalDiSetInputLogic := GetProcAddress(FDLLInstance, 'cmnLocalDiSetInputLogic');
		@cmnLocalDiGetInputLogic := GetProcAddress(FDLLInstance, 'cmnLocalDiGetInputLogic');
		@cmnLocalDoSetOutputLogic := GetProcAddress(FDLLInstance, 'cmnLocalDoSetOutputLogic');
		@cmnLocalDoGetOutputLogic := GetProcAddress(FDLLInstance, 'cmnLocalDoGetOutputLogic');
		@cmnLocalDiGetOne := GetProcAddress(FDLLInstance, 'cmnLocalDiGetOne');
		@cmnLocalDiGetMulti := GetProcAddress(FDLLInstance, 'cmnLocalDiGetMulti');
		@cmnLocalDoPutOne := GetProcAddress(FDLLInstance, 'cmnLocalDoPutOne');
		@cmnLocalDoPutMulti := GetProcAddress(FDLLInstance, 'cmnLocalDoPutMulti');
		@cmnLocalDoGetOne := GetProcAddress(FDLLInstance, 'cmnLocalDoGetOne');
		@cmnLocalDoGetMulti := GetProcAddress(FDLLInstance, 'cmnLocalDoGetMulti');
		@cmnDiSetInputLogic := GetProcAddress(FDLLInstance, 'cmnDiSetInputLogic');
		@cmnDiGetInputLogic := GetProcAddress(FDLLInstance, 'cmnDiGetInputLogic');
		@cmnDoSetOutputLogic := GetProcAddress(FDLLInstance, 'cmnDoSetOutputLogic');
		@cmnDoGetOutputLogic := GetProcAddress(FDLLInstance, 'cmnDoGetOutputLogic');
		@cmnDiGetOne := GetProcAddress(FDLLInstance, 'cmnDiGetOne');
		@cmnDiGetMulti := GetProcAddress(FDLLInstance, 'cmnDiGetMulti');
		@cmnDoPutOne := GetProcAddress(FDLLInstance, 'cmnDoPutOne');
		@cmnDoPutMulti := GetProcAddress(FDLLInstance, 'cmnDoPutMulti');
		@cmnDoGetOne := GetProcAddress(FDLLInstance, 'cmnDoGetOne');
		@cmnDoGetMulti := GetProcAddress(FDLLInstance, 'cmnDoGetMulti');
		@cmnDiGetOneEx := GetProcAddress(FDLLInstance, 'cmnDiGetOneEx');
		@cmnDiGetMultiEx := GetProcAddress(FDLLInstance, 'cmnDiGetMultiEx');
		@cmnDoPutOneEx := GetProcAddress(FDLLInstance, 'cmnDoPutOneEx');
		@cmnDoPutMultiEx := GetProcAddress(FDLLInstance, 'cmnDoPutMultiEx');
		@cmnDoGetOneEx := GetProcAddress(FDLLInstance, 'cmnDoGetOneEx');
		@cmnDoGetMultiEx := GetProcAddress(FDLLInstance, 'cmnDoGetMultiEx');
		@cmnGnStartRingAll := GetProcAddress(FDLLInstance, 'cmnGnStartRingAll');
		@cmnGnStartRing := GetProcAddress(FDLLInstance, 'cmnGnStartRing');
		@cmnGnResetRing := GetProcAddress(FDLLInstance, 'cmnGnResetRing');
		@cmnGnStopRing := GetProcAddress(FDLLInstance, 'cmnGnStopRing');
		@cmnGnGetComStatus := GetProcAddress(FDLLInstance, 'cmnGnGetComStatus');
		@cmnGnGetComSpeed := GetProcAddress(FDLLInstance, 'cmnGnGetComSpeed');
		@cmnGnSetComSpeed := GetProcAddress(FDLLInstance, 'cmnGnSetComSpeed');
		@cmnGnGetMasterTotal := GetProcAddress(FDLLInstance, 'cmnGnGetMasterTotal');
		@cmnGnGetSlaveTotal := GetProcAddress(FDLLInstance, 'cmnGnGetSlaveTotal');
		@cmnGnGetDITotal := GetProcAddress(FDLLInstance, 'cmnGnGetDITotal');
		@cmnGnGetDOTotal := GetProcAddress(FDLLInstance, 'cmnGnGetDOTotal');
		@cmnGnGetRingTotal := GetProcAddress(FDLLInstance, 'cmnGnGetRingTotal');
		@cmnGnGetMasterInfo := GetProcAddress(FDLLInstance, 'cmnGnGetMasterInfo');
		//@cmnGnGetSlaveInfoAll := GetProcAddress(FDLLInstance, 'cmnGnGetSlaveInfoAll');
		@cmnGnGetSlaveComError := GetProcAddress(FDLLInstance, 'cmnGnGetSlaveComError');
		@cmnGnClrSlaveComError := GetProcAddress(FDLLInstance, 'cmnGnClrSlaveComError');
		@cmnGnGetMasterInterruptStatus := GetProcAddress(FDLLInstance, 'cmnGnGetMasterInterruptStatus');
		@cmnGnSetInputInterruptEnable := GetProcAddress(FDLLInstance, 'cmnGnSetInputInterruptEnable');
		@cmnGnGetInputInterruptStatus := GetProcAddress(FDLLInstance, 'cmnGnGetInputInterruptStatus');
		@cmnGnGetGlobalChannelMap := GetProcAddress(FDLLInstance, 'cmnGnGetGlobalChannelMap');
		@cmnGnPutUserChannelMap := GetProcAddress(FDLLInstance, 'cmnGnPutUserChannelMap');


	end
end;

procedure UnloadDll;
begin
	if not FreeLibrary(FDLLInstance) then exit;
end;

Initialization

begin
	LoadDll;

end;

Finalization
	UnloadDll;
end.
