/*******************************************************************************
* [ ComiNETSDK.cpp ]
* CPP file for definitions of constants and data in CNETSDK library
* - Update Data: 2014/06/19
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
********************************************************************************/

#include "stdafx.h"

#if defined(__BCPLUSPLUS__)  // Borland C++ Builder specific
 #include <vcl.h>
 #pragma hdrstop
#endif

#include <windows.h>
#include <stdio.h>

#define _DLL_MAIN_CPP_
#include "CNETSDK.h"

#define __DLL_FILE_FULL_PATH__ "CNETSDK.DLL"

typedef struct _tagLIB_FUNCT {
	char *name;
	FARPROC* ptr;
}LIB_FUNCT;

static HINSTANCE hLibrary=NULL;

BOOL CNETLoadDll(void)
{
	LIB_FUNCT Func[] = {

		//////////////////////////////////////////////////////////////////////////
		// Device Load / Unload
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnLoadDevice", 	(FARPROC*)&cmnGnLoadDevice},
		{"cmnGnUnloadDevice", 	(FARPROC*)&cmnGnUnloadDevice},
		{"cmnGnReloadDevice",   (FARPROC*)&cmnGnReloadDevice},

		//////////////////////////////////////////////////////////////////////////
		// Debug Function
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnDlgSetup",		(FARPROC*)&cmnGnDlgSetup},
		{"cmnGnDlgGetLastMessage",	(FARPROC*)&cmnGnDlgGetLastMessage},

		//////////////////////////////////////////////////////////////////////////
		// Basic Control
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnResetDevice",(FARPROC*)&cmnGnResetDevice},
		{"cmnGnIsResetDevice",(FARPROC*)&cmnGnIsResetDevice},
		{"cmnGnSetSearchSpeicalDelay",(FARPROC*)&cmnGnSetSearchSpeicalDelay},

		//////////////////////////////////////////////////////////////////////////
		// Channel Input / Output Logic 
		//////////////////////////////////////////////////////////////////////////
		{"cmnLocalDiSetInputLogic", (FARPROC*)&cmnLocalDiSetInputLogic},
		{"cmnLocalDiGetInputLogic", (FARPROC*)&cmnLocalDiGetInputLogic},
		{"cmnLocalDoSetOutputLogic",(FARPROC*)&cmnLocalDoSetOutputLogic},
		{"cmnLocalDoGetOutputLogic",(FARPROC*)&cmnLocalDoGetOutputLogic},

		{"cmnDiSetInputLogic", (FARPROC*)&cmnDiSetInputLogic},
		{"cmnDiGetInputLogic", (FARPROC*)&cmnDiGetInputLogic},
		{"cmnDoSetOutputLogic",(FARPROC*)&cmnDoSetOutputLogic},
		{"cmnDoGetOutputLogic",(FARPROC*)&cmnDoGetOutputLogic},

		//////////////////////////////////////////////////////////////////////////
		// Channel Operation
		//////////////////////////////////////////////////////////////////////////
		{"cmnLocalDiGetOne", (FARPROC*)&cmnLocalDiGetOne},
		{"cmnLocalDiGetMulti", (FARPROC*)&cmnLocalDiGetMulti},
		{"cmnLocalDoPutOne", (FARPROC *)&cmnLocalDoPutOne},
		{"cmnLocalDoPutMulti", (FARPROC*) &cmnLocalDoPutMulti},
		{"cmnLocalDoGetOne", (FARPROC *) &cmnLocalDoGetOne},
		{"cmnLocalDoGetMulti", (FARPROC*) &cmnLocalDoGetMulti},

		{"cmnDiGetOne", (FARPROC*)&cmnDiGetOne},
		{"cmnDiGetMulti", (FARPROC*)&cmnDiGetMulti},
		{"cmnDoPutOne", (FARPROC*)&cmnDoPutOne},
		{"cmnDoPutMulti",(FARPROC*)&cmnDoPutMulti},
		{"cmnDoGetOne",(FARPROC*)&cmnDoGetOne},
		{"cmnDoGetMulti",(FARPROC*)&cmnDoGetMulti},

		{"cmnDiGetOneEx", (FARPROC*)&cmnDiGetOneEx},
		{"cmnDiGetMultiEx", (FARPROC*)&cmnDiGetMultiEx},
		{"cmnDoPutOneEx", (FARPROC*)&cmnDoPutOneEx},
		{"cmnDoPutMultiEx",(FARPROC*)&cmnDoPutMultiEx},
		{"cmnDoGetOneEx",(FARPROC*)&cmnDoGetOneEx},
		{"cmnDoGetMultiEx",(FARPROC*)&cmnDoGetMultiEx},

		{"cmnDioExchange_Scan", (FARPROC*)&cmnDioExchange_Scan},
		{"cmnDioExchange_Run", (FARPROC*)&cmnDioExchange_Run},
		
		//////////////////////////////////////////////////////////////////////////
		// General Device Information Functions
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetMasterTotal",(FARPROC*)&cmnGnGetMasterTotal},
		{"cmnGnGetSlaveTotal",(FARPROC*)&cmnGnGetSlaveTotal},
		{"cmnGnGetDITotal",(FARPROC*)&cmnGnGetDITotal},
		{"cmnGnGetDOTotal",(FARPROC*)&cmnGnGetDOTotal},
		{"cmnGnGetRingTotal",(FARPROC*)&cmnGnGetRingTotal},

		//////////////////////////////////////////////////////////////////////////
		// Master Information 
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetMasterInfo",(FARPROC*)&cmnGnGetMasterInfo},

		//////////////////////////////////////////////////////////////////////////
		// Slave Information
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetSlaveInfoAll",(FARPROC*)&cmnGnGetSlaveInfoAll},

		//////////////////////////////////////////////////////////////////////////
		// Communication Control
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetComStatus",               (FARPROC*)&cmnGnGetComStatus},
		{"cmnGnStartRingAll",               (FARPROC*)&cmnGnStartRingAll},
		{"cmnGnStartRing",                  (FARPROC*)&cmnGnStartRing},
		{"cmnGnResetRing",                  (FARPROC*)&cmnGnResetRing},
		{"cmnGnStopRing",                   (FARPROC*)&cmnGnStopRing},

		//////////////////////////////////////////////////////////////////////////
		// Communication Speed Control
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetComSpeed",                (FARPROC*)&cmnGnGetComSpeed},
		{"cmnGnSetComSpeed",                (FARPROC*)&cmnGnSetComSpeed},

		//////////////////////////////////////////////////////////////////////////
		// User Mapped Channel And Global Channel
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetGlobalChannelMap",        (FARPROC*)&cmnGnGetGlobalChannelMap},
		{"cmnGnPutUserChannelMap",          (FARPROC*)&cmnGnPutUserChannelMap},

		//////////////////////////////////////////////////////////////////////////
		// Interrupt Functions
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetMasterInterruptStatus",   (FARPROC*)&cmnGnGetMasterInterruptStatus},
		{"cmnGnSetInputInterruptEnable",    (FARPROC*)&cmnGnSetInputInterruptEnable},
		{"cmnGnGetInputInterruptStatus",    (FARPROC*)&cmnGnGetInputInterruptStatus},


		//////////////////////////////////////////////////////////////////////////
		// Slave Communication Error
		//////////////////////////////////////////////////////////////////////////
		{"cmnGnGetSlaveComError",           (FARPROC*)&cmnGnGetSlaveComError},
		{"cmnGnClrSlaveComError",           (FARPROC*)&cmnGnClrSlaveComError},

		{"cmnGnGetAITotal",					(FARPROC*)&cmnGnGetAITotal},
		{"cmnGnGetAOTotal",					(FARPROC*)&cmnGnGetAOTotal},

		{"cmnAiSetVoltRangeMode",			(FARPROC*)&cmnAiSetVoltRangeMode},
		{"cmnAiGetVoltRangeMode",			(FARPROC*)&cmnAiGetVoltRangeMode},
		{"cmnAiGetDigitRange",				(FARPROC*)&cmnAiGetDigitRange},

		{"cmnAiGetDigit",					(FARPROC*)&cmnAiGetDigit},
		{"cmnAiGetVolt",					(FARPROC*)&cmnAiGetVolt},
		{"cmnAiGetCurrent",					(FARPROC*)&cmnAiGetCurrent},

		{"cmnAoSetDigit",					(FARPROC*)&cmnAoSetDigit},
		{"cmnAoSetVolt",					(FARPROC*)&cmnAoSetVolt},
		{"cmnAoSetCurrent",					(FARPROC*)&cmnAoSetCurrent},

		{NULL, NULL}
	};

	LIB_FUNCT *f;

	if((hLibrary = LoadLibrary (__DLL_FILE_FULL_PATH__)) == NULL)
		return FALSE;

	f = &Func[0];
	while(f->ptr != NULL)
	{
		*(f->ptr) = GetProcAddress ((HMODULE)hLibrary, f->name);
		if(*(f->ptr) == NULL){
			OutputDebugString("The ComiNETSDK.DLL load has been failed.");
		}
		f++;
	}
	return TRUE;
}

void CNETUnloadDll(void)
{
	if(hLibrary){
		FreeLibrary(hLibrary);
		hLibrary = NULL;
	}
}

