/*******************************************************************************
* [ ComiNETSDK.h ]
* Header file for definitions of constants and data in CNETSDK library
* - Update Data: 2014/06/19
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
********************************************************************************/

#ifndef __COMINET_SDK_H__
#define __COMINET_SDK_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CNETSDKDef.h"

#if !defined(__in)
#define __in
#endif

#if !defined(__out)
#define __out
#endif

#if !defined(__inout)
#define __inout
#endif

#ifdef __cplusplus
extern "C"{
#endif

#ifdef _DLL_MAIN_CPP_
	#define EXTERN 
#else 
	#define EXTERN extern
#endif

//////////////////////////////////////////////////////////////////////////
// Debug Handler Function Definition
//////////////////////////////////////////////////////////////////////////
typedef void (WINAPI *TDebugHandler) (LPVOID);

//////////////////////////////////////////////////////////////////////////
// External Functions for DLL(Dynamic Link Library)
//////////////////////////////////////////////////////////////////////////
BOOL CNETLoadDll();
VOID CNETUnloadDll();

//////////////////////////////////////////////////////////////////////////
// Device Load / Unload
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnLoadDevice)	 (LONG IsResetDevice, PLONG nTotalMasterDevices);
EXTERN VOID (WINAPI *cmnGnUnloadDevice) ();
EXTERN LONG (WINAPI *cmnGnReloadDevice) (LONG IsResetDevice, PLONG nTotalMasterDevices);

//////////////////////////////////////////////////////////////////////////
// Basic Control
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnIsResetDevice) (__in LONG nDeviceNo, __in LONG nRingNo,__out PLONG IsReset);
EXTERN LONG (WINAPI *cmnGnResetDevice)	  (__in LONG nDeviceNo, __in LONG nRingNo);
EXTERN LONG (WINAPI *cmnGnSetSearchSpeicalDelay) (__in LONG nDeviceNo, __in LONG nDelay_us);

//////////////////////////////////////////////////////////////////////////
// Debug Function
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnDlgSetup)	      (__in BOOL IsEnable,    __out DWORD nLevel,   __in DWORD nDebugType, __in HANDLE Handler, __in LPVOID lParam, __in PCHAR szDebugFileName);	
EXTERN LONG (WINAPI *cmnGnDlgGetLastMessage) (__in LONG nBufferSize, __out PCHAR szBuffer, __out PLONG StoredMsg);

//////////////////////////////////////////////////////////////////////////
// C-NET Communcation internal  (MASTER)
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnLocalDiSetInputLogic)	(__in LONG GlobalChNo, __in LONG InputLogic);
EXTERN LONG (WINAPI *cmnLocalDiGetInputLogic)	(__in LONG GlobalChNo, __out PLONG InputLogic);
EXTERN LONG (WINAPI *cmnLocalDoSetOutputLogic)	(__in LONG GlobalChNo, __in LONG OutputLogic);
EXTERN LONG (WINAPI *cmnLocalDoGetOutputLogic)	(__in LONG GlobalChNo, __in PLONG OutputLogic);

EXTERN LONG (WINAPI *cmnLocalDiGetOne)		(__in LONG GlobalChNo,__out PLONG InputStatus /* T or F */);
EXTERN LONG (WINAPI *cmnLocalDiGetMulti)	(__in LONG IniChannel, __in LONG  NumChannel, __out PLONG InuptStates /* Local Input 8ch */);
EXTERN LONG (WINAPI *cmnLocalDoPutOne)		(__in LONG GlobalChNo,__out LONG  OutState /* T or F */);
EXTERN LONG (WINAPI *cmnLocalDoPutMulti)	(__in LONG IniChannel, __in LONG  NumChannel, __out LONG OutStates /* 0xffff */);
EXTERN LONG (WINAPI *cmnLocalDoGetOne)		(__in LONG GlobalChNo,__out PLONG OutputStatus /* T or F */);
EXTERN LONG (WINAPI *cmnLocalDoGetMulti)	(__in LONG IniChannel, __in LONG  NumChannel, __out PLONG OutStates /* 0xffff */);

//////////////////////////////////////////////////////////////////////////
// C-NET Communication between slave and master  (SLAVE)
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnDiSetInputLogic)	(__in LONG GlobalChNo, __in LONG InputLogic);
EXTERN LONG (WINAPI *cmnDiGetInputLogic)	(__in LONG GlobalChNo, __in PLONG InputLogic);
EXTERN LONG (WINAPI *cmnDoSetOutputLogic)	(__in LONG GlobalChNo, __in LONG OutputLogic);
EXTERN LONG (WINAPI *cmnDoGetOutputLogic)	(__in LONG GlobalChNo, __in PLONG OutputLogic);

EXTERN LONG (WINAPI *cmnDiGetOne)	(__in LONG GlobalChNo,  __out PLONG InputStatus /* T or F */);
EXTERN LONG (WINAPI *cmnDiGetMulti)	(__in LONG IniChannel,  __in  LONG  nChannels,   __out PLONG InputStates /* 0xffff */ );
EXTERN LONG (WINAPI *cmnDoPutOne)	(__in LONG GlobalChNo,  __in  LONG  OutState  /* T or F */);
EXTERN LONG (WINAPI *cmnDoPutMulti)	(__in LONG IniChannel,  __in  LONG  nChannels , __in  LONG  OutStates  /* 0xffff */ );
EXTERN LONG (WINAPI *cmnDoGetOne)	(__in LONG GlobalChNo,  __out PLONG OutputStatus/* T or F */);
EXTERN LONG (WINAPI *cmnDoGetMulti)	(__in LONG IniChannel,  __in  LONG  nChannels,  __out PLONG OutStates  /* 0xffff */);

//////////////////////////////////////////////////////////////////////////
// C-NET Communication between slave and master  (SLAVE) (EX Functions)
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnDiGetOneEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __in LONG nChannelNo, __out PLONG InputStatus);
EXTERN LONG (WINAPI *cmnDiGetMultiEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __out PLONG InputStatus);
EXTERN LONG (WINAPI *cmnDoPutOneEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __in LONG nChannel, __in LONG OutState);
EXTERN LONG (WINAPI *cmnDoPutMultiEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __out LONG OutStates);
EXTERN LONG (WINAPI *cmnDoGetOneEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __in LONG nChannelNo, __out PLONG OutState);
EXTERN LONG (WINAPI *cmnDoGetMultiEx)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nDevIp, __in LONG nPortNo, __out PLONG OutStates);

EXTERN LONG (WINAPI *cmnDioExchange_Scan)  (__in LONG nMasterCardNo, __in LONG nRingNo, __inout  TCMNSlaveInfoEx * pSlaveInfoEx, __out PLONG pSlaveCnt);
EXTERN LONG (WINAPI *cmnDioExchange_Run)	(__in LONG nMasterCardNo, __in LONG nRingNo, __in LONG nExchangeMode, __inout  TCMNFastIo * fastIo);

//////////////////////////////////////////////////////////////////////////
// Communication Control
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnStartRingAll) ();
EXTERN LONG (WINAPI *cmnGnStartRing)	 (__in LONG nDeviceNo, __in LONG nRingNo, __in LONG nSlaveIp);
EXTERN LONG (WINAPI *cmnGnResetRing)	 (__in LONG nDeviceNo, __in LONG nRingNo);
EXTERN LONG (WINAPI *cmnGnStopRing)	 (__in LONG nDeviceNo, __in LONG nRingNo);
EXTERN LONG (WINAPI *cmnGnGetComStatus) (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG nStatus);

//////////////////////////////////////////////////////////////////////////
// Communication Speed Control
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetComSpeed) (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG pStatus);
EXTERN LONG (WINAPI *cmnGnSetComSpeed) (__in LONG nDeviceNo, __in LONG nRingNo, __in LONG nStatus);

//////////////////////////////////////////////////////////////////////////
// General Device Information Functions
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetMasterTotal)	  (__out PLONG pTotalDeviceNum);
EXTERN LONG (WINAPI *cmnGnGetSlaveTotal)	  (__out PLONG pTotalDeviceNum);
EXTERN LONG (WINAPI *cmnGnGetDITotal)		  (__out PLONG pTotalDiChannelNum);
EXTERN LONG (WINAPI *cmnGnGetDOTotal)		  (__out PLONG pTotalDOChannelNum);

// ش ̽    ȯѴ.
EXTERN LONG (WINAPI *cmnGnGetRingTotal)      (__in LONG nDeviceNo, __out PLONG pRingTotal);

//////////////////////////////////////////////////////////////////////////
// Master Device Information Functions
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetMasterInfo) (__in LONG nDeviceNo, __out PLONG pDeviceId);

//////////////////////////////////////////////////////////////////////////
// Slave Device Information Functions
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetSlaveInfoAll)(__in LONG nDeviceNo, __out TCMNDevInfo * pDevInfo, __out PLONG pRing0SlaveTotal, __out PLONG pRing1SlaveTotal);

//////////////////////////////////////////////////////////////////////////
// Set/Get of Error Communication Slave Device Number
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetSlaveComError)            (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG pStatus1, __out PLONG pStatus2);
EXTERN LONG (WINAPI *cmnGnClrSlaveComError)            (__in LONG nDeviceNo, __in LONG nRingNo, __in LONG nStatus1, __in LONG nStatus2);

//////////////////////////////////////////////////////////////////////////
// Interrupt Functions
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetMasterInterruptStatus)    (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG pStatus);
EXTERN LONG (WINAPI *cmnGnSetInputInterruptEnable)     (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG pStatus1, __out PLONG pStatus2);
EXTERN LONG (WINAPI *cmnGnGetInputInterruptStatus)     (__in LONG nDeviceNo, __in LONG nRingNo, __out PLONG pStatus1, __out PLONG pStatus2);

//////////////////////////////////////////////////////////////////////////
// User Mapped Channel And Global Channel
//////////////////////////////////////////////////////////////////////////
EXTERN LONG (WINAPI *cmnGnGetGlobalChannelMap) (__in PCHAR szFileName);
EXTERN LONG (WINAPI *cmnGnPutUserChannelMap) (__in PCHAR szFileName);
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// C-NET Analog In & Out Functions  (SLAVE)
//////////////////////////////////////////////////////////////////////////

EXTERN LONG (WINAPI *cmnGnGetAITotal)		  (__out PLONG pTotalAiChannelNum);
EXTERN LONG (WINAPI *cmnGnGetAOTotal)		  (__out PLONG pTotalAOChannelNum);

EXTERN LONG (WINAPI *cmnAiSetVoltRangeMode)	(__in LONG GlobalChNo, __in LONG RangeMode);
EXTERN LONG (WINAPI *cmnAiGetVoltRangeMode)	(__in LONG GlobalChNo, __out PLONG RangeMode);
EXTERN LONG (WINAPI *cmnAiGetDigitRange)		(__in LONG GlobalChNo, __out PLONG DigitMin, __out PLONG DigitMax);

EXTERN LONG (WINAPI *cmnAiGetDigit)	(__in LONG GlobalChNo,  __out PLONG nDigit);
EXTERN LONG (WINAPI *cmnAiGetVolt)		(__in LONG GlobalChNo,  __out DOUBLE *fVolt);
EXTERN LONG (WINAPI *cmnAiGetCurrent)	(__in LONG GlobalChNo,  __out DOUBLE *fCurrent);

EXTERN LONG (WINAPI *cmnAoSetDigit)	(__in LONG GlobalChNo,  __in  LONG  nDigit);
EXTERN LONG (WINAPI *cmnAoSetVolt)		(__in LONG GlobalChNo,  __in  DOUBLE  fVolt);
EXTERN LONG (WINAPI *cmnAoSetCurrent)	(__in LONG GlobalChNo,  __in  DOUBLE  fCurrent);


#ifdef __cplusplus
}
#endif


#endif
