/*******************************************************************************
* [ ComiNETSDKDef.h ]
* Header file for definitions of constants and data in CNETSDK library
* - Update Data: 2014/06/19
* - Provider: COMIZOA Co., Ltd.
* - Phone: +82-42-936-6500~6
* - Fax  : +82-42-936-6507
* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
********************************************************************************/

#ifndef __COMINET_SDK_DEF_H__
#define __COMINET_SDK_DEF_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define VERSION_STRING_LENGTH		21+1
#define VERSION_STRING			"C-NET Library 4.0"

//////////////////////////////////////////////////////////////////////////
#define cmnERR_NONE                        0
#define cmnERR_INVALID_PARAMETER        -190
#define cmnERR_MEM_ALLOC_FAIL           -290
#define cmnERR_GLOBAL_MEM_FAIL          -292

//////////////////////////////////////////////////////////////////////////
#define cmnTRUE							   1
#define cmnFALSE						   0

//////////////////////////////////////////////////////////////////////////
#define cmnERR_GN_RELOAD_DEVICE_FAIL    -9000
#define cmnERR_GN_LOAD_DEVICE_FAIL		-10000
#define cmnERR_GN_UNLOAD_DEVICE_FAIL		-10001 
#define cmnERR_GET_SLAVE_INFO_FAIL		-10002 
#define cmnERR_GET_SLAVE_INFO_ALL_FAIL		-10003 
#define cmnERR_GET_GLOBAL_CHANNEL_MAP_FAIL	-10004 
#define cmnERR_GN_GET_GLOBAL_CHANNEL_MAP_FAIL	-10005 
#define cmnERR_GN_PUT_USER_CHANNEL_MAP_FAIL	-10006 
#define cmnERR_GN_DLG_SETUP_FAIL		-10007 
#define cmnERR_LOCAL_DI_GET_ONE_FAIL		-10008 
#define cmnERR_LOCAL_DI_GET_MULTI_FAIL		-10009
#define cmnERR_LOCAL_DO_PUT_ONE_FAIL		-10010
#define cmnERR_LOCAL_DO_PUT_MULTI_FAIL		-10011 
#define cmnERR_LOCAL_DO_GET_ONE_FAIL		-10012 
#define cmnERR_LOCAL_DO_GET_MULTI_FAIL		-10013 
#define cmnERR_DI_GET_ONE_FAIL		        -10014 
#define cmnERR_DI_GET_MULTI_FAIL		-10015 
#define cmnERR_DO_PUT_ONE_FAIL		        -10016 
#define cmnERR_DO_PUT_MULTI_FAIL		-10017 
#define cmnERR_DO_GET_ONE_FAIL		        -10018 
#define cmnERR_DO_GET_MULTI_FAIL		-10019 
#define cmnERR_GN_START_RING_ALL_FAIL		-10020 
#define cmnERR_GN_START_RING_FAIL		-10021 
#define cmnERR_GN_RESET_RING_FAIL		-10022 
#define cmnERR_GN_STOP_RING_FAIL		-10023 
#define cmnERR_GN_RESET_DEVICE_FAIL		-10024 
#define cmnERR_GN_ISRESET_DEVICE_FAIL		-10025 
#define cmnERR_GN_GET_COM_STATUS_FAIL		-10026 
#define cmmERR_GN_GET_COM_SPEED_FAIL		-10027 
#define cmnERR_GN_SET_COM_SPEED		        -10028 
#define cmnERR_GN_DLG_GET_LAST_MESSAGE_FAIL     -10029
#define cmnERR_GN_DLG_GET_NO_MORE_MESSAGE_FAIL  -10030
#define cmnERR_GN_DLG_GET_BUFFER_SMALL_FAIL     -10031
#define cmnERR_GET_MASTER_INTERRUPT_STATUS      -10032
#define cmnERR_GET_SLAVE_COM_ERROR              -10033
#define cmnERR_SET_SLAVE_COM_ERROR              -10034
#define cmnERR_SET_INPUT_INTERRUPT_ENABLE       -10035
#define cmnERR_GET_INPUT_INTERRUPT_STATUS       -10036
#define cmnERR_GN_GET_GLOBAL_CHANNEL_MAP_SLAVE_ZERO_FAIL -10037
#define cmnERR_GET_RING_TOTAL					-10038
// 140619 YJB
// G9004 - AIO ߰ : TODO
#define cmnERR_AI_SET_VOLT_RANGE_MODE_FAIL		        -10039
#define cmnERR_AI_GET_VOLT_RANGE_MODE_FAIL		        -10040
#define cmnERR_AI_GET_DIGIT_RANGE_FAIL			        -10041
#define cmnERR_AI_GET_DIGIT_FAIL		        -10042
#define cmnERR_AI_GET_VOLT_FAIL		        -10043
#define cmnERR_AI_GET_CURRENT_FAIL		        -10044
#define cmnERR_AO_SET_DIGIT_FAIL		        -10045
#define cmnERR_AO_SET_VOLT_FAIL		        -10046
#define cmnERR_AO_SET_CURRENT_FAIL		        -10047
// 140714 YJB
// G9004 - Serial ߰ : TODO
#define cmnERR_SER_OPEN_PORT_FAIL			-10048
#define cmnERR_SER_CLOSE_PORT_FAIL			-10049
#define cmnERR_SER_SET_TIME_OUT_FAIL		-10050
#define cmnERR_SER_GET_TIME_OUT_FAIL		-10051
#define cmnERR_SER_IS_DATA_READY_FAIL		-10052
#define cmnERR_SER_GET_UNREAD_SIZE_FAIL		-10053
#define cmnERR_SER_READ_BYTES_FAIL			-10054
#define cmnERR_SER_WRITE_BYTES_FAIL			-10055
#define cmnERR_SER_RX_RESET_FAIL			-10056
#define cmnERR_SER_TX_RESET_FAIL			-10057

//////////////////////////////////////////////////////////////////////////
#define cmnLOGIC_A                              0
#define cmnLOGIC_B                              1
//////////////////////////////////////////////////////////////////////////
// Device Information
//////////////////////////////////////////////////////////////////////////
#define DI_00_DO_32C                            0x0
#define DI_08_DO_08C                            0x1
#define DI_16_DO_16C                            0x2
#define DI_16_DO_OOH                            0x3
#define DI_32_DO_00C                            0x4
#define DI_08_DO_08H                            DI_08_DO_08C
#define DI_00_DO_16H                            0x5
#define DI_00_DO_24C                            0x6

//////////////////////////////////////////////////////////////////////////
// AIO Slave (G9004) ġ 
//////////////////////////////////////////////////////////////////////////

#define DEV_DATA								0xB
#define AI_08A									0x11
#define AO_04V									0x18
#define AI_RTD									0x20
#define AI_TC									0x21
#define SC04_I232								0x2E
#define SC04_I485								0x2F

//////////////////////////////////////////////////////////////////////////
// Communication Speed
//////////////////////////////////////////////////////////////////////////
#define SPEED_1X    0x0		// 2.5 Mbps
#define SPEED_2X    0x1		// 5 Mbps
#define SPEED_3X    0x2		// 10Mbps
#define SPEED_4X    0x3		// 20Mbps

//////////////////////////////////////////////////////////////////////////
// Communication Status
//////////////////////////////////////////////////////////////////////////
#define RING_DISCONNECTED   0x0
#define RING_CONNECTED      0x1
#define SLAVE_ERROR         0x2
#define RING_STOP           0x3

//////////////////////////////////////////////////////////////////////////
// Exchange Dio
//////////////////////////////////////////////////////////////////////////
#define READ_EXCHANGE		0x0
#define WRITE_EXCHANGE		0x1
#define ALL_EXCHANGE		0x2

//////////////////////////////////////////////////////////////////////////
// Analog Range
//////////////////////////////////////////////////////////////////////////
#define AI_RANGE_MODE0		0x0				// -10V ~ +10V
#define AI_RANGE_MODE1		0x1				// -5V ~ +5V
#define AI_RANGE_MODE2		0x2				// -2.5V ~ +2.5V
#define AI_RANGE_MODE3		0x3				// 0V ~ +10V (0 ~ 20 mA)

//////////////////////////////////////////////////////////////////////////
// Serial Config
//////////////////////////////////////////////////////////////////////////
#define SER_TYPE_232		0x0
#define SER_TYPE_485		0x1
#define SER_TYPE_422		0x2

#define BR_075          0x0
#define BR_110          0x1
//#define BR_134_5      0x2
#define BR_150          0x2
#define BR_300          0x3
#define BR_600          0x4
#define BR_1200         0x5
#define BR_1800         0x6
#define BR_2400         0x7
#define BR_4800         0x8
#define BR_7200         0x9
#define BR_9600         0xA
#define BR_14400        0xB
#define BR_19200        0xC
#define BR_38400        0xD
#define BR_56K          0xE
#define BR_128K         0xF
#define BR_115200       0x10
#define BR_57600        0x11

#define DATA_8				0x0
#define DATA_9				0x1

#define STOP_1				0x0
#define STOP_0_5			0x1
#define STOP_2				0x2
#define STOP_1_5			0x3

#define PAR_NONE			0x0
#define PAR_ODD				0x1
#define PAR_EVEN			0x2

//////////////////////////////////////////////////////////////////////////
// Debugging
//////////////////////////////////////////////////////////////////////////
#define DEBUG_LEVEL_SUMMERY	0
#define DEBUG_LEVEL_DETAIL	1
#define DEBUG_LEVEL_DEBUG	2
#define DEBUG_LEVEL_ALL		3

#define DEBUG_DISABLE		0
#define DEBUG_ENABLE		1

#define DEBUG_OUT_WINDOW	0
#define DEBUG_OUT_LOCALFILE	1
#define DEBUG_OUT_CONSOLE	2
#define DEBUG_OUT_SOCKET	3
#define DEBUG_OUT_CALLBACK	4

//////////////////////////////////////////////////////////////////////////
//  Master ġ    ü̴.
//////////////////////////////////////////////////////////////////////////
typedef struct _tagSingleMasterDevice {
	USHORT	wSubSysID;
	ULONG	nInstance;
	char	szDevName[20];
}TCNETMasterInfo;

typedef struct _tagCMNSlaveInfo
{
	LONG nDevNumber;
	UCHAR Use:1;
	UCHAR DevType:4;
	UCHAR Reserved:3;
} TCMNSlaveInfo;


#define MAX_SLAVE	64
#define MAX_RING	2

typedef struct  
{
	TCMNSlaveInfo Dev[MAX_SLAVE];
} TCMNSlaveInfoEx;

typedef struct _tagCMNDevInfo
{
	LONG nTotalDevNumber;
	TCMNSlaveInfo  SlaveInfo[MAX_RING][MAX_SLAVE]; 
} TCMNDevInfo;

//////////////////////////////////////////////////////////////////////////
// Serial Config Structure
//////////////////////////////////////////////////////////////////////////
typedef struct {
	UCHAR Reserved00 : 1;
	UCHAR ParityBit : 3;
	UCHAR StopBit : 2;
	UCHAR DataBit : 2;	
	UCHAR BaudRate : 6;
	UCHAR SerType : 2;
} TCMNSerialInfo;

//////////////////////////////////////////////////////////////////////////
//  Slave IP   ü̴.
//////////////////////////////////////////////////////////////////////////
typedef struct _tagSingleSlaveDevice {
	LONG nDevNumber;
	UCHAR Use:1;
	UCHAR DevType:4;
	UCHAR Reserved:2;
} TCNETSingleSlaveInfo;

//////////////////////////////////////////////////////////////////////////
// 1   Slave IP   ü̴.
//////////////////////////////////////////////////////////////////////////
typedef struct _tagMultiSlaveDevice
{
	LONG nTotalDevNumber;
	TCNETSingleSlaveInfo SlaveInfo[MAX_RING][MAX_SLAVE]; 
} TCNETMultiSlaveInfo;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// User Mapped Channel  Global Channel  ϴ ü

typedef struct _tagCMNDeviceTPhysicalSlaveDevice
{
    DWORD nMasterDevNumber;
    DWORD nSlaveIpNumber;
    WORD nDevUse;
    DWORD nRingNumber;
    DWORD nDeviceType;
    DWORD nDIChannel;
    DWORD nDOChannel;
    DWORD nDIRange;
    DWORD nDORange;
} TPhysicalSlaveDevice, *PTPhysicalSlaveDevice;

typedef struct _tagCMNDeviceLogical
{
    DWORD nMasterDevNumber;
    DWORD nSlaveIpNumber;
    WORD nDevUse;
    DWORD nRingNumber;
    DWORD nDeviceType;
    DWORD nDIChannel;
    DWORD nDOChannel;
    DWORD nDIRange;
    DWORD nDORange;
} TLogicalSlaveDevice, *PTLogicalSlaveDevice;

//////////////////////////////////////////////////////////////////////////
//  
//////////////////////////////////////////////////////////////////////////
typedef struct _tagCMNChannelHeaderInfo
{
    DWORD nTotalSlaveDevice;
    DWORD nTotalDIChannels;
    DWORD nTotalDOChannels;
    DWORD nMagicNumber;
    DWORD nDate;
    DWORD nSize;
    DWORD UseTable;
} TCMNHeaderInfo;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Ʒ ü nTotalSlaveDevice ŭ Ͽ ϵȴ.
//////////////////////////////////////////////////////////////////////////
typedef struct _tagCMNChannelMapInfo
{
    TPhysicalSlaveDevice gDevice;
    TLogicalSlaveDevice  uDevice;
} TCMNChannelMapInfo;
//////////////////////////////////////////////////////////////////////////

typedef union 
{
	union 
	{
		struct  
		{
			struct  
			{
				char ch00:1;
				char ch01:1;
				char ch02:1;
				char ch03:1;
				char ch04:1;
				char ch05:1;
				char ch06:1;
				char ch07:1;
			} Port0;

			struct  
			{
				char ch00:1;
				char ch01:1;
				char ch02:1;
				char ch03:1;
				char ch04:1;
				char ch05:1;
				char ch06:1;
				char ch07:1;		
			} Port1;

			struct  
			{
				char ch00:1;
				char ch01:1;
				char ch02:1;
				char ch03:1;
				char ch04:1;
				char ch05:1;
				char ch06:1;
				char ch07:1;
			} Port2;

			struct  
			{
				char ch00:1;
				char ch01:1;
				char ch02:1;
				char ch03:1;
				char ch04:1;
				char ch05:1;
				char ch06:1;
				char ch07:1;
			} Port3;
			
		} B;
		unsigned int V;	
	} Dev[64]; // 64 * 32 = 2048
} TCMNFastIo;

//////////////////////////////////////////////////////////////////////////
// FastIo R/W Macro Functions
//////////////////////////////////////////////////////////////////////////
#define cmnDioExchange_DiGets_8(__S__,__ID__)\
__S__.Dev[__ID__].V & 0xFF

#define cmnDioExchange_DoPuts_8(__S__,__ID__,__V__)\
__S__.Dev[__ID__].V=((##__V__<<16) & 0xFF0000)

#define cmnDioExchange_DiGets_16(__S__,__ID__)\
__S__.Dev[__ID__].V= & 0xFFFF

#define cmnDioExchange_DoPuts_16(__S__,__ID__,__V__)\
__S__.Dev[__ID__].V=((##__V__<<16) & 0xFFFF0000)

#define cmnDioExchange_DiGets_32(__S__,__ID__)\
__S__.Dev[__ID__].V & 0xFFFFFFFF

#define cmnDioExchange_DoPuts_32(__S__,__ID__,__V__)\
	__S__.Dev[__ID__].V=##__V__ & 0xFFFFFFFF

#endif
