#ifndef _COMIMOTION_API_H_
#define _COMIMOTION_API_H_

// Device ID definition // 
#define COMI_LX501	0xA501
#define COMI_LX502	0xA502
#define COMI_LX504	0xA504
#define COMI_LX508	0xA508
#define COMI_LX534	0xA534

// Boolean type definition //
typedef enum _TCmBool{ 
	cmFALSE, cmTRUE
}TCmBool;

// MIO Property ID //
typedef enum _TCmMioPropId{
	cmALM_LOGIC, cmALM_MODE, cmCMP_LOGIC, cmDR_LOGIC, cmEL_LOGIC, cmEL_MODE, 
	cmERC_LOGIC, cmERC_OUT, cmEZ_LOGIC, cmINP_EN, cmINP_LOGIC, cmLTC_LOGIC, 
	cmLTC_LTC2SRC, cmORG_LOGIC, cmSD_EN, cmSD_LOGIC, cmSD_LATCH, cmSD_MODE, cmSTA_MODE,
	cmSTA_TRG, cmSTP_MODE, cmCLR_CNTR, cmCLR_SIGTYPE, cmCMP_PWIDTH, cmERC_ONTIME
}TCmMioPropId;

// Bit order of StReadMioStatuses() return value  //
typedef enum _TCmMioState{
		cmIOST_RDY, cmIOST_ALM, cmIOST_ELP, cmIOST_ELN, cmIOST_ORG, 
		cmIOST_DIR, cmIOST_RSV1, cmIOST_PCS, cmIOST_ERC, cmIOST_EZ, 
		cmIOST_CLR, cmIOST_LTC,	cmIOST_SD, cmIOST_INP, cmIOST_DRP,
		cmIOST_DRN
}TCmMioState;

// Motion operation status ID //
typedef enum _TCmMotionState{ 
	cmMST_STOP, cmMST_WAIT_DR, cmMST_WAIT_STA, cmMST_WAIT_INSYNC,
	cmMST_WAIT_OTHER, cmMST_WAIT_ERC, cmMST_WAIT_DIR, cmMST_RESERVED1, cmMST_WAIT_PLSR,
	cmMST_IN_RVSSPD, cmMST_IN_INISPD, cmMST_IN_ACC, cmMST_IN_WORKSPD, cmMST_IN_DEC,
	cmMST_WAIT_INP, cmMST_SPARE0
}TCmMotionState;

// Signal logic definition //
typedef enum _TCmSigLogic{ 
	cmLOGIC_A=0 /*Normal open*/, cmLOGIC_B=1/*Normal close*/ 
}TCmSigLogic;

// Axis index definition //
typedef enum _TCmAxis{ 
	cmX1, cmY1, cmZ1, cmU1, cmX2, cmY2, cmZ2, cmU2 
}TCmAxis;

// Definition for axes mask  //
typedef enum _TCmAxisMask{ 
	cmX1_MASK=0x1, cmY1_MASK=0x2, cmZ1_MASK=0x4, cmU1_MASK=0x8,
	cmX2_MASK=0x10, cmY2_MASK=0x20, cmZ2_MASK=0x40, cmU2_MASK=0x80
}TCmAxisMask;

// Encoder and PA/PB input mode definition //
typedef enum _TCmInMode{ 
	cmIMODE_AB1X, cmIMODE_AB2X, cmIMODE_AB4X, cmIMODE_CWCCW
}TCmInMode;

// Command output mode definition //
typedef enum _TCmOutMode{ 
	cmOMODE_PDIR0, cmOMODE_PDIR1, cmOMODE_PDIR2, cmOMODE_PDIR3,
	cmOMODE_CWCCW0, cmOMODE_CWCCW1
}TCmOutMode;
			
// Speed mode index definition //	
typedef enum _TCmSpeedMode{ 
	cmSMODE_C /*Constant */, cmSMODE_T /*Trapeziodal*/, cmSMODE_S /*S-curve*/
}TCmSpeedMode;

// (Linear)Operation direction //	
typedef enum _TCmDir{
	cmDIR_N /*(-)Dir*/, cmDIR_P /*(+)Dir*/
}TCmDir;

// Arc operation direction //
typedef enum _TCmArcDir{ 
	cmARC_CW, cmARC_CCW
}TCmArcDir;

// Counter name //
typedef enum _TCmCntr { 
	cmCNT_COMM/*Command*/, cmCNT_FEED/*Feedback*/, cmCNT_DEV/*Deviation*/, 
	cmCNT_GEN/*General*/, cmCNT_REM/*Remained*/
}TCmCntr;

// Compare Method //
typedef enum _TCmCmpMethod{
	cmDISABLE, cmEQ_BIDIR, cmEQ_PDIR, cmEQ_NDIR, cmLESS/*Cnt<Data*/, cmGREATER/*Cnt>Data*/
}TCmCmpMethod;

// Action when general comparator met the condition //
typedef enum _TCmCmpAction{
	cmEVNT_ONLY, cmEVNT_IS, cmEVNT_DS, cmEVNT_SPDCHG
}TCmCmpAction;

// Backlash/Slip correction mode //
typedef enum _TCmCorrMode{
	cmCORR_DIS, // Disable correction 
	cmCORR_BACK, // Backlash correction mode 
	cmCORR_SLIP // Slip correction mode
}TCmCorrMode;

typedef enum _TCmExtOptionId{
	cmEXOPT_SET_USE_PREREG
};

enum { STRING_TITLE, STRING_DIST, STRING_SPEED}; // ComiMotion OCX String Ӽ ID 

//************* Error codes *************************************//
#define cmERR_NONE				0
#define cmERR_MEM_ALLOC_FAIL	-290	// Memory allocation fail
#define cmERR_GLOBAL_MEM_FAIL	-292	// Global memory allocation fail
#define cmERR_ISR_CONNEC_FAIL 	-310	// ISR registration fail
#define cmERR_DIVIDE_BY_ZERO	-400	// Cause divide by zero error 
#define cmERR_WORNG_NUM_DATA	-500	// Number of data is too small or too big
#define cmERR_VER_MISMATCH		-600	// Version(of file or device) mismatch

#define cmERR_INVALID_DEVICE_ID		-1010 // Invalid device id => Load Device Ǵ SetDeviceId()...
#define cmERR_INVALID_HANDLE		-1020
#define cmERR_UNSUPORTED_FUNC		-1030 
#define cmERR_INVALID_PARAMETER		-1101
#define cmERR_INVALID_CHANNEL		-1105
#define cmERR_INVALID_INPUT_RANGE	-1111 // Invalid range value (AI, AO)
#define cmERR_INVALID_FREQ_RANGE	-1121 // Invalid input or output frequency
#define	cmERR_FILE_CREATE_FAIL		-1501 // File create fail 
#define cmERR_FILE_OPEN_FAIL		-1511 // File open fail
#define cmERR_EVENT_CREATE_FAIL		-1550 // Event handle creation fail			
#define cmERR_INT_INSTANCE_FAIL		-1560 // Interrupt event instance creation fail
#define	cmERR_DITHREAD_CRE			-1570	// D/I state change monitor thread creation fail

#define cmERR_ON_MOTION			-5001
#define cmERR_STOP_BY_SLP		-5002 // Abnormally stopped by positive soft limit
#define cmERR_STOP_BY_SLN		-5003 // Abnormally stopped by negative soft limit
#define cmERR_STOP_BY_CMP3		-5004 // Abnormally stopped by comparator3
#define cmERR_STOP_BY_CMP4		-5005 // Abnormally stopped by comparator4
#define cmERR_STOP_BY_CMP5		-5006 // Abnormally stopped by comparator5
#define cmERR_STOP_BY_ELP		-5007 // Abnormally stopped by (+) external limit
#define cmERR_STOP_BY_ELN		-5008 // Abnormally stopped by (-) external limit
#define cmERR_STOP_BY_ALM		-5009 // Abnormally stopped by alarm input signal
#define	cmERR_STOP_BY_CSTP		-5010 // Abnormally stopped by CSTP input signal
#define cmERR_STOP_BY_CEMG		-5011 // Abnormally stopped by CEMG input signal
#define cmERR_STOP_BY_SD		-5012 // Abnormally stopped by SD input signal
#define cmERR_STOP_BY_DERROR	-5013 // Abnormally stopped by operation data error
#define cmERR_STOP_BY_IP		-5014 // Abnormally stopped by other axis error during interpolation
#define cmERR_STOP_BY_PO		-5015 // An overflow occurred in the PA/PB input buffer
#define cmERR_STOP_BY_AO		-5016 // Out of range position counter during interpolation
#define cmERR_STOP_BY_EE		-5017 // An EA/EB input error occurred (does not stop)
#define cmERR_STOP_BY_PE		-5018 // An PA/PB input error occurred (does not stop)
#define cmERR_STOP_BY_SLVERR	-5019 // Abnormally stopped because slave axis has been stopped
#define cmERR_STOP_BY_SEMG		-5020 // Abnormally stopped by software emergency setting

#define cmERR_MOT_MAOMODE		-5110	// Master output mode is not CW/CCW mode // Master/Slave ۽ÿ Master output尡 CW/CCW尡 ƴϴ.
#define cmERR_MOT_SLAVE_SET		-5120	// Slave start fail (Motion state "Wait for Pulsar Input"  ʴ´.
#define cmERR_SPEED_RANGE_OVER	-5130
#define cmERR_INVALID_SPEED_SET	-5140	// Speed setting value is not valid
#define	cmERR_UNKNOWN			-9999

#endif
